/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.security.Provider;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityEntityFactory;
import org.apache.sshd.common.util.threads.ThreadUtils;

public interface SecurityProviderChoice
extends NamedResource {
    public static final SecurityProviderChoice EMPTY = new SecurityProviderChoice(){

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isNamedProviderUsed() {
            return false;
        }

        @Override
        public Provider getSecurityProvider() {
            return null;
        }

        public String toString() {
            return "EMPTY";
        }
    };

    default public boolean isNamedProviderUsed() {
        return true;
    }

    default public String getProviderName() {
        return this.getName();
    }

    default public SecurityEntityFactory getFactory() {
        if (this.isNamedProviderUsed()) {
            return new SecurityEntityFactory.Named(this.getProviderName());
        }
        return new SecurityEntityFactory.ByProvider(this.getSecurityProvider());
    }

    public Provider getSecurityProvider();

    public static SecurityProviderChoice toSecurityProviderChoice(final String name) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No name provided");
        return new SecurityProviderChoice(){
            private final String s;
            {
                this.s = SecurityProviderChoice.class.getSimpleName() + "[" + name + "]";
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isNamedProviderUsed() {
                return true;
            }

            @Override
            public Provider getSecurityProvider() {
                return null;
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static SecurityProviderChoice toSecurityProviderChoice(final Provider provider) {
        Objects.requireNonNull(provider, "No provider instance");
        return new SecurityProviderChoice(){
            private final String s;
            {
                this.s = SecurityProviderChoice.class.getSimpleName() + "[" + Provider.class.getSimpleName() + "][" + provider.getName() + "]";
            }

            @Override
            public String getName() {
                return provider.getName();
            }

            @Override
            public boolean isNamedProviderUsed() {
                return false;
            }

            @Override
            public Provider getSecurityProvider() {
                return provider;
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static Provider createProviderInstance(Class<?> anchor, String providerClassName) throws ReflectiveOperationException {
        return ThreadUtils.createDefaultInstance(anchor, Provider.class, providerClassName);
    }
}

