/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.TermsQuery;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;

class TermsIncludingScoreQuery
extends Query
implements Accountable {
    protected static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(TermsIncludingScoreQuery.class);
    private final ScoreMode scoreMode;
    private final String toField;
    private final boolean multipleValuesPerDocument;
    private final BytesRefHash terms;
    private final float[] scores;
    private final int[] ords;
    private final Query fromQuery;
    private final String fromField;
    private final Object topReaderContextId;
    private final long ramBytesUsed;

    TermsIncludingScoreQuery(ScoreMode scoreMode, String toField, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, String fromField, Query fromQuery, Object indexReaderContextId) {
        this.scoreMode = scoreMode;
        this.toField = toField;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.ords = terms.sort();
        this.fromField = fromField;
        this.fromQuery = fromQuery;
        this.topReaderContextId = indexReaderContextId;
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject((Object)fromField) + RamUsageEstimator.sizeOfObject((Object)fromQuery, (long)1024L) + RamUsageEstimator.sizeOfObject((Object)this.ords) + RamUsageEstimator.sizeOfObject((Object)scores) + RamUsageEstimator.sizeOfObject((Object)terms) + RamUsageEstimator.sizeOfObject((Object)toField);
    }

    public String toString(String string) {
        return String.format(Locale.ROOT, "TermsIncludingScoreQuery{field=%s;fromQuery=%s}", this.toField, this.fromQuery);
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.toField)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((TermsIncludingScoreQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(TermsIncludingScoreQuery other) {
        return Objects.equals((Object)this.scoreMode, (Object)other.scoreMode) && Objects.equals(this.toField, other.toField) && Objects.equals(this.fromField, other.fromField) && Objects.equals(this.fromQuery, other.fromQuery) && Objects.equals(this.topReaderContextId, other.topReaderContextId);
    }

    public int hashCode() {
        return this.classHash() + Objects.hash(new Object[]{this.scoreMode, this.toField, this.fromField, this.fromQuery, this.topReaderContextId});
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public Weight createWeight(IndexSearcher searcher, org.apache.lucene.search.ScoreMode scoreMode, final float boost) throws IOException {
        if (!scoreMode.needsScores()) {
            TermsQuery termsQuery = new TermsQuery(this.toField, this.terms, this.fromField, this.fromQuery, this.topReaderContextId);
            return searcher.rewrite((Query)termsQuery).createWeight(searcher, org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES, boost);
        }
        return new Weight(this){

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Terms terms = context.reader().terms(TermsIncludingScoreQuery.this.toField);
                if (terms != null) {
                    TermsEnum segmentTermsEnum = terms.iterator();
                    BytesRef spare = new BytesRef();
                    PostingsEnum postingsEnum = null;
                    for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                        if (!segmentTermsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare)) || (postingsEnum = segmentTermsEnum.postings(postingsEnum, 0)).advance(doc) != doc) continue;
                        float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                        if (boost == 1.0f) {
                            return Explanation.match((Number)Float.valueOf(score), (String)("Score based on join value " + segmentTermsEnum.term().utf8ToString()), (Explanation[])new Explanation[0]);
                        }
                        return Explanation.match((Number)Float.valueOf(score * boost), (String)("Score based on join value " + segmentTermsEnum.term().utf8ToString() + "^" + boost), (Explanation[])new Explanation[0]);
                    }
                }
                return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                Terms terms = context.reader().terms(TermsIncludingScoreQuery.this.toField);
                if (terms == null) {
                    return null;
                }
                long cost = (long)context.reader().maxDoc() * terms.size();
                TermsEnum segmentTermsEnum = terms.iterator();
                if (TermsIncludingScoreQuery.this.multipleValuesPerDocument) {
                    return new MVInOrderScorer(this, segmentTermsEnum, context.reader().maxDoc(), cost, boost);
                }
                return new SVInOrderScorer(this, segmentTermsEnum, context.reader().maxDoc(), cost, boost);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    class MVInOrderScorer
    extends SVInOrderScorer {
        MVInOrderScorer(Weight weight, TermsEnum termsEnum, int maxDoc, long cost, float boost) throws IOException {
            super(weight, termsEnum, maxDoc, cost, boost);
        }

        @Override
        protected void fillDocsAndScores(FixedBitSet matchingDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            PostingsEnum postingsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = postingsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (!matchingDocs.getAndSet(doc)) {
                        this.scores[doc] = score;
                    }
                    doc = postingsEnum.nextDoc();
                }
            }
        }
    }

    class SVInOrderScorer
    extends Scorer {
        final DocIdSetIterator matchingDocsIterator;
        final float[] scores;
        final long cost;
        final float boost;

        SVInOrderScorer(Weight weight, TermsEnum termsEnum, int maxDoc, long cost, float boost) throws IOException {
            super(weight);
            FixedBitSet matchingDocs = new FixedBitSet(maxDoc);
            this.scores = new float[maxDoc];
            this.fillDocsAndScores(matchingDocs, termsEnum);
            this.matchingDocsIterator = new BitSetIterator((BitSet)matchingDocs, cost);
            this.cost = cost;
            this.boost = boost;
        }

        protected void fillDocsAndScores(FixedBitSet matchingDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            PostingsEnum postingsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = postingsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    matchingDocs.set(doc);
                    this.scores[doc] = score;
                    doc = postingsEnum.nextDoc();
                }
            }
        }

        public float score() throws IOException {
            return this.scores[this.docID()] * this.boost;
        }

        public float getMaxScore(int upTo) throws IOException {
            return Float.POSITIVE_INFINITY;
        }

        public int docID() {
            return this.matchingDocsIterator.docID();
        }

        public DocIdSetIterator iterator() {
            return this.matchingDocsIterator;
        }
    }
}

