/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.kylin.common.exception.code;

public enum ErrorCodeTool implements ErrorCodeProducer {

    GET_METADATA_BACKUP_LIST_FAILED("KE-040024004"),
    SYSTEM_IN_METADATA_RECOVER("KE-040024005"),
    METADATA_BACKUP_IS_IN_PROGRESS("KE-040024006"),
    // parameter
    PARAMETER_EMPTY("KE-050040201"), PARAMETER_NOT_SPECIFY("KE-050040202"), PARAMETER_TIMESTAMP_NOT_SPECIFY(
            "KE-050040203"), PARAMETER_TIMESTAMP_COMPARE("KE-050040204"),

    // path & file
    PATH_NOT_EXISTS("KE-050041201"), FILE_ALREADY_EXISTS("KE-050041202"),
    MODEL_DUPLICATE_UUID_FAILED("KE-050041203");

    private final ErrorCode errorCode;
    private final ErrorMsg errorMsg;
    private final ErrorSuggestion errorSuggestion;

    ErrorCodeTool(String keCode) {
        this.errorCode = new ErrorCode(keCode);
        this.errorMsg = new ErrorMsg(this.errorCode.getCode());
        this.errorSuggestion = new ErrorSuggestion(this.errorCode.getCode());
    }

    @Override
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public ErrorMsg getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public ErrorSuggestion getErrorSuggest() {
        return this.errorSuggestion;
    }
}
