/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.builder.AggregationStrategyClause;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.PredicateClause;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.OptimisticLockRetryPolicyDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="aggregate")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AggregateDefinition
extends OutputDefinition<AggregateDefinition>
implements ExecutorServiceAwareDefinition<AggregateDefinition> {
    @XmlElement(name="correlationExpression", required=true)
    private ExpressionSubElementDefinition correlationExpression;
    @XmlElement(name="completionPredicate")
    @AsPredicate
    private ExpressionSubElementDefinition completionPredicate;
    @XmlElement(name="completionTimeoutExpression")
    private ExpressionSubElementDefinition completionTimeoutExpression;
    @XmlElement(name="completionSizeExpression")
    private ExpressionSubElementDefinition completionSizeExpression;
    @XmlElement(name="optimisticLockRetryPolicy")
    private OptimisticLockRetryPolicyDefinition optimisticLockRetryPolicyDefinition;
    @XmlTransient
    private ExpressionDefinition expression;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlTransient
    private ScheduledExecutorService timeoutCheckerExecutorService;
    @XmlTransient
    private AggregationRepository aggregationRepository;
    @XmlTransient
    private OptimisticLockRetryPolicy optimisticLockRetryPolicy;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String parallelProcessing;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String optimisticLocking;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private String timeoutCheckerExecutorServiceRef;
    @XmlAttribute
    private String aggregationRepositoryRef;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private String strategyMethodName;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String strategyMethodAllowNull;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String completionSize;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration")
    private String completionInterval;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration")
    private String completionTimeout;
    @XmlAttribute
    @Metadata(defaultValue="1s", javaType="java.time.Duration")
    private String completionTimeoutCheckerInterval = "1s";
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String completionFromBatchConsumer;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String completionOnNewCorrelationGroup;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String eagerCheckCompletion;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreInvalidCorrelationKeys;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String closeCorrelationKeyOnCompletion;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String discardOnCompletionTimeout;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String discardOnAggregationFailure;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String forceCompletionOnStop;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String completeAllOnStop;
    @XmlTransient
    private AggregateController aggregateController;
    @XmlAttribute
    private String aggregateControllerRef;

    public AggregateDefinition() {
    }

    public AggregateDefinition(@AsPredicate Predicate predicate) {
        this(ExpressionNodeHelper.toExpressionDefinition(predicate));
    }

    public AggregateDefinition(Expression expression) {
        this(ExpressionNodeHelper.toExpressionDefinition(expression));
    }

    public AggregateDefinition(ExpressionDefinition correlationExpression) {
        this.setExpression(correlationExpression);
        ExpressionSubElementDefinition cor = new ExpressionSubElementDefinition();
        cor.setExpressionType(correlationExpression);
        this.setCorrelationExpression(cor);
    }

    public AggregateDefinition(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        this(correlationExpression);
        this.aggregationStrategy = aggregationStrategy;
    }

    @Override
    public String toString() {
        return "Aggregate[" + this.description() + " -> " + this.getOutputs() + "]";
    }

    protected String description() {
        return this.getExpression() != null ? this.getExpression().getLabel() : "";
    }

    @Override
    public String getShortName() {
        return "aggregate";
    }

    @Override
    public String getLabel() {
        return "aggregate[" + this.description() + "]";
    }

    @Override
    public void configureChild(ProcessorDefinition<?> output) {
        ExpressionFactory model;
        ExpressionClause clause;
        ExpressionDefinition exp = this.getExpression();
        if (this.getExpression() != null && this.getExpression().getExpressionValue() != null) {
            exp = this.getExpression().getExpressionValue();
        }
        if (exp instanceof ExpressionClause && (clause = (ExpressionClause)((Object)exp)).getExpressionType() != null && (model = clause.getExpressionType()) instanceof ExpressionDefinition) {
            this.correlationExpression = new ExpressionSubElementDefinition();
            this.correlationExpression.setExpressionType((ExpressionDefinition)model);
        }
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getAggregationStrategyRef() {
        return this.strategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.strategyRef = aggregationStrategyRef;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public String getAggregationStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setAggregationStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public String getStrategyMethodAllowNull() {
        return this.strategyMethodAllowNull;
    }

    public String getStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public void setStrategyMethodAllowNull(String strategyMethodAllowNull) {
        this.strategyMethodAllowNull = strategyMethodAllowNull;
    }

    public void setCorrelationExpression(ExpressionSubElementDefinition correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public ExpressionSubElementDefinition getCorrelationExpression() {
        return this.correlationExpression;
    }

    public String getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(String completionSize) {
        this.completionSize = completionSize;
    }

    public OptimisticLockRetryPolicyDefinition getOptimisticLockRetryPolicyDefinition() {
        return this.optimisticLockRetryPolicyDefinition;
    }

    public void setOptimisticLockRetryPolicyDefinition(OptimisticLockRetryPolicyDefinition optimisticLockRetryPolicyDefinition) {
        this.optimisticLockRetryPolicyDefinition = optimisticLockRetryPolicyDefinition;
    }

    public OptimisticLockRetryPolicy getOptimisticLockRetryPolicy() {
        return this.optimisticLockRetryPolicy;
    }

    public void setOptimisticLockRetryPolicy(OptimisticLockRetryPolicy optimisticLockRetryPolicy) {
        this.optimisticLockRetryPolicy = optimisticLockRetryPolicy;
    }

    public String getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(String completionInterval) {
        this.completionInterval = completionInterval;
    }

    public String getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(String completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public String getCompletionTimeoutCheckerInterval() {
        return this.completionTimeoutCheckerInterval;
    }

    public void setCompletionTimeoutCheckerInterval(String completionTimeoutCheckerInterval) {
        this.completionTimeoutCheckerInterval = completionTimeoutCheckerInterval;
    }

    public ExpressionSubElementDefinition getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(ExpressionSubElementDefinition completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public ExpressionSubElementDefinition getCompletionTimeoutExpression() {
        return this.completionTimeoutExpression;
    }

    public void setCompletionTimeoutExpression(ExpressionSubElementDefinition completionTimeoutExpression) {
        this.completionTimeoutExpression = completionTimeoutExpression;
    }

    public ExpressionSubElementDefinition getCompletionSizeExpression() {
        return this.completionSizeExpression;
    }

    public void setCompletionSizeExpression(ExpressionSubElementDefinition completionSizeExpression) {
        this.completionSizeExpression = completionSizeExpression;
    }

    public String getCompletionFromBatchConsumer() {
        return this.completionFromBatchConsumer;
    }

    public void setCompletionFromBatchConsumer(String completionFromBatchConsumer) {
        this.completionFromBatchConsumer = completionFromBatchConsumer;
    }

    public String getCompletionOnNewCorrelationGroup() {
        return this.completionOnNewCorrelationGroup;
    }

    public void setCompletionOnNewCorrelationGroup(String completionOnNewCorrelationGroup) {
        this.completionOnNewCorrelationGroup = completionOnNewCorrelationGroup;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getOptimisticLocking() {
        return this.optimisticLocking;
    }

    public void setOptimisticLocking(String optimisticLocking) {
        this.optimisticLocking = optimisticLocking;
    }

    public String getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(String parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public String getEagerCheckCompletion() {
        return this.eagerCheckCompletion;
    }

    public void setEagerCheckCompletion(String eagerCheckCompletion) {
        this.eagerCheckCompletion = eagerCheckCompletion;
    }

    public String getIgnoreInvalidCorrelationKeys() {
        return this.ignoreInvalidCorrelationKeys;
    }

    public void setIgnoreInvalidCorrelationKeys(String ignoreInvalidCorrelationKeys) {
        this.ignoreInvalidCorrelationKeys = ignoreInvalidCorrelationKeys;
    }

    public String getCloseCorrelationKeyOnCompletion() {
        return this.closeCorrelationKeyOnCompletion;
    }

    public void setCloseCorrelationKeyOnCompletion(String closeCorrelationKeyOnCompletion) {
        this.closeCorrelationKeyOnCompletion = closeCorrelationKeyOnCompletion;
    }

    public AggregationRepository getAggregationRepository() {
        return this.aggregationRepository;
    }

    public void setAggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
    }

    public String getAggregationRepositoryRef() {
        return this.aggregationRepositoryRef;
    }

    public void setAggregationRepositoryRef(String aggregationRepositoryRef) {
        this.aggregationRepositoryRef = aggregationRepositoryRef;
    }

    public String getDiscardOnCompletionTimeout() {
        return this.discardOnCompletionTimeout;
    }

    public void setDiscardOnCompletionTimeout(String discardOnCompletionTimeout) {
        this.discardOnCompletionTimeout = discardOnCompletionTimeout;
    }

    public String getDiscardOnAggregationFailure() {
        return this.discardOnAggregationFailure;
    }

    public void setDiscardOnAggregationFailure(String discardOnAggregationFailure) {
        this.discardOnAggregationFailure = discardOnAggregationFailure;
    }

    public void setTimeoutCheckerExecutorService(ScheduledExecutorService timeoutCheckerExecutorService) {
        this.timeoutCheckerExecutorService = timeoutCheckerExecutorService;
    }

    public ScheduledExecutorService getTimeoutCheckerExecutorService() {
        return this.timeoutCheckerExecutorService;
    }

    public void setTimeoutCheckerExecutorServiceRef(String timeoutCheckerExecutorServiceRef) {
        this.timeoutCheckerExecutorServiceRef = timeoutCheckerExecutorServiceRef;
    }

    public String getTimeoutCheckerExecutorServiceRef() {
        return this.timeoutCheckerExecutorServiceRef;
    }

    public String getForceCompletionOnStop() {
        return this.forceCompletionOnStop;
    }

    public void setForceCompletionOnStop(String forceCompletionOnStop) {
        this.forceCompletionOnStop = forceCompletionOnStop;
    }

    public String getCompleteAllOnStop() {
        return this.completeAllOnStop;
    }

    public void setCompleteAllOnStop(String completeAllOnStop) {
        this.completeAllOnStop = completeAllOnStop;
    }

    public AggregateController getAggregateController() {
        return this.aggregateController;
    }

    public void setAggregateController(AggregateController aggregateController) {
        this.aggregateController = aggregateController;
    }

    public String getAggregateControllerRef() {
        return this.aggregateControllerRef;
    }

    public void setAggregateControllerRef(String aggregateControllerRef) {
        this.aggregateControllerRef = aggregateControllerRef;
    }

    public AggregateDefinition eagerCheckCompletion() {
        this.setEagerCheckCompletion(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition ignoreInvalidCorrelationKeys() {
        this.setIgnoreInvalidCorrelationKeys(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition closeCorrelationKeyOnCompletion(int capacity) {
        this.setCloseCorrelationKeyOnCompletion(Integer.toString(capacity));
        return this;
    }

    public AggregateDefinition discardOnCompletionTimeout() {
        this.setDiscardOnCompletionTimeout(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition discardOnAggregationFailure() {
        this.setDiscardOnAggregationFailure(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition completionFromBatchConsumer() {
        this.setCompletionFromBatchConsumer(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition completionOnNewCorrelationGroup() {
        this.setCompletionOnNewCorrelationGroup(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition completionSize(String completionSize) {
        this.setCompletionSize(completionSize);
        return this;
    }

    public AggregateDefinition completionSize(int completionSize) {
        this.setCompletionSize(Integer.toString(completionSize));
        return this;
    }

    public AggregateDefinition completionSize(Expression completionSize) {
        this.setCompletionSizeExpression(new ExpressionSubElementDefinition(completionSize));
        return this;
    }

    public AggregateDefinition completionInterval(long completionInterval) {
        this.setCompletionInterval(Long.toString(completionInterval));
        return this;
    }

    public AggregateDefinition completionInterval(String completionInterval) {
        this.setCompletionInterval(completionInterval);
        return this;
    }

    public AggregateDefinition completionTimeout(String completionTimeout) {
        this.setCompletionTimeout(completionTimeout);
        return this;
    }

    public AggregateDefinition completionTimeout(long completionTimeout) {
        this.setCompletionTimeout(Long.toString(completionTimeout));
        return this;
    }

    public AggregateDefinition completionTimeout(Expression completionTimeout) {
        this.setCompletionTimeoutExpression(new ExpressionSubElementDefinition(completionTimeout));
        return this;
    }

    public AggregateDefinition completionTimeoutCheckerInterval(long completionTimeoutCheckerInterval) {
        this.setCompletionTimeoutCheckerInterval(Long.toString(completionTimeoutCheckerInterval));
        return this;
    }

    public AggregationStrategyClause<AggregateDefinition> aggregationStrategy() {
        AggregationStrategyClause<AggregateDefinition> clause = new AggregationStrategyClause<AggregateDefinition>(this);
        this.setAggregationStrategy(clause);
        return clause;
    }

    @Deprecated
    public AggregationStrategyClause<AggregateDefinition> strategy() {
        return this.aggregationStrategy();
    }

    @Deprecated
    public AggregateDefinition strategy(AggregationStrategy aggregationStrategy) {
        return this.aggregationStrategy(aggregationStrategy);
    }

    public AggregateDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public AggregateDefinition aggregationStrategy(Supplier<AggregationStrategy> aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy.get());
        return this;
    }

    public AggregateDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setAggregationStrategyRef(aggregationStrategyRef);
        return this;
    }

    public AggregateDefinition aggregationStrategyMethodName(String methodName) {
        this.setAggregationStrategyMethodName(methodName);
        return this;
    }

    public AggregateDefinition aggregationStrategyMethodAllowNull() {
        this.setStrategyMethodAllowNull(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition aggregationRepository(AggregationRepository aggregationRepository) {
        this.setAggregationRepository(aggregationRepository);
        return this;
    }

    public AggregateDefinition aggregationRepository(Supplier<AggregationRepository> aggregationRepository) {
        this.setAggregationRepository(aggregationRepository.get());
        return this;
    }

    public AggregateDefinition aggregationRepositoryRef(String aggregationRepositoryRef) {
        this.setAggregationRepositoryRef(aggregationRepositoryRef);
        return this;
    }

    public AggregateDefinition completionPredicate(@AsPredicate Predicate predicate) {
        this.checkNoCompletedPredicate();
        this.setCompletionPredicate(new ExpressionSubElementDefinition(predicate));
        return this;
    }

    @AsPredicate
    public PredicateClause<AggregateDefinition> completionPredicate() {
        PredicateClause<AggregateDefinition> clause = new PredicateClause<AggregateDefinition>(this);
        this.completionPredicate(clause);
        return clause;
    }

    @AsPredicate
    public PredicateClause<AggregateDefinition> completion() {
        return this.completionPredicate();
    }

    public AggregateDefinition completion(@AsPredicate Predicate predicate) {
        return this.completionPredicate(predicate);
    }

    public AggregateDefinition forceCompletionOnStop() {
        this.setForceCompletionOnStop(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition completeAllOnStop() {
        this.setCompleteAllOnStop(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition parallelProcessing() {
        this.setParallelProcessing(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(Boolean.toString(parallelProcessing));
        return this;
    }

    public AggregateDefinition optimisticLocking() {
        this.setOptimisticLocking(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition optimisticLockRetryPolicy(OptimisticLockRetryPolicy policy) {
        this.setOptimisticLockRetryPolicy(policy);
        return this;
    }

    @Override
    public AggregateDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public AggregateDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorService(ScheduledExecutorService executorService) {
        this.setTimeoutCheckerExecutorService(executorService);
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorService(Supplier<ScheduledExecutorService> executorService) {
        this.setTimeoutCheckerExecutorService(executorService.get());
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorServiceRef(String executorServiceRef) {
        this.setTimeoutCheckerExecutorServiceRef(executorServiceRef);
        return this;
    }

    public AggregateDefinition aggregateController(AggregateController aggregateController) {
        this.setAggregateController(aggregateController);
        return this;
    }

    public AggregateDefinition aggregateController(Supplier<AggregateController> aggregateController) {
        this.setAggregateController(aggregateController.get());
        return this;
    }

    public ExpressionDefinition getExpression() {
        if (this.expression == null && this.correlationExpression != null) {
            this.expression = this.correlationExpression.getExpressionType();
        }
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    public void setExpression(Expression expression) {
        this.setExpression(new ExpressionDefinition(expression));
    }

    protected void checkNoCompletedPredicate() {
        if (this.getCompletionPredicate() != null) {
            throw new IllegalArgumentException("There is already a completionPredicate defined for this aggregator: " + this);
        }
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }
}

