/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.channel.exception.SshChannelClosedException;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriter;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;

public class ChannelOutputStream
extends OutputStream
implements java.nio.channels.Channel,
ChannelHolder {
    protected final AtomicReference<OpenState> openState = new AtomicReference<OpenState>(OpenState.OPEN);
    protected final Logger log;
    private final AbstractChannel channelInstance;
    private final ChannelStreamWriter packetWriter;
    private final RemoteWindow remoteWindow;
    private final Duration maxWaitTimeout;
    private final byte cmd;
    private final boolean eofOnClose;
    private final AtomicBoolean noDelay = new AtomicBoolean();
    private final Object bufferLock = new Object();
    private Buffer buffer;
    private int bufferLength;
    private int lastSize;
    private boolean isFlushing;

    public ChannelOutputStream(AbstractChannel channel, RemoteWindow remoteWindow, Logger log, byte cmd, boolean eofOnClose) {
        this(channel, remoteWindow, CoreModuleProperties.WAIT_FOR_SPACE_TIMEOUT.getRequired(channel), log, cmd, eofOnClose);
    }

    public ChannelOutputStream(AbstractChannel channel, RemoteWindow remoteWindow, long maxWaitTimeout, Logger log, byte cmd, boolean eofOnClose) {
        this(channel, remoteWindow, Duration.ofMillis(maxWaitTimeout), log, cmd, eofOnClose);
    }

    public ChannelOutputStream(AbstractChannel channel, RemoteWindow remoteWindow, Duration maxWaitTimeout, Logger log, byte cmd, boolean eofOnClose) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel");
        this.packetWriter = this.channelInstance.resolveChannelStreamWriter(channel, cmd);
        this.remoteWindow = Objects.requireNonNull(remoteWindow, "No remote window");
        Objects.requireNonNull(maxWaitTimeout, "No maxWaitTimeout");
        ValidateUtils.checkTrue(GenericUtils.isPositive(maxWaitTimeout), "Non-positive max. wait time: %s", (Object)maxWaitTimeout);
        this.maxWaitTimeout = maxWaitTimeout;
        this.log = Objects.requireNonNull(log, "No logger");
        this.cmd = cmd;
        this.eofOnClose = eofOnClose;
        this.buffer = this.newBuffer(0);
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channelInstance;
    }

    public byte getCommandType() {
        return this.cmd;
    }

    public boolean isEofOnClose() {
        return this.eofOnClose;
    }

    public boolean isNoDelay() {
        return this.noDelay.get();
    }

    public void setNoDelay(boolean noDelay) {
        this.noDelay.set(noDelay);
    }

    @Override
    public boolean isOpen() {
        return OpenState.OPEN == this.openState.get();
    }

    @Override
    public void write(int w) throws IOException {
        this.write(new byte[]{(byte)w}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] buf, int s, int l) throws IOException {
        AbstractChannel channel = this.getChannel();
        if (!this.isOpen()) {
            throw new SshChannelClosedException(channel.getChannelId(), "write(" + this + ") len=" + l + " - channel already closed");
        }
        Object session = channel.getSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        boolean traceEnabled = this.log.isTraceEnabled();
        boolean flushed = false;
        int nanos = this.maxWaitTimeout.getNano();
        long millisInSecond = TimeUnit.NANOSECONDS.toMillis(nanos);
        long millis = TimeUnit.SECONDS.toMillis(this.maxWaitTimeout.getSeconds()) + millisInSecond;
        nanos = (int)((long)nanos - TimeUnit.MILLISECONDS.toNanos(millisInSecond));
        block12: while (l > 0) {
            flushed = false;
            WriteState state = WriteState.BUFFERED;
            Object object = this.bufferLock;
            synchronized (object) {
                while (this.isFlushing) {
                    try {
                        this.bufferLock.wait(millis, nanos);
                    }
                    catch (InterruptedException e) {
                        InterruptedIOException interrupted = new InterruptedIOException(channel.getChannelId() + ": write interrupted waiting for flush()");
                        interrupted.initCause(e);
                        Thread.currentThread().interrupt();
                        throw interrupted;
                    }
                }
                while (l > 0) {
                    long minReqLen = Math.min(this.remoteWindow.getSize() + (long)this.lastSize, this.remoteWindow.getPacketSize());
                    long l2 = Math.min((long)l, minReqLen - (long)this.bufferLength);
                    if (l2 <= 0L) {
                        state = this.bufferLength > 0 ? WriteState.NEED_FLUSH : WriteState.NEED_SPACE;
                        session.resetIdleTimeout();
                        break;
                    }
                    ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Accumulated bytes length exceeds int boundary: %d", l2);
                    this.buffer.putRawBytes(buf, s, (int)l2);
                    this.bufferLength = (int)((long)this.bufferLength + l2);
                    s = (int)((long)s + l2);
                    l = (int)((long)l - l2);
                }
            }
            switch (state.ordinal()) {
                case 1: {
                    this.flush();
                    flushed = true;
                    session.resetIdleTimeout();
                    continue block12;
                }
                case 2: {
                    try {
                        long available = this.remoteWindow.waitForSpace(this.maxWaitTimeout);
                        if (traceEnabled) {
                            this.log.trace("write({}) len={} - available={}", new Object[]{this, l, available});
                        }
                    }
                    catch (IOException e) {
                        LoggingUtils.debug(this.log, "write({}) failed ({}) to wait for space of len={}: {}", this, e.getClass().getSimpleName(), l, e.getMessage(), e);
                        if (e instanceof WindowClosedException && OpenState.OPEN == this.openState.getAndSet(OpenState.CLOSED) && debugEnabled) {
                            this.log.debug("write({})[len={}] closing due to window closed", (Object)this, (Object)l);
                        }
                        throw e;
                    }
                    catch (InterruptedException e) {
                        throw (IOException)new InterruptedIOException("Interrupted while waiting for remote space on write len=" + l + " to " + this).initCause(e);
                    }
                    session.resetIdleTimeout();
                    continue block12;
                }
            }
        }
        if (this.isNoDelay() && !flushed) {
            this.flush();
        } else {
            session.resetIdleTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Buffer buf;
        int remaining;
        AbstractChannel channel = this.getChannel();
        if (OpenState.CLOSED.equals((Object)this.openState.get())) {
            throw new SshChannelClosedException(channel.getChannelId(), "flush(" + this + ") length=" + this.bufferLength + " - stream is already closed");
        }
        Object session = channel.getSession();
        boolean traceEnabled = this.log.isTraceEnabled();
        Object object = this.bufferLock;
        synchronized (object) {
            remaining = this.bufferLength;
            if (this.isFlushing) {
                return;
            }
            if (remaining == 0) {
                this.bufferLock.notifyAll();
                return;
            }
            this.isFlushing = true;
            buf = this.buffer;
        }
        try {
            while (remaining > 0) {
                Buffer freshBuffer;
                long available;
                session.resetIdleTimeout();
                long total = remaining;
                try {
                    available = this.remoteWindow.waitForSpace(this.maxWaitTimeout);
                    if (traceEnabled) {
                        this.log.trace("flush({}) len={}, available={}", new Object[]{this, total, available});
                    }
                }
                catch (IOException e) {
                    LoggingUtils.debug(this.log, "flush({}) failed ({}) to wait for space of len={}: {}", this, e.getClass().getSimpleName(), total, e.getMessage(), e);
                    throw e;
                }
                long lenToSend = Math.min(available, total);
                long length = Math.min(lenToSend, this.remoteWindow.getPacketSize());
                if (length > Integer.MAX_VALUE) {
                    throw new StreamCorruptedException("Accumulated " + SshConstants.getCommandMessageName(this.cmd) + " command bytes size (" + length + ") exceeds int boundaries");
                }
                int pos = buf.wpos();
                buf.wpos(this.cmd == 95 ? 14 : 10);
                buf.putUInt(length);
                buf.wpos(buf.wpos() + (int)length);
                if (total == length) {
                    freshBuffer = this.newBuffer((int)length);
                    remaining = 0;
                } else {
                    long leftover = total - length;
                    freshBuffer = this.newBuffer((int)Math.max(leftover, length));
                    freshBuffer.putRawBytes(buf.array(), pos - (int)leftover, (int)leftover);
                    remaining = (int)leftover;
                }
                Object object2 = this.bufferLock;
                synchronized (object2) {
                    this.buffer = freshBuffer;
                    this.bufferLength = remaining;
                    this.lastSize = (int)length;
                }
                session.resetIdleTimeout();
                this.remoteWindow.waitAndConsume(length, this.maxWaitTimeout);
                if (traceEnabled) {
                    this.log.trace("flush({}) send {} len={}", new Object[]{channel, SshConstants.getCommandMessageName(this.cmd), length});
                }
                this.packetWriter.writeData(buf);
                buf = freshBuffer;
            }
        }
        catch (WindowClosedException e) {
            if (OpenState.OPEN == this.openState.getAndSet(OpenState.CLOSED) && this.log.isDebugEnabled()) {
                this.log.debug("flush({}) closing due to window closed", (Object)this);
            }
            throw e;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Interrupted while waiting for remote space flush len=" + this.bufferLength + " to " + this).initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
        finally {
            Object object3 = this.bufferLock;
            synchronized (object3) {
                this.isFlushing = false;
                this.bufferLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.openState.compareAndSet(OpenState.OPEN, OpenState.CLOSING)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("close({}) closing", (Object)this);
        }
        try {
            this.flush();
            if (this.isEofOnClose()) {
                AbstractChannel channel = this.getChannel();
                channel.sendEof();
            }
        }
        finally {
            try {
                if (!(this.packetWriter instanceof Channel)) {
                    this.packetWriter.close();
                }
            }
            finally {
                this.openState.set(OpenState.CLOSED);
            }
        }
    }

    protected Buffer newBuffer(int size) {
        AbstractChannel channel = this.getChannel();
        Object session = channel.getSession();
        Buffer buf = session.createBuffer(this.cmd, size <= 0 ? 12 : 12 + size);
        buf.putUInt(channel.getRecipient());
        if (this.cmd == 95) {
            buf.putUInt(1L);
        }
        buf.putUInt(0L);
        return buf;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "] " + SshConstants.getCommandMessageName(this.cmd & 0xFF);
    }

    protected static enum OpenState {
        OPEN,
        CLOSING,
        CLOSED;

    }

    protected static enum WriteState {
        BUFFERED,
        NEED_FLUSH,
        NEED_SPACE;

    }
}

