/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.ConfigCommand;
import kafka.utils.Implicits;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ListConfigResourcesOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ConfigType;
import org.apache.kafka.server.config.QuotaConfig;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class ConfigCommand$
implements Logging {
    public static final ConfigCommand$ MODULE$ = new ConfigCommand$();
    private static final String BrokerDefaultEntityName = "";
    private static final String BrokerLoggerConfigType = "broker-loggers";
    private static final String[] kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes = (String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ConfigType.values()), (Function1 & Serializable)x$1 -> x$1.value(), ClassTag$.MODULE$.apply(String.class))), (Object)MODULE$.BrokerLoggerConfigType(), ClassTag$.MODULE$.apply(String.class));
    private static final int DefaultScramIterations = 4096;
    private static final String kafka$admin$ConfigCommand$$TopicType = ConfigType.TOPIC.value();
    private static final String kafka$admin$ConfigCommand$$ClientMetricsType = ConfigType.CLIENT_METRICS.value();
    private static final String kafka$admin$ConfigCommand$$BrokerType = ConfigType.BROKER.value();
    private static final String kafka$admin$ConfigCommand$$GroupType = ConfigType.GROUP.value();
    private static final String kafka$admin$ConfigCommand$$UserType = ConfigType.USER.value();
    private static final String kafka$admin$ConfigCommand$$ClientType = ConfigType.CLIENT.value();
    private static final String kafka$admin$ConfigCommand$$IpType = ConfigType.IP.value();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    private String BrokerDefaultEntityName() {
        return BrokerDefaultEntityName;
    }

    public String BrokerLoggerConfigType() {
        return BrokerLoggerConfigType;
    }

    public String[] kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes() {
        return kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes;
    }

    private int DefaultScramIterations() {
        return DefaultScramIterations;
    }

    public String kafka$admin$ConfigCommand$$TopicType() {
        return kafka$admin$ConfigCommand$$TopicType;
    }

    public String kafka$admin$ConfigCommand$$ClientMetricsType() {
        return kafka$admin$ConfigCommand$$ClientMetricsType;
    }

    public String kafka$admin$ConfigCommand$$BrokerType() {
        return kafka$admin$ConfigCommand$$BrokerType;
    }

    public String kafka$admin$ConfigCommand$$GroupType() {
        return kafka$admin$ConfigCommand$$GroupType;
    }

    public String kafka$admin$ConfigCommand$$UserType() {
        return kafka$admin$ConfigCommand$$UserType;
    }

    public String kafka$admin$ConfigCommand$$ClientType() {
        return kafka$admin$ConfigCommand$$ClientType;
    }

    public String kafka$admin$ConfigCommand$$IpType() {
        return kafka$admin$ConfigCommand$$IpType;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to manipulate and describe entity config for a topic, client, user, broker, ip, client-metrics or group");
            opts.checkArgs();
            this.processCommand(opts);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof UnsupportedVersionException) {
                UnsupportedVersionException unsupportedVersionException = (UnsupportedVersionException)throwable;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Unsupported API encountered in server when executing config command with args '{}'", (Object)Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" "));
                }
                System.err.println(unsupportedVersionException.getMessage());
                Exit.exit((int)1, null);
                return;
            }
            if (throwable instanceof IllegalArgumentException ? true : (throwable instanceof InvalidConfigurationException ? true : throwable instanceof OptionException)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Failed config command with args '" + Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ") + "'", throwable);
                }
                System.err.println(throwable.getMessage());
                Exit.exit((int)1, null);
                return;
            }
            if (throwable != null) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Error while executing config command with args '" + Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ") + "'", throwable);
                }
                System.err.println("Error while executing config command with args '" + Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ") + "'");
                throwable.printStackTrace(System.err);
                Exit.exit((int)1, null);
                return;
            }
            throw null;
        }
    }

    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = new Properties();
        if (opts.options.has(opts.addConfigFile())) {
            String file = (String)opts.options.valueOf(opts.addConfigFile());
            new Implicits.PropertiesOps(props).$plus$plus$eq(Utils.loadProps((String)file, null));
        }
        if (opts.options.has(opts.addConfig())) {
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)opts.options.valueOf(opts.addConfig())).split("," + pattern)), (Function1 & Serializable)x$2 -> x$2.split("\\s*=\\s*" + pattern, -1), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded), (Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(config))), (Function0 & Serializable)() -> "Invalid entity config: all configs to be added must be in the format \"key=val\" or  \"key=[val1,val2]\" to group values which contain commas.");
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded), (Function1 & Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim()));
        }
        this.validatePropsKey(props);
        return props;
    }

    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        if (opts.options.has(opts.deleteConfig())) {
            return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(opts.options.valuesOf(opts.deleteConfig())).asScala().map((Function1 & Serializable)x$3 -> x$3.trim());
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    private void validatePropsKey(Properties props) {
        props.keySet().forEach(propsKey -> {
            if (!propsKey.toString().matches("[a-zA-Z0-9._-]*")) {
                throw new IllegalArgumentException("Invalid character found for config key: " + propsKey);
            }
        });
    }

    private void processCommand(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt())), null) : new Properties();
        CommandLineUtils.initializeBootstrapProperties((OptionParser)opts.parser, (OptionSet)opts.options, (Properties)props, opts.bootstrapServerOpt(), opts.bootstrapControllerOpt());
        Admin adminClient = Admin.create((Properties)props);
        if (opts.options.has((OptionSpec)opts.alterOpt()) && opts.entityTypes().size() != opts.entityNames().size()) {
            throw new IllegalArgumentException("An entity name must be specified for every entity type");
        }
        try {
            if (opts.options.has((OptionSpec)opts.alterOpt())) {
                this.alterConfig(adminClient, opts);
            } else if (opts.options.has((OptionSpec)opts.describeOpt())) {
                this.describeConfig(adminClient, opts);
            }
        }
        finally {
            adminClient.close();
        }
    }

    public void alterConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        boolean bl;
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        String entityTypeHead = (String)entityTypes.head();
        String entityNameHead = (String)entityNames.head();
        scala.collection.immutable.Map configsToBeAddedMap = CollectionConverters$.MODULE$.PropertiesHasAsScala(this.parseConfigsToBeAdded(opts)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map configsToBeAdded = (scala.collection.immutable.Map)configsToBeAddedMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
            }
            throw new MatchError(null);
        });
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        String string = this.kafka$admin$ConfigCommand$$TopicType();
        if (!(string != null ? !string.equals(entityTypeHead) : entityTypeHead != null)) {
            bl = true;
        } else {
            String string2 = this.kafka$admin$ConfigCommand$$ClientMetricsType();
            if (!(string2 != null ? !string2.equals(entityTypeHead) : entityTypeHead != null)) {
                bl = true;
            } else {
                String string3 = this.kafka$admin$ConfigCommand$$BrokerType();
                if (!(string3 != null ? !string3.equals(entityTypeHead) : entityTypeHead != null)) {
                    bl = true;
                } else {
                    String string4 = this.kafka$admin$ConfigCommand$$GroupType();
                    bl = !(string4 != null ? !string4.equals(entityTypeHead) : entityTypeHead != null);
                }
            }
        }
        if (bl) {
            ConfigResource.Type type;
            String string5 = this.kafka$admin$ConfigCommand$$TopicType();
            if (!(string5 != null ? !string5.equals(entityTypeHead) : entityTypeHead != null)) {
                type = ConfigResource.Type.TOPIC;
            } else {
                String string6 = this.kafka$admin$ConfigCommand$$ClientMetricsType();
                if (!(string6 != null ? !string6.equals(entityTypeHead) : entityTypeHead != null)) {
                    type = ConfigResource.Type.CLIENT_METRICS;
                } else {
                    String string7 = this.kafka$admin$ConfigCommand$$BrokerType();
                    if (!(string7 != null ? !string7.equals(entityTypeHead) : entityTypeHead != null)) {
                        type = ConfigResource.Type.BROKER;
                    } else {
                        String string8 = this.kafka$admin$ConfigCommand$$GroupType();
                        if (!(string8 != null ? !string8.equals(entityTypeHead) : entityTypeHead != null)) {
                            type = ConfigResource.Type.GROUP;
                        } else {
                            throw new IllegalArgumentException(entityNameHead + " is not a valid entity-type.");
                        }
                    }
                }
            }
            ConfigResource.Type configResourceType = type;
            try {
                this.alterResourceConfig(adminClient, entityTypeHead, entityNameHead, configsToBeDeleted, (Map<String, ConfigEntry>)configsToBeAdded, configResourceType);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof UnsupportedVersionException) {
                    throw new UnsupportedVersionException("The " + ApiKeys.INCREMENTAL_ALTER_CONFIGS + " API is not supported by the cluster. The API is supported starting from version 2.3.0. You may want to use an older version of this tool to interact with your cluster, or upgrade your brokers to version 2.3.0 or newer to avoid this error.");
                }
                throw e;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        } else {
            String string9 = this.BrokerLoggerConfigType();
            if (!(string9 != null ? !string9.equals(entityTypeHead) : entityTypeHead != null)) {
                scala.collection.immutable.Seq validLoggers = (scala.collection.immutable.Seq)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, true, false).map((Function1 & Serializable)x$4 -> x$4.name());
                Seq invalidBrokerLoggers = (Seq)((IterableOps)configsToBeDeleted.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)))).$plus$plus((IterableOnce)configsToBeAdded.keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem))));
                if (invalidBrokerLoggers.nonEmpty()) {
                    throw new InvalidConfigurationException("Invalid broker logger(s): " + invalidBrokerLoggers.mkString(","));
                }
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityNameHead);
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                Iterable addEntries = (Iterable)configsToBeAdded.values().map((Function1 & Serializable)k -> new AlterConfigOp(k, AlterConfigOp.OpType.SET));
                Seq deleteEntries = (Seq)configsToBeDeleted.map((Function1 & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE));
                Collection alterEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)deleteEntries.$plus$plus((IterableOnce)addEntries)).asJavaCollection();
                adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            } else {
                boolean bl2;
                String string10 = this.kafka$admin$ConfigCommand$$UserType();
                if (!(string10 != null ? !string10.equals(entityTypeHead) : entityTypeHead != null)) {
                    bl2 = true;
                } else {
                    String string11 = this.kafka$admin$ConfigCommand$$ClientType();
                    bl2 = !(string11 != null ? !string11.equals(entityTypeHead) : entityTypeHead != null);
                }
                if (bl2) {
                    boolean hasQuotaConfigsToAdd = configsToBeAdded.keys().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(QuotaConfig.isClientOrUserQuotaConfig((String)x$1))));
                    scala.collection.immutable.Map scramConfigsToAddMap = (scala.collection.immutable.Map)configsToBeAdded.filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$8(entry)));
                    Iterable unknownConfigsToAdd = (Iterable)configsToBeAdded.keys().filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$9(key)));
                    boolean hasQuotaConfigsToDelete = configsToBeDeleted.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(QuotaConfig.isClientOrUserQuotaConfig((String)x$1))));
                    Seq scramConfigsToDelete = (Seq)configsToBeDeleted.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$11(x$1)));
                    Seq unknownConfigsToDelete = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$12(key)));
                    String string12 = entityTypeHead;
                    String string13 = this.kafka$admin$ConfigCommand$$ClientType();
                    if (!(string12 == null ? string13 != null : !string12.equals(string13)) || entityTypes.size() == 2) {
                        if (unknownConfigsToAdd.nonEmpty() || scramConfigsToAddMap.nonEmpty()) {
                            throw new IllegalArgumentException("Only quota configs can be added for '" + this.kafka$admin$ConfigCommand$$ClientType() + "' using --bootstrap-server. Unexpected config names: " + unknownConfigsToAdd.$plus$plus((IterableOnce)scramConfigsToAddMap.keys()));
                        }
                        if (unknownConfigsToDelete.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                            throw new IllegalArgumentException("Only quota configs can be deleted for '" + this.kafka$admin$ConfigCommand$$ClientType() + "' using --bootstrap-server. Unexpected config names: " + unknownConfigsToDelete.$plus$plus((IterableOnce)scramConfigsToDelete));
                        }
                    } else {
                        if (unknownConfigsToAdd.nonEmpty()) {
                            throw new IllegalArgumentException("Only quota and SCRAM credential configs can be added for '" + this.kafka$admin$ConfigCommand$$UserType() + "' using --bootstrap-server. Unexpected config names: " + unknownConfigsToAdd);
                        }
                        if (unknownConfigsToDelete.nonEmpty()) {
                            throw new IllegalArgumentException("Only quota and SCRAM credential configs can be deleted for '" + this.kafka$admin$ConfigCommand$$UserType() + "' using --bootstrap-server. Unexpected config names: " + unknownConfigsToDelete);
                        }
                        if (scramConfigsToAddMap.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                            if (entityNames.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty()))) {
                                throw new IllegalArgumentException("The use of --entity-default or --user-defaults is not allowed with User SCRAM Credentials using --bootstrap-server.");
                            }
                            if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                                throw new IllegalArgumentException("Cannot alter both quota and SCRAM credential configs simultaneously for '" + this.kafka$admin$ConfigCommand$$UserType() + "' using --bootstrap-server.");
                            }
                        }
                    }
                    if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                        this.alterQuotaConfigs(adminClient, entityTypes, entityNames, (Map<String, String>)configsToBeAddedMap, configsToBeDeleted);
                    } else {
                        if (entityNames.size() != 1) {
                            throw new IllegalStateException("Altering user SCRAM credentials should never occur for more zero or multiple users: " + entityNames);
                        }
                        this.alterUserScramCredentialConfigs(adminClient, (String)entityNames.head(), (Map<String, ConfigEntry>)scramConfigsToAddMap, (Seq<String>)scramConfigsToDelete);
                    }
                } else {
                    String string14 = this.kafka$admin$ConfigCommand$$IpType();
                    if (!(string14 != null ? !string14.equals(entityTypeHead) : entityTypeHead != null)) {
                        Iterable unknownConfigs = (Iterable)((IterableOps)configsToBeAdded.keys().$plus$plus(configsToBeDeleted)).filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$14(key)));
                        if (unknownConfigs.nonEmpty()) {
                            throw new IllegalArgumentException("Only connection quota configs can be added for '" + this.kafka$admin$ConfigCommand$$IpType() + "' using --bootstrap-server. Unexpected config names: " + unknownConfigs.mkString(","));
                        }
                        this.alterQuotaConfigs(adminClient, entityTypes, entityNames, (Map<String, String>)configsToBeAddedMap, configsToBeDeleted);
                    } else {
                        throw new IllegalArgumentException("Unsupported entity type: " + entityTypeHead);
                    }
                }
            }
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(entityNameHead))) {
            System.out.println("Completed updating config for " + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entityTypeHead), 1) + " " + entityNameHead + ".");
            return;
        }
        System.out.println("Completed updating default config for " + entityTypeHead + " in the cluster.");
    }

    private Void alterUserScramCredentialConfigs(Admin adminClient, String user, Map<String, ConfigEntry> scramConfigsToAddMap, Seq<String> scramConfigsToDelete) {
        Seq deletions = (Seq)scramConfigsToDelete.map((Function1 & Serializable)mechanismName -> new UserScramCredentialDeletion(user, ScramMechanism.fromMechanismName((String)mechanismName)));
        Iterable upsertions = (Iterable)scramConfigsToAddMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void var7_7;
                void var6_6;
                String mechanismName = (String)x0$1._1();
                ConfigEntry configEntry = (ConfigEntry)x0$1._2();
                Tuple2 tuple2 = this.iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism.forMechanismName((String)mechanismName), configEntry.value());
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Integer iterations = (Integer)tuple2._1();
                byte[] passwordBytes = (byte[])tuple2._2();
                return new UserScramCredentialUpsertion(user, new ScramCredentialInfo(ScramMechanism.fromMechanismName((String)mechanismName), Predef$.MODULE$.Integer2int((Integer)var6_6)), (byte[])var7_7);
            }
            throw new MatchError(null);
        });
        return (Void)adminClient.alterUserScramCredentials(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)deletions.$plus$plus((IterableOnce)upsertions)).toList()).asJava()).all().get(60L, TimeUnit.SECONDS);
    }

    private Void alterQuotaConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames, Map<String, String> configsToBeAddedMap, Seq<String> configsToBeDeleted) {
        Map<String, Double> oldConfig = this.getClientQuotasConfig(adminClient, entityTypes, entityNames);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException("Invalid config(s): " + invalidConfigs.mkString(","));
        }
        List alterEntityTypes = entityTypes.map((Function1 & Serializable)x0$1 -> {
            String string = MODULE$.kafka$admin$ConfigCommand$$UserType();
            if (!(string != null ? !string.equals(x0$1) : x0$1 != null)) {
                return "user";
            }
            String string2 = MODULE$.kafka$admin$ConfigCommand$$ClientType();
            if (!(string2 != null ? !string2.equals(x0$1) : x0$1 != null)) {
                return "client-id";
            }
            String string3 = MODULE$.kafka$admin$ConfigCommand$$IpType();
            if (!(string3 != null ? !string3.equals(x0$1) : x0$1 != null)) {
                return "ip";
            }
            throw new IllegalArgumentException("Unexpected entity type: " + x0$1);
        });
        List alterEntityNames = entityNames.map((Function1 & Serializable)en -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(en))) {
                return en;
            }
            return null;
        });
        HashMap alterEntityMap = new HashMap();
        ((List)alterEntityTypes.zip((IterableOnce)alterEntityNames)).foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return alterEntityMap.put(k, v);
            }
            throw new MatchError(null);
        });
        ClientQuotaEntity entity = new ClientQuotaEntity(alterEntityMap);
        AlterClientQuotasOptions alterOptions = new AlterClientQuotasOptions().validateOnly(false);
        Collection alterOps = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOps)configsToBeAddedMap.map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                double d;
                String key = (String)x0$3._1();
                String value = (String)x0$3._2();
                try {
                    d = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot parse quota configuration value for " + key + ": " + value);
                }
                double doubleValue = d;
                return new ClientQuotaAlteration.Op(key, Predef$.MODULE$.double2Double(doubleValue));
            }
            throw new MatchError(null);
        })).$plus$plus((IterableOnce)configsToBeDeleted.map((Function1 & Serializable)key -> new ClientQuotaAlteration.Op(key, null)))).asJavaCollection();
        return (Void)adminClient.alterClientQuotas(Collections.singleton(new ClientQuotaAlteration(entity, alterOps)), alterOptions).all().get(60L, TimeUnit.SECONDS);
    }

    public void describeConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        boolean bl;
        boolean bl2;
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        boolean describeAll = opts.options.has((OptionSpec)opts.allOpt());
        String string = (String)entityTypes.head();
        String string2 = this.kafka$admin$ConfigCommand$$TopicType();
        if (!(string2 != null ? !string2.equals(string) : string != null)) {
            bl2 = true;
        } else {
            String string3 = this.kafka$admin$ConfigCommand$$BrokerType();
            if (!(string3 != null ? !string3.equals(string) : string != null)) {
                bl2 = true;
            } else {
                String string4 = this.BrokerLoggerConfigType();
                if (!(string4 != null ? !string4.equals(string) : string != null)) {
                    bl2 = true;
                } else {
                    String string5 = this.kafka$admin$ConfigCommand$$ClientMetricsType();
                    if (!(string5 != null ? !string5.equals(string) : string != null)) {
                        bl2 = true;
                    } else {
                        String string6 = this.kafka$admin$ConfigCommand$$GroupType();
                        bl2 = !(string6 != null ? !string6.equals(string) : string != null);
                    }
                }
            }
        }
        if (bl2) {
            this.describeResourceConfig(adminClient, (String)entityTypes.head(), (Option<String>)entityNames.headOption(), describeAll);
            return;
        }
        String string7 = this.kafka$admin$ConfigCommand$$UserType();
        if (!(string7 != null ? !string7.equals(string) : string != null)) {
            bl = true;
        } else {
            String string8 = this.kafka$admin$ConfigCommand$$ClientType();
            bl = !(string8 != null ? !string8.equals(string) : string != null);
        }
        if (bl) {
            this.describeClientQuotaAndUserScramCredentialConfigs(adminClient, entityTypes, entityNames);
            return;
        }
        String string9 = this.kafka$admin$ConfigCommand$$IpType();
        if (!(string9 != null ? !string9.equals(string) : string != null)) {
            this.describeQuotaConfigs(adminClient, entityTypes, entityNames);
            return;
        }
        throw new IllegalArgumentException("Invalid entity type: " + string);
    }

    private void describeResourceConfig(Admin adminClient, String entityType, Option<String> entityName, boolean describeAll) {
        Object object = new Object();
        try {
            if (!describeAll) {
                entityName.foreach((Function1 & Serializable)name -> {
                    ConfigCommand$.$anonfun$describeResourceConfig$1(entityType, adminClient, object, name);
                    return BoxedUnit.UNIT;
                });
            }
            ((scala.collection.immutable.Iterable)entityName.map((Function1 & Serializable)name -> new .colon.colon(name, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable)() -> {
                boolean bl;
                String string = MODULE$.kafka$admin$ConfigCommand$$TopicType();
                if (!(string != null ? !string.equals(entityType) : entityType != null)) {
                    return CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).asScala().toSeq();
                }
                String string2 = MODULE$.kafka$admin$ConfigCommand$$BrokerType();
                if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
                    bl = true;
                } else {
                    String string3 = MODULE$.BrokerLoggerConfigType();
                    bl = !(string3 != null ? !string3.equals(entityType) : entityType != null);
                }
                if (bl) {
                    return (scala.collection.immutable.Iterable)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.describeCluster(new DescribeClusterOptions()).nodes().get()).asScala().map((Function1 & Serializable)x$12 -> x$12.idString())).toSeq().$colon$plus((Object)MODULE$.BrokerDefaultEntityName());
                }
                String string4 = MODULE$.kafka$admin$ConfigCommand$$ClientMetricsType();
                if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
                    return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.listConfigResources(java.util.Set.of(ConfigResource.Type.CLIENT_METRICS), new ListConfigResourcesOptions()).all().get()).asScala().map((Function1 & Serializable)x$13 -> x$13.name())).toSeq();
                }
                String string5 = MODULE$.kafka$admin$ConfigCommand$$GroupType();
                if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
                    return (scala.collection.immutable.Iterable)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.listGroups().all().get()).asScala().map((Function1 & Serializable)x$14 -> x$14.groupId())).toSet().$plus$plus((IterableOnce)MODULE$.listGroupConfigResources(adminClient).map((Function1 & Serializable)resources -> ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resources).asScala().map((Function1 & Serializable)x$15 -> x$15.name())).toSet()).getOrElse((Function0 & Serializable)() -> (Set)Set$.MODULE$.empty()));
                }
                throw new IllegalArgumentException("Invalid entity type: " + entityType);
            })).foreach((Function1 & Serializable)entity -> {
                ConfigCommand$.$anonfun$describeResourceConfig$15(entityType, describeAll, adminClient, entity);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private void alterResourceConfig(Admin adminClient, String entityTypeHead, String entityNameHead, Seq<String> configsToBeDeleted, Map<String, ConfigEntry> configsToBeAdded, ConfigResource.Type resourceType) {
        scala.collection.immutable.Map oldConfig = ((IterableOnceOps)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable)entry -> new Tuple2((Object)entry.name(), entry))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException("Invalid config(s): " + invalidConfigs.mkString(","));
        }
        ConfigResource configResource = new ConfigResource(resourceType, entityNameHead);
        AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
        Iterable addEntries = (Iterable)configsToBeAdded.values().map((Function1 & Serializable)k -> new AlterConfigOp(k, AlterConfigOp.OpType.SET));
        Seq deleteEntries = (Seq)configsToBeDeleted.map((Function1 & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE));
        Collection alterEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)deleteEntries.$plus$plus((IterableOnce)addEntries)).asJavaCollection();
        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<ConfigEntry> getResourceConfig(Admin adminClient, String entityType, String entityName, boolean includeSynonyms, boolean describeAll) {
        void var6_7;
        void var7_8;
        Some some;
        ConfigResource.Type type;
        String string = this.kafka$admin$ConfigCommand$$TopicType();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(entityName))) {
                Topic.validate((String)entityName);
            }
            type = ConfigResource.Type.TOPIC;
            some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG);
        } else {
            String string2 = this.kafka$admin$ConfigCommand$$BrokerType();
            if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
                String string3 = this.BrokerDefaultEntityName();
                if (!(string3 != null ? !string3.equals(entityName) : entityName != null)) {
                    type = ConfigResource.Type.BROKER;
                    some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG);
                } else {
                    ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    type = ConfigResource.Type.BROKER;
                    some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG);
                }
            } else {
                String string4 = this.BrokerLoggerConfigType();
                if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(entityName))) {
                        ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    }
                    type = ConfigResource.Type.BROKER_LOGGER;
                    some = None$.MODULE$;
                } else {
                    String string5 = this.kafka$admin$ConfigCommand$$ClientMetricsType();
                    if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
                        type = ConfigResource.Type.CLIENT_METRICS;
                        some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_CLIENT_METRICS_CONFIG);
                    } else {
                        String string6 = this.kafka$admin$ConfigCommand$$GroupType();
                        if (!(string6 != null ? !string6.equals(entityType) : entityType != null)) {
                            type = ConfigResource.Type.GROUP;
                            some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_GROUP_CONFIG);
                        } else {
                            throw new IllegalArgumentException("Invalid entity type: " + entityType);
                        }
                    }
                }
            }
        }
        Some some2 = some;
        ConfigResource.Type configResourceType = type;
        Option dynamicConfigSource = (Option)some2;
        None$ configSourceFilter = describeAll ? None$.MODULE$ : var7_8;
        ConfigResource configResource = new ConfigResource((ConfigResource.Type)var6_7, entityName);
        DescribeConfigsOptions describeOptions = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOptions).all().get(30L, TimeUnit.SECONDS);
        return (scala.collection.immutable.Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)configs.get(configResource)).entries()).asScala().filter(arg_0 -> ConfigCommand$.$anonfun$getResourceConfig$1$adapted((Option)configSourceFilter, arg_0))).toSeq().sortBy((Function1 & Serializable)entry -> entry.name(), (Ordering)Ordering.String$.MODULE$);
    }

    private void describeQuotaConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames).foreachEntry((Function2 & Serializable)(entity, entries) -> {
            ConfigCommand$.$anonfun$describeQuotaConfigs$1(entity, entries);
            return BoxedUnit.UNIT;
        });
    }

    private void describeClientQuotaAndUserScramCredentialConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        this.describeQuotaConfigs(adminClient, entityTypes, entityNames);
        if (!entityTypes.contains((Object)this.kafka$admin$ConfigCommand$$ClientType()) && !entityNames.contains((Object)"")) {
            DescribeUserScramCredentialsResult result = adminClient.describeUserScramCredentials(CollectionConverters$.MODULE$.SeqHasAsJava(entityNames).asJava());
            CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)result.users().get(30L, TimeUnit.SECONDS)).asScala().foreach((Function1 & Serializable)user -> {
                ConfigCommand$.$anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(result, user);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Map<String, Double> getClientQuotasConfig(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        if (entityTypes.size() != entityNames.size()) {
            throw new IllegalArgumentException("Exactly one entity name must be specified for every entity type");
        }
        return (Map)this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames).headOption().map((Function1 & Serializable)x$17 -> CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)x$17._2()).asScala()).getOrElse((Function0 & Serializable)() -> (Map)Map$.MODULE$.empty());
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> getAllClientQuotasConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        List components = ((List)entityTypes.map((Function1 & Serializable)x$18 -> new Some(x$18)).zipAll((Iterable)entityNames.map((Function1 & Serializable)x$19 -> new Some(x$19)), (Object)None$.MODULE$, (Object)None$.MODULE$)).map(ConfigCommand$::$anonfun$getAllClientQuotasConfigs$3);
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)adminClient.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)components).asJava())).entities().get(30L, TimeUnit.SECONDS)).asScala();
    }

    private Option<Collection<ConfigResource>> listGroupConfigResources(Admin adminClient) {
        try {
            return new Some(adminClient.listConfigResources(java.util.Set.of(ConfigResource.Type.GROUP), new ListConfigResourcesOptions()).all().get());
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof UnsupportedVersionException) {
                return None$.MODULE$;
            }
            if (executionException.getCause() instanceof ClusterAuthorizationException) {
                return None$.MODULE$;
            }
            throw executionException.getCause();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public boolean isValidIpEntity(String ip) {
        try {
            InetAddress.getByName(ip);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$2(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$8(Tuple2 entry) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)((String)entry._1()));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$9(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || Predef$.MODULE$.Boolean2boolean(QuotaConfig.isClientOrUserQuotaConfig((String)key));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$11(String x$1) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$12(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || Predef$.MODULE$.Boolean2boolean(QuotaConfig.isClientOrUserQuotaConfig((String)key));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$14(String key) {
        return QuotaConfig.ipConfigs().names().contains(key);
    }

    /*
     * WARNING - void declaration
     */
    private final Tuple2 iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism mechanism, String credentialStr) {
        void var6_6;
        void var7_7;
        String iterations;
        Option option;
        Regex pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:iterations=(\\-?[0-9]*),)?password=(.*)"));
        if (credentialStr != null && !(option = pattern.unapplySeq((CharSequence)credentialStr)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            iterations = (String)((LinearSeqOps)option.get()).apply(0);
            String password = (String)((LinearSeqOps)option.get()).apply(1);
        } else {
            throw new IllegalArgumentException("Invalid credential property " + mechanism + "=" + credentialStr);
        }
        int iterations2 = iterations != null && !iterations.equals("-1") ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(iterations)) : this.DefaultScramIterations();
        if (var7_7 < mechanism.minIterations()) {
            throw new IllegalArgumentException("Iterations " + (int)var7_7 + " is less than the minimum " + mechanism.minIterations() + " required for " + mechanism.mechanismName());
        }
        return new Tuple2((Object)Predef$.MODULE$.int2Integer((int)var7_7), (Object)var6_6.getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ boolean $anonfun$describeResourceConfig$5(String name$1, Collection resources) {
        return resources.stream().noneMatch(x$11 -> {
            String string = x$11.name();
            return !(string != null ? !string.equals(name$1) : name$1 != null);
        });
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$1(String entityType$1, Admin adminClient$1, Object nonLocalReturnKey1$1, String name) {
        boolean bl;
        String string = MODULE$.kafka$admin$ConfigCommand$$TopicType();
        if (!(string != null ? !string.equals(entityType$1) : entityType$1 != null)) {
            Topic.validate((String)name);
            if (!((java.util.Set)adminClient$1.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).contains(name)) {
                System.out.println("The " + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entityType$1), 1) + " '" + name + "' doesn't exist and doesn't have dynamic config.");
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            return;
        }
        String string2 = MODULE$.kafka$admin$ConfigCommand$$BrokerType();
        if (!(string2 != null ? !string2.equals(entityType$1) : entityType$1 != null)) {
            bl = true;
        } else {
            String string3 = MODULE$.BrokerLoggerConfigType();
            bl = !(string3 != null ? !string3.equals(entityType$1) : entityType$1 != null);
        }
        if (bl) {
            if (((Collection)adminClient$1.describeCluster().nodes().get()).stream().anyMatch(x$8 -> {
                String string = x$8.idString();
                return !(string != null ? !string.equals(name) : name != null);
            })) {
                return;
            }
            String string4 = name;
            String string5 = MODULE$.BrokerDefaultEntityName();
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return;
            }
            System.out.println("The " + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entityType$1), 1) + " '" + name + "' doesn't exist and doesn't have dynamic config.");
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        String string6 = MODULE$.kafka$admin$ConfigCommand$$ClientMetricsType();
        if (!(string6 != null ? !string6.equals(entityType$1) : entityType$1 != null)) {
            if (((Collection)adminClient$1.listConfigResources(java.util.Set.of(ConfigResource.Type.CLIENT_METRICS), new ListConfigResourcesOptions()).all().get()).stream().noneMatch(x$9 -> {
                String string = x$9.name();
                return !(string != null ? !string.equals(name) : name != null);
            })) {
                System.out.println("The " + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entityType$1), 1) + " '" + name + "' doesn't exist and doesn't have dynamic config.");
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            return;
        }
        String string7 = MODULE$.kafka$admin$ConfigCommand$$GroupType();
        if (!(string7 != null ? !string7.equals(entityType$1) : entityType$1 != null)) {
            if (((Collection)adminClient$1.listGroups().all().get()).stream().noneMatch(x$10 -> {
                String string = x$10.groupId();
                return !(string != null ? !string.equals(name) : name != null);
            }) && MODULE$.listGroupConfigResources(adminClient$1).exists((Function1 & Serializable)resources -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$describeResourceConfig$5(name, resources)))) {
                System.out.println("The " + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entityType$1), 1) + " '" + name + "' doesn't exist and doesn't have dynamic config.");
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            return;
        }
        throw new IllegalArgumentException("Invalid entity type: " + entityType$1);
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$16(ConfigEntry entry) {
        String synonyms = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(entry.synonyms()).asScala().map((Function1 & Serializable)synonym -> synonym.source() + ":" + synonym.name() + "=" + synonym.value())).mkString(", ");
        System.out.println("  " + entry.name() + "=" + entry.value() + " sensitive=" + entry.isSensitive() + " synonyms={" + synonyms + "}");
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$15(String entityType$1, boolean describeAll$1, Admin adminClient$1, String entity) {
        String string = MODULE$.BrokerDefaultEntityName();
        if (!(string != null ? !string.equals(entity) : entity != null)) {
            System.out.println("Default configs for " + entityType$1 + " in the cluster are:");
        } else {
            String configSourceStr = describeAll$1 ? "All" : "Dynamic";
            System.out.println(configSourceStr + " configs for " + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entityType$1), 1) + " " + entity + " are:");
        }
        MODULE$.getResourceConfig(adminClient$1, entityType$1, entity, true, describeAll$1).foreach((Function1 & Serializable)entry -> {
            ConfigCommand$.$anonfun$describeResourceConfig$16(entry);
            return BoxedUnit.UNIT;
        });
    }

    private static final void validateBrokerId$1(String entityName$1, String entityType$2) {
        try {
            StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(entityName$1));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The entity name for " + entityType$2 + " must be a valid integer broker id, found: " + entityName$1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getResourceConfig$1(Option configSourceFilter$1, ConfigEntry entry) {
        if (configSourceFilter$1 instanceof Some) {
            ConfigEntry.ConfigSource configSource = (ConfigEntry.ConfigSource)((Some)configSourceFilter$1).value();
            ConfigEntry.ConfigSource configSource2 = entry.source();
            return !(configSource2 != null ? !configSource2.equals(configSource) : configSource != null);
        }
        if (None$.MODULE$.equals(configSourceFilter$1)) {
            return true;
        }
        throw new MatchError((Object)configSourceFilter$1);
    }

    private static final Option entitySubstr$1(String entityType, scala.collection.mutable.Map entityEntries$1) {
        return entityEntries$1.get((Object)entityType).map((Function1 & Serializable)name -> {
            String string;
            block6: {
                switch (entityType == null ? 0 : entityType.hashCode()) {
                    case -1904137635: {
                        if (!"client-id".equals(entityType)) break;
                        string = "client-id";
                        break block6;
                    }
                    case 3367: {
                        if (!"ip".equals(entityType)) break;
                        string = "ip";
                        break block6;
                    }
                    case 3599307: {
                        if (!"user".equals(entityType)) break;
                        string = "user-principal";
                        break block6;
                    }
                }
                throw new MatchError((Object)entityType);
            }
            String typeStr = string;
            if (name != null) {
                return typeStr + " '" + name + "'";
            }
            return "the default " + typeStr;
        });
    }

    public static final /* synthetic */ void $anonfun$describeQuotaConfigs$1(ClientQuotaEntity entity, java.util.Map entries) {
        scala.collection.mutable.Map entityEntries = CollectionConverters$.MODULE$.MapHasAsScala(entity.entries()).asScala();
        String entityStr = ((IterableOnceOps)((IterableOps)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("user", entityEntries)).$plus$plus((IterableOnce)ConfigCommand$.entitySubstr$1("client-id", entityEntries))).$plus$plus((IterableOnce)ConfigCommand$.entitySubstr$1("ip", entityEntries))).mkString(", ");
        String entriesStr = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(entries).asScala().map((Function1 & Serializable)e -> e._1() + "=" + e._2())).mkString(", ");
        System.out.println("Quota configs for " + entityStr + " are " + entriesStr);
    }

    public static final /* synthetic */ void $anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(DescribeUserScramCredentialsResult result$1, String user) {
        try {
            UserScramCredentialsDescription description = (UserScramCredentialsDescription)result$1.description(user).get(30L, TimeUnit.SECONDS);
            String descriptionText = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(description.credentialInfos()).asScala().map((Function1 & Serializable)info -> info.mechanism().mechanismName() + "=iterations=" + info.iterations())).mkString(", ");
            System.out.println("SCRAM credential configs for user-principal '" + user + "' are " + descriptionText);
            return;
        }
        catch (Exception e) {
            System.out.println("Error retrieving SCRAM credential configs for user-principal '" + user + "': " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ClientQuotaFilterComponent $anonfun$getAllClientQuotasConfigs$3(Tuple2 x0$1) {
        block8: {
            block10: {
                block11: {
                    block9: {
                        if (x0$1 == null) break block8;
                        entityTypeOpt = (Option)x0$1._1();
                        entityNameOpt = (Option)x0$1._2();
                        var4_3 = false;
                        var5_4 = null;
                        if (!(entityTypeOpt instanceof Some)) break block9;
                        var4_3 = true;
                        var5_4 = (Some)entityTypeOpt;
                        var6_5 = (String)var5_4.value();
                        v0 = ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$UserType();
                        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) break block9;
                        v1 = "user";
                        break block10;
                    }
                    if (!var4_3) break block11;
                    var7_6 = (String)var5_4.value();
                    v2 = ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$ClientType();
                    if (v2 != null ? v2.equals(var7_6) == false : var7_6 != null) break block11;
                    v1 = "client-id";
                    break block10;
                }
                if (!var4_3) ** GOTO lbl-1000
                var8_7 = (String)var5_4.value();
                v3 = ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$IpType();
                if (!(v3 != null ? v3.equals(var8_7) == false : var8_7 != null)) {
                    v1 = "ip";
                } else lbl-1000:
                // 2 sources

                {
                    if (var4_3) {
                        throw new IllegalArgumentException("Unexpected entity type " + entityTypeOpt.get());
                    }
                    if (None$.MODULE$.equals(entityTypeOpt)) {
                        throw new IllegalArgumentException("More entity names specified than entity types");
                    }
                    throw new MatchError((Object)entityTypeOpt);
                }
            }
            entityType = v1;
            var9_9 = false;
            var10_10 = null;
            if (entityNameOpt instanceof Some) {
                var9_9 = true;
                var10_10 = (Some)entityNameOpt;
                var11_11 = (String)var10_10.value();
                if ("".equals(var11_11)) {
                    return ClientQuotaFilterComponent.ofDefaultEntity((String)entityType);
                }
            }
            if (var9_9) {
                name = (String)var10_10.value();
                return ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name);
            }
            if (None$.MODULE$.equals(entityNameOpt)) {
                return ClientQuotaFilterComponent.ofEntityType((String)entityType);
            }
            throw new MatchError((Object)entityNameOpt);
        }
        throw new MatchError(null);
    }

    private ConfigCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$getResourceConfig$1$adapted(Option configSourceFilter$1, ConfigEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$getResourceConfig$1(configSourceFilter$1, entry));
    }
}

