/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.coordinator.group.generated.StreamsGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.streams.TasksTuple;

public record TasksTupleWithEpochs(Map<String, Map<Integer, Integer>> activeTasksWithEpochs, Map<String, Set<Integer>> standbyTasks, Map<String, Set<Integer>> warmupTasks) {
    public static final TasksTupleWithEpochs EMPTY = new TasksTupleWithEpochs(Map.of(), Map.of(), Map.of());

    public TasksTupleWithEpochs {
        activeTasksWithEpochs = Collections.unmodifiableMap(Objects.requireNonNull(activeTasksWithEpochs));
        standbyTasks = Collections.unmodifiableMap(Objects.requireNonNull(standbyTasks));
        warmupTasks = Collections.unmodifiableMap(Objects.requireNonNull(warmupTasks));
    }

    public boolean isEmpty() {
        return this.activeTasksWithEpochs.isEmpty() && this.standbyTasks.isEmpty() && this.warmupTasks.isEmpty();
    }

    public TasksTupleWithEpochs merge(TasksTupleWithEpochs other) {
        HashMap<String, Map<Integer, Integer>> mergedActive = new HashMap<String, Map<Integer, Integer>>();
        this.activeTasksWithEpochs.forEach((subtopologyId, partitionsWithEpochs) -> mergedActive.put((String)subtopologyId, new HashMap(partitionsWithEpochs)));
        other.activeTasksWithEpochs.forEach((subtopologyId, partitionsWithEpochs) -> mergedActive.computeIfAbsent((String)subtopologyId, k -> new HashMap()).putAll(partitionsWithEpochs));
        Map<String, Set<Integer>> mergedStandby = TasksTupleWithEpochs.mergeTasks(this.standbyTasks, other.standbyTasks);
        Map<String, Set<Integer>> mergedWarmup = TasksTupleWithEpochs.mergeTasks(this.warmupTasks, other.warmupTasks);
        return new TasksTupleWithEpochs(mergedActive, mergedStandby, mergedWarmup);
    }

    public static TasksTupleWithEpochs fromCurrentAssignmentRecord(List<StreamsGroupCurrentMemberAssignmentValue.TaskIds> activeTasks, List<StreamsGroupCurrentMemberAssignmentValue.TaskIds> standbyTasks, List<StreamsGroupCurrentMemberAssignmentValue.TaskIds> warmupTasks, int memberEpoch) {
        return new TasksTupleWithEpochs(TasksTupleWithEpochs.parseActiveTasksWithEpochs(activeTasks, memberEpoch), TasksTupleWithEpochs.parseSimpleTasks(standbyTasks), TasksTupleWithEpochs.parseSimpleTasks(warmupTasks));
    }

    private static Map<String, Set<Integer>> mergeTasks(Map<String, Set<Integer>> tasks1, Map<String, Set<Integer>> tasks2) {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        tasks1.forEach((subtopologyId, tasks) -> result.put((String)subtopologyId, new HashSet(tasks)));
        tasks2.forEach((subtopologyId, tasks) -> result.computeIfAbsent((String)subtopologyId, __ -> new HashSet()).addAll(tasks));
        return result;
    }

    private static Map<String, Map<Integer, Integer>> parseActiveTasksWithEpochs(List<StreamsGroupCurrentMemberAssignmentValue.TaskIds> taskIdsList, int memberEpoch) {
        HashMap<String, Map<Integer, Integer>> result = new HashMap<String, Map<Integer, Integer>>();
        for (StreamsGroupCurrentMemberAssignmentValue.TaskIds taskIds : taskIdsList) {
            String subtopologyId = taskIds.subtopologyId();
            List<Integer> partitions = taskIds.partitions();
            List<Integer> epochs = taskIds.assignmentEpochs();
            HashMap<Integer, Integer> partitionsWithEpochs = new HashMap<Integer, Integer>();
            if (epochs != null && !epochs.isEmpty()) {
                if (epochs.size() != partitions.size()) {
                    throw new IllegalStateException("Assignment epochs must be provided for all partitions. Subtopology " + subtopologyId + " has " + partitions.size() + " partitions but " + epochs.size() + " epochs");
                }
                for (int i = 0; i < partitions.size(); ++i) {
                    partitionsWithEpochs.put(partitions.get(i), epochs.get(i));
                }
            } else {
                for (Integer partition : partitions) {
                    partitionsWithEpochs.put(partition, memberEpoch);
                }
            }
            result.put(subtopologyId, partitionsWithEpochs);
        }
        return result;
    }

    private static Map<String, Set<Integer>> parseSimpleTasks(List<StreamsGroupCurrentMemberAssignmentValue.TaskIds> taskIdsList) {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        for (StreamsGroupCurrentMemberAssignmentValue.TaskIds taskIds : taskIdsList) {
            result.put(taskIds.subtopologyId(), new HashSet<Integer>(taskIds.partitions()));
        }
        return result;
    }

    @Override
    public String toString() {
        return "(active=" + TasksTupleWithEpochs.taskAssignmentToString(this.activeTasksWithEpochs) + ", standby=" + TasksTuple.taskAssignmentToString(this.standbyTasks) + ", warmup=" + TasksTuple.taskAssignmentToString(this.warmupTasks) + ")";
    }

    private static String taskAssignmentToString(Map<String, Map<Integer, Integer>> assignment) {
        StringBuilder builder = new StringBuilder("[");
        Object[] subtopologyIds = assignment.keySet().toArray(new String[0]);
        Arrays.sort(subtopologyIds);
        boolean first = true;
        for (Object subtopologyId : subtopologyIds) {
            Map<Integer, Integer> partitions = assignment.get(subtopologyId);
            Object[] partitionIds = partitions.keySet().toArray(new Integer[0]);
            Arrays.sort(partitionIds);
            for (Object partitionId : partitionIds) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append((String)subtopologyId);
                builder.append("-");
                builder.append(partitionId);
                builder.append("@");
                builder.append(partitions.get(partitionId));
                first = false;
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

