/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.pageview;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.Duration;
import java.util.Properties;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.examples.pageview.JsonTimestampExtractor;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windows;

public class PageViewUntypedDemo {
    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.put("application.id", "streams-pageview-untyped");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("default.timestamp.extractor", JsonTimestampExtractor.class);
        props.put("statestore.cache.max.bytes", (Object)0);
        props.put("auto.offset.reset", "earliest");
        StreamsBuilder builder = new StreamsBuilder();
        JsonNodeSerializer jsonSerializer = new JsonNodeSerializer();
        JsonNodeDeserializer jsonDeserializer = new JsonNodeDeserializer();
        Serde jsonSerde = Serdes.serdeFrom((Serializer)jsonSerializer, (Deserializer)jsonDeserializer);
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)jsonSerde);
        KStream views = builder.stream("streams-pageview-input", consumed);
        KTable users = builder.table("streams-userprofile-input", consumed);
        KTable userRegions = users.mapValues(record -> record.get("region").textValue());
        Duration duration24Hours = Duration.ofHours(24L);
        KStream regionCount = views.leftJoin(userRegions, (view, region) -> {
            ObjectNode jNode = JsonNodeFactory.instance.objectNode();
            return jNode.put("user", view.get("user").textValue()).put("page", view.get("page").textValue()).put("region", region == null ? "UNKNOWN" : region);
        }).map((user, viewRegion) -> new KeyValue((Object)viewRegion.get("region").textValue(), viewRegion)).groupByKey(Grouped.with((Serde)Serdes.String(), (Serde)jsonSerde)).windowedBy((Windows)TimeWindows.ofSizeAndGrace((Duration)Duration.ofDays(7L), (Duration)duration24Hours).advanceBy(Duration.ofSeconds(1L))).count().toStream().map((key, value) -> {
            ObjectNode keyNode = JsonNodeFactory.instance.objectNode();
            keyNode.put("window-start", key.window().start()).put("region", (String)key.key());
            ObjectNode valueNode = JsonNodeFactory.instance.objectNode();
            valueNode.put("count", value);
            return new KeyValue((Object)keyNode, (Object)valueNode);
        });
        regionCount.to("streams-pageviewstats-untyped-output", Produced.with((Serde)jsonSerde, (Serde)jsonSerde));
        KafkaStreams streams = new KafkaStreams(builder.build(), props);
        streams.start();
        Thread.sleep(5000L);
        streams.close();
    }

    public static class JsonNodeSerializer
    implements Serializer<JsonNode> {
        private final ObjectMapper objectMapper = new ObjectMapper();

        public byte[] serialize(String topic, JsonNode data) {
            if (data == null) {
                return null;
            }
            try {
                return this.objectMapper.writeValueAsBytes((Object)data);
            }
            catch (IOException e) {
                throw new SerializationException("Error serializing JSON message", (Throwable)e);
            }
        }
    }

    public static class JsonNodeDeserializer
    implements Deserializer<JsonNode> {
        private final ObjectMapper objectMapper = new ObjectMapper();

        public JsonNode deserialize(String topic, byte[] data) {
            if (data == null) {
                return null;
            }
            try {
                return this.objectMapper.readTree(data);
            }
            catch (IOException e) {
                throw new SerializationException("Error deserializing JSON message", (Throwable)e);
            }
        }
    }
}

