/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.function.Supplier;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;

public class MetadataVersionConfigValidator
implements MetadataPublisher {
    private final String name;
    private final Supplier<Boolean> hasMultiLogDirs;
    private final FaultHandler faultHandler;

    public MetadataVersionConfigValidator(int id, Supplier<Boolean> hasMultiLogDirs, FaultHandler faultHandler) {
        this.name = "MetadataVersionPublisher(id=" + id + ")";
        this.hasMultiLogDirs = hasMultiLogDirs;
        this.faultHandler = faultHandler;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        if (delta.featuresDelta() != null && delta.metadataVersionChanged().isPresent()) {
            this.onMetadataVersionChanged(newImage.features().metadataVersionOrThrow());
        }
    }

    private void onMetadataVersionChanged(MetadataVersion metadataVersion) {
        if (this.hasMultiLogDirs.get().booleanValue() && !metadataVersion.isDirectoryAssignmentSupported()) {
            String errorMsg = String.format("Multiple log directories (aka JBOD) are not supported in the current MetadataVersion %s. Need %s or higher", metadataVersion, MetadataVersion.IBP_3_7_IV2);
            this.faultHandler.handleFault("Broker configuration does not support the cluster MetadataVersion", (Throwable)new IllegalArgumentException(errorMsg));
        }
    }
}

