/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.bean.swagger.Operation;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;

public class OperationMap
extends TreeMap<String, Operation> {
    private static final long serialVersionUID = 1L;
    private static final Comparator<String> OP_SORTER = new Comparator<String>(){
        private final Map<String, String> methods = CollectionUtils.mapb(String.class, String.class).add((Object)"get", (Object)"0").add((Object)"put", (Object)"1").add((Object)"post", (Object)"2").add((Object)"delete", (Object)"3").add((Object)"options", (Object)"4").add((Object)"head", (Object)"5").add((Object)"patch", (Object)"6").build();

        @Override
        public int compare(String o1, String o2) {
            String s1 = this.methods.get(Utils.emptyIfNull((Object)o1).toLowerCase());
            String s2 = this.methods.get(Utils.emptyIfNull((Object)o2).toLowerCase());
            if (s1 == null) {
                s1 = Utils.emptyIfNull((Object)o1).toLowerCase();
            }
            if (s2 == null) {
                s2 = Utils.emptyIfNull((Object)o2).toLowerCase();
            }
            return StringUtils.compare((String)s1, (String)s2);
        }
    };

    public OperationMap() {
        super(OP_SORTER);
    }

    public OperationMap append(String httpMethodName, Operation operation) {
        this.put(httpMethodName, operation);
        return this;
    }

    @Override
    public Operation put(String key, Operation value) {
        return super.put(Utils.emptyIfNull((Object)key).toLowerCase(), value);
    }
}

