/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.Lists;
import org.apache.juneau.commons.collections.Maps;
import org.apache.juneau.commons.collections.ReversedList;
import org.apache.juneau.commons.collections.Sets;
import org.apache.juneau.commons.collections.SimpleMap;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class CollectionUtils {
    @SafeVarargs
    public static <T> T[] a(T ... x) {
        return x;
    }

    @SafeVarargs
    public static <E> E[][] a2(E[] ... value) {
        return value;
    }

    public static <T> List<T> accumulate(Object o) {
        List<Object> l = CollectionUtils.list(new Object[0]);
        CollectionUtils.traverse(o, l::add);
        return l;
    }

    @SafeVarargs
    public static <E> List<E> addAll(List<E> value, E ... entries) {
        if (Utils.nn(entries)) {
            if (value == null) {
                value = CollectionUtils.list(entries);
            } else {
                Collections.addAll(value, entries);
            }
        }
        return value;
    }

    public static <E> List<E> addAll(List<E> value, List<E> entries) {
        if (Utils.nn(entries)) {
            if (value == null) {
                value = CollectionUtils.copyOf(entries);
            } else {
                value.addAll(entries);
            }
        }
        return value;
    }

    @SafeVarargs
    public static <E> Set<E> addAll(Set<E> value, E ... entries) {
        if (Utils.nn(entries)) {
            if (value == null) {
                value = CollectionUtils.set(entries);
            } else {
                Collections.addAll(value, entries);
            }
        }
        return value;
    }

    @SafeVarargs
    public static <E> SortedSet<E> addAll(SortedSet<E> value, E ... entries) {
        if (Utils.nn(entries)) {
            if (value == null) {
                value = CollectionUtils.sortedSet(entries);
            } else {
                Collections.addAll(value, entries);
            }
        }
        return value;
    }

    public static <T> T[] addAll(T[] array, T ... newElements) {
        int i;
        if (array == null) {
            return newElements;
        }
        if (newElements.length == 0) {
            return array;
        }
        Object[] a = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + newElements.length);
        for (i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        for (i = 0; i < newElements.length; ++i) {
            a[i + array.length] = newElements[i];
        }
        return a;
    }

    public static Object[] ao(Object ... value) {
        return value;
    }

    public static <E> E[] array(Class<E> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    public static <E> E[] array(Collection<E> value, Class<E> componentType) {
        AssertionUtils.assertArgNotNull("value", value);
        Object[] array = (Object[])Array.newInstance(componentType, value.size());
        return value.toArray(array);
    }

    public static List<Object> arrayToList(Object array) {
        AssertionUtils.assertArgNotNull("array", array);
        AssertionUtils.assertArg(Utils.isArray(array), "Input must be an array but was {0}", Utils.cn(array));
        Class<?> componentType = array.getClass().getComponentType();
        int length = Array.getLength(array);
        ArrayList<Object> result = new ArrayList<Object>(length);
        if (componentType.isPrimitive()) {
            if (componentType == Integer.TYPE) {
                int[] arr;
                for (int value : arr = (int[])array) {
                    result.add(value);
                }
            } else if (componentType == Long.TYPE) {
                long[] arr;
                for (long value : arr = (long[])array) {
                    result.add(value);
                }
            } else if (componentType == Double.TYPE) {
                double[] arr;
                for (double value : arr = (double[])array) {
                    result.add(value);
                }
            } else if (componentType == Float.TYPE) {
                float[] arr;
                for (float value : arr = (float[])array) {
                    result.add(Float.valueOf(value));
                }
            } else if (componentType == Boolean.TYPE) {
                boolean[] arr;
                for (boolean value : arr = (boolean[])array) {
                    result.add(value);
                }
            } else if (componentType == Byte.TYPE) {
                byte[] arr;
                for (byte value : arr = (byte[])array) {
                    result.add(value);
                }
            } else if (componentType == Character.TYPE) {
                char[] arr;
                for (char value : arr = (char[])array) {
                    result.add(Character.valueOf(value));
                }
            } else {
                short[] arr;
                for (short value : arr = (short[])array) {
                    result.add(value);
                }
            }
        } else {
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(array, i));
            }
        }
        return result;
    }

    public static boolean[] booleans(boolean ... value) {
        return value;
    }

    public static byte[] bytes(int ... value) {
        byte[] result = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = (byte)value[i];
        }
        return result;
    }

    public static char[] chars(char ... value) {
        return value;
    }

    public static <E> E[] combine(E[] ... arrays) {
        AssertionUtils.assertArgNotNull("arrays", arrays);
        int l = 0;
        E[] a1 = null;
        for (E[] a : arrays) {
            if (a1 == null && Utils.nn(a)) {
                a1 = a;
            }
            l += a == null ? 0 : a.length;
        }
        if (a1 == null) {
            return null;
        }
        Object[] a = (Object[])Array.newInstance(a1.getClass().getComponentType(), l);
        int i = 0;
        for (E[] aa : arrays) {
            if (!Utils.nn(aa)) continue;
            for (E t : aa) {
                a[i++] = t;
            }
        }
        return a;
    }

    public static <T> boolean contains(T element, T[] array) {
        return CollectionUtils.indexOf(element, array) != -1;
    }

    public static List copyArrayToList(Object array, List list) {
        if (Utils.nn(array)) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(array, i));
            }
        }
        return list;
    }

    public static <E> Collection<E> copyOf(Collection<E> val) {
        return val == null ? null : new LinkedHashSet<E>(val);
    }

    public static <E> ArrayList<E> copyOf(List<E> value) {
        return value == null ? null : new ArrayList<E>(value);
    }

    public static <E> List<E> copyOf(List<E> l, Function<? super E, ? extends E> valueMapper) {
        return CollectionUtils.copyOf(l, valueMapper, LinkedList::new);
    }

    public static <E> List<E> copyOf(List<E> l, Function<? super E, ? extends E> valueMapper, Supplier<List<E>> listFactory) {
        return l == null ? null : l.stream().map(valueMapper).collect(Collectors.toCollection(listFactory));
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> val) {
        return val == null ? null : new LinkedHashMap<K, V>(val);
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> m, Function<? super V, ? extends V> valueMapper) {
        return CollectionUtils.copyOf(m, valueMapper, LinkedHashMap::new);
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> m, Function<? super V, ? extends V> valueMapper, Supplier<Map<K, V>> mapFactory) {
        return m == null ? null : m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> valueMapper.apply((Object)e.getValue()), (a, b) -> b, mapFactory));
    }

    public static <E> Set<E> copyOf(Set<E> val) {
        return val == null ? null : new LinkedHashSet<E>(val);
    }

    public static <E> Set<E> copyOf(Set<E> l, Function<? super E, ? extends E> valueMapper) {
        return CollectionUtils.copyOf(l, valueMapper, LinkedHashSet::new);
    }

    public static <E> Set<E> copyOf(Set<E> l, Function<? super E, ? extends E> valueMapper, Supplier<Set<E>> setFactory) {
        return l == null ? null : l.stream().map(valueMapper).collect(Collectors.toCollection(setFactory));
    }

    public static <T> T[] copyOf(T[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    public static double[] doubles(double ... value) {
        return value;
    }

    public static <E> E first(List<E> l) {
        return Utils.e(l) ? null : (E)l.get(0);
    }

    public static float[] floats(float ... value) {
        return value;
    }

    public static <E> void forEachReverse(E[] value, Consumer<E> action) {
        for (int i = value.length - 1; i >= 0; --i) {
            action.accept(value[i]);
        }
    }

    public static <E> void forEachReverse(List<E> value, Consumer<E> action) {
        if (value instanceof ArrayList) {
            for (int i = value.size() - 1; i >= 0; --i) {
                action.accept(value.get(i));
            }
        } else {
            ListIterator<E> i = value.listIterator(value.size());
            while (i.hasPrevious()) {
                action.accept(i.previous());
            }
        }
    }

    public static <T> int indexOf(T element, T[] array) {
        if (element == null || array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!Utils.eq(element, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int[] ints(int ... value) {
        return value;
    }

    public static boolean isEmptyArray(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmptyArray(Object[] array) {
        return Utils.nn(array) && array.length > 0;
    }

    @SafeVarargs
    public static <T> List<T> l(T ... values) {
        return values == null ? null : Arrays.asList(values);
    }

    public static <E> E last(E[] l) {
        return l == null || l.length == 0 ? null : (E)l[l.length - 1];
    }

    public static <E> E last(List<E> l) {
        return Utils.e(l) ? null : (E)l.get(l.size() - 1);
    }

    public static int length(Object array) {
        if (array == null) {
            return 0;
        }
        AssertionUtils.assertArg(array.getClass().isArray(), "Object is not an array", new Object[0]);
        return Array.getLength(array);
    }

    @SafeVarargs
    public static <T> List<T> list(T ... values) {
        return new ArrayList<T>(CollectionUtils.l(values));
    }

    @SafeVarargs
    public static <T> ArrayList<T> al(T ... values) {
        return new ArrayList<T>(CollectionUtils.l(values));
    }

    @SafeVarargs
    public static <T> LinkedList<T> ll(T ... values) {
        return new LinkedList<T>(CollectionUtils.l(values));
    }

    @SafeVarargs
    public static <T> HashSet<T> hs(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <T extends Comparable<T>> TreeSet<T> ts(T ... values) {
        return new TreeSet<T>(Arrays.asList(values));
    }

    public static <E> Lists<E> listb(Class<E> type) {
        return Lists.create(type);
    }

    public static <T> List<T> liste() {
        return Collections.emptyList();
    }

    public static <T> List<T> liste(Class<T> type) {
        return Collections.emptyList();
    }

    public static <T> List<T> listn(Class<T> type) {
        return null;
    }

    @SafeVarargs
    public static <E> List<E> listOf(Class<E> elementType, E ... values) {
        return CollectionUtils.list(values);
    }

    public static <E> ArrayList<E> listOfSize(int size) {
        return new ArrayList(size);
    }

    public static long[] longs(long ... value) {
        return value;
    }

    public static <K, V> Map<K, V> m() {
        return Map.of();
    }

    public static <K, V> Map<K, V> m(K k1, V v1) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1), CollectionUtils.a(v1));
    }

    public static <K, V> Map<K, V> m(K k1, V v1, K k2, V v2) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1, k2), CollectionUtils.a(v1, v2));
    }

    public static <K, V> Map<K, V> m(K k1, V v1, K k2, V v2, K k3, V v3) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1, k2, k3), CollectionUtils.a(v1, v2, v3));
    }

    public static <K, V> Map<K, V> m(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1, k2, k3, k4), CollectionUtils.a(v1, v2, v3, v4));
    }

    public static <K, V> Map<K, V> m(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1, k2, k3, k4, k5), CollectionUtils.a(v1, v2, v3, v4, v5));
    }

    public static <K, V> Map<K, V> m(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1, k2, k3, k4, k5, k6), CollectionUtils.a(v1, v2, v3, v4, v5, v6));
    }

    public static <K, V> Map<K, V> m(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1, k2, k3, k4, k5, k6, k7), CollectionUtils.a(v1, v2, v3, v4, v5, v6, v7));
    }

    public static <K, V> Map<K, V> m(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1, k2, k3, k4, k5, k6, k7, k8), CollectionUtils.a(v1, v2, v3, v4, v5, v6, v7, v8));
    }

    public static <K, V> Map<K, V> m(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1, k2, k3, k4, k5, k6, k7, k8, k9), CollectionUtils.a(v1, v2, v3, v4, v5, v6, v7, v8, v9));
    }

    public static <K, V> Map<K, V> m(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return new SimpleMap<Object, Object>(CollectionUtils.a(k1, k2, k3, k4, k5, k6, k7, k8, k9, k10), CollectionUtils.a(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10));
    }

    public static <K, V> LinkedHashMap<K, V> map() {
        LinkedHashMap m = new LinkedHashMap();
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        m.put(k3, v3);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        m.put(k3, v3);
        m.put(k4, v4);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        m.put(k3, v3);
        m.put(k4, v4);
        m.put(k5, v5);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        m.put(k3, v3);
        m.put(k4, v4);
        m.put(k5, v5);
        m.put(k6, v6);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        m.put(k3, v3);
        m.put(k4, v4);
        m.put(k5, v5);
        m.put(k6, v6);
        m.put(k7, v7);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        m.put(k3, v3);
        m.put(k4, v4);
        m.put(k5, v5);
        m.put(k6, v6);
        m.put(k7, v7);
        m.put(k8, v8);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        m.put(k3, v3);
        m.put(k4, v4);
        m.put(k5, v5);
        m.put(k6, v6);
        m.put(k7, v7);
        m.put(k8, v8);
        m.put(k9, v9);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        m.put(k3, v3);
        m.put(k4, v4);
        m.put(k5, v5);
        m.put(k6, v6);
        m.put(k7, v7);
        m.put(k8, v8);
        m.put(k9, v9);
        m.put(k10, v10);
        return m;
    }

    public static <K, V> Maps<K, V> mapb() {
        return Maps.create().ordered();
    }

    public static Maps<String, Object> mapb_so() {
        return Maps.create(String.class, Object.class).ordered();
    }

    public static FluentMap<String, Object> filteredBeanPropertyMap() {
        return Maps.create(String.class, Object.class).filtered().sorted().buildFluent();
    }

    public static <K, V> Maps<K, V> mapb(Class<K> keyType, Class<V> valueType) {
        return Maps.create(keyType, valueType).ordered();
    }

    public static <K, V> Map<K, V> mape(Class<K> keyType, Class<V> valueType) {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> mape() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> mapn(Class<K> keyType, Class<V> valueType) {
        return null;
    }

    public static <K, V> LinkedHashMap<K, V> mapOf(Class<K> keyType, Class<V> valueType) {
        return CollectionUtils.map();
    }

    public static <T> T[] na(Class<T> type) {
        return null;
    }

    @SafeVarargs
    public static <E> List<E> prependAll(List<E> value, E ... entries) {
        if (Utils.nn(entries)) {
            if (value == null) {
                value = CollectionUtils.list(entries);
            } else {
                value.addAll(0, CollectionUtils.l(entries));
            }
        }
        return value;
    }

    public static <E> E[] reverse(E[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            E temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
        return array;
    }

    public static <E> List<E> reverse(List<E> list) {
        return new ReversedList<E>(list);
    }

    public static <T> Stream<T> rstream(List<T> value) {
        if (value == null || value.isEmpty()) {
            return Stream.empty();
        }
        return IntStream.range(0, value.size()).mapToObj(i -> value.get(value.size() - 1 - i));
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> set(T ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        return new LinkedHashSet<T>(Arrays.asList(values));
    }

    public static <T> Set<T> sete() {
        return Collections.emptySet();
    }

    public static <E> Sets<E> setb(Class<E> type) {
        return Sets.create(type).ordered();
    }

    @SafeVarargs
    public static <E> LinkedHashSet<E> setOf(Class<E> elementType, E ... values) {
        return CollectionUtils.set(values);
    }

    public static short[] shorts(int ... value) {
        short[] result = new short[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = (short)value[i];
        }
        return result;
    }

    public static <E> ArrayList<E> sortedList(Comparator<E> comparator, Collection<E> value) {
        ArrayList<E> l = CollectionUtils.toList(value);
        Collections.sort(l, comparator);
        return l;
    }

    public static <E> List<E> sortedList(Comparator<E> comparator, E[] values) {
        List<E> l = CollectionUtils.list(values);
        Collections.sort(l, comparator);
        return l;
    }

    @SafeVarargs
    public static <E> List<E> sortedList(E ... values) {
        List<E> l = CollectionUtils.list(values);
        Collections.sort(l);
        return l;
    }

    public static <K, V> TreeMap<K, V> sortedMap() {
        return new TreeMap();
    }

    @SafeVarargs
    public static <E> TreeSet<E> sortedSet(E ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        TreeSet<E> l = new TreeSet<E>();
        for (E v : values) {
            if (v == null) continue;
            l.add(v);
        }
        return l;
    }

    public static <T> Stream<T> stream(T[] array) {
        return array == null ? Stream.empty() : Arrays.stream(array);
    }

    public static <E> List<E> synced(List<E> value) {
        return value == null ? null : Collections.synchronizedList(value);
    }

    public static <K, V> Map<K, V> synced(Map<K, V> value) {
        return value == null ? null : Collections.synchronizedMap(value);
    }

    public static <E> Set<E> synced(Set<E> value) {
        return value == null ? null : Collections.synchronizedSet(value);
    }

    public static <E> Object toArray(Collection<?> c, Class<E> elementType) {
        Object a = Array.newInstance(elementType, c.size());
        Iterator<?> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            Array.set(a, i++, it.next());
        }
        return a;
    }

    public static <E> ArrayList<E> toList(Collection<E> value) {
        return CollectionUtils.toList(value, false);
    }

    public static <E> ArrayList<E> toList(Collection<E> value, boolean nullIfEmpty) {
        if (value == null || nullIfEmpty && value.isEmpty()) {
            return null;
        }
        ArrayList l = new ArrayList();
        value.forEach(x -> l.add(x));
        return l;
    }

    public static final List<?> toList(Object o) {
        AssertionUtils.assertArgNotNull("o", o);
        if (o instanceof List) {
            List o2 = (List)o;
            return o2;
        }
        if (o instanceof Iterable) {
            Iterable o2 = (Iterable)o;
            return StreamSupport.stream(o2.spliterator(), false).toList();
        }
        if (o instanceof Iterator) {
            Iterator o2 = (Iterator)o;
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(o2, 0), false).toList();
        }
        if (o instanceof Enumeration) {
            Enumeration o2 = (Enumeration)o;
            return Collections.list(o2);
        }
        if (o instanceof Stream) {
            Stream o2 = (Stream)o;
            return o2.toList();
        }
        if (o instanceof Map) {
            Map o2 = (Map)o;
            return CollectionUtils.toList(o2.entrySet());
        }
        if (o instanceof Optional) {
            Optional o2 = (Optional)o;
            return o2.isEmpty() ? Collections.emptyList() : Collections.singletonList(o2.get());
        }
        if (Utils.isArray(o)) {
            return CollectionUtils.arrayToList(o);
        }
        throw ThrowableUtils.rex("Could not convert object of type {0} to a list", Utils.cn(o));
    }

    public static <E> List<E> toList(Object array, Class<E> elementType) {
        ArrayList<Object> l = new ArrayList<Object>(Array.getLength(array));
        for (int i = 0; i < Array.getLength(array); ++i) {
            l.add(Array.get(array, i));
        }
        return l;
    }

    public static List<Object> toObjectList(Object array) {
        ArrayList<Object> l = new ArrayList<Object>(Array.getLength(array));
        for (int i = 0; i < Array.getLength(array); ++i) {
            List<Object> o = Array.get(array, i);
            if (Utils.isArray(o)) {
                o = CollectionUtils.toObjectList(o);
            }
            l.add(o);
        }
        return l;
    }

    public static <E> Set<E> toSet(Collection<E> val) {
        return val == null ? null : new LinkedHashSet<E>(val);
    }

    public static <T> Set<T> toSet(final T[] array) {
        AssertionUtils.assertArgNotNull("array", array);
        return new AbstractSet<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < array.length;
                    }

                    @Override
                    public T next() {
                        if (this.i >= array.length) {
                            throw new NoSuchElementException();
                        }
                        Object t = array[this.i];
                        ++this.i;
                        return t;
                    }

                    @Override
                    public void remove() {
                        throw ThrowableUtils.unsupportedOp();
                    }
                };
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static <E> TreeSet<E> toSortedSet(Collection<E> value) {
        if (value == null) {
            return null;
        }
        TreeSet l = new TreeSet();
        value.forEach(x -> l.add(x));
        return l;
    }

    public static <E> TreeSet<E> toSortedSet(Collection<E> value, boolean nullIfEmpty) {
        if (value == null || nullIfEmpty && value.isEmpty()) {
            return null;
        }
        TreeSet l = new TreeSet();
        value.forEach(x -> l.add(x));
        return l;
    }

    public static <T> TreeSet<T> toSortedSet(Set<T> copyFrom) {
        return copyFrom == null ? null : new TreeSet<T>(copyFrom);
    }

    public static Stream<Object> toStream(Object array) {
        AssertionUtils.assertArg(Utils.isArray(array), "Arg was not an array.  Type: {0}", Utils.cn(array));
        int length = Array.getLength(array);
        return IntStream.range(0, length).mapToObj(i -> Array.get(array, i));
    }

    public static String[] toStringArray(Collection<?> c) {
        String[] r = new String[c.size()];
        int i = 0;
        for (Object o : c) {
            r[i++] = Utils.s(o);
        }
        return r;
    }

    public static <T> void traverse(Object o, Consumer<T> c) {
        if (o == null) {
            return;
        }
        if (o instanceof Iterable) {
            Iterable o2 = (Iterable)o;
            o2.forEach(x -> CollectionUtils.traverse(x, c));
        } else if (o instanceof Stream) {
            Stream o2 = (Stream)o;
            o2.forEach(x -> CollectionUtils.traverse(x, c));
        } else if (Utils.isArray(o)) {
            CollectionUtils.toStream(o).forEach(x -> CollectionUtils.traverse(x, c));
        } else {
            c.accept(o);
        }
    }

    public static <T> List<T> u(List<? extends T> value) {
        return value == null ? null : Collections.unmodifiableList(value);
    }

    public static <K, V> Map<K, V> u(Map<? extends K, ? extends V> value) {
        return value == null ? null : Collections.unmodifiableMap(value);
    }

    public static <T> Set<T> u(Set<? extends T> value) {
        return value == null ? null : Collections.unmodifiableSet(value);
    }

    private CollectionUtils() {
    }
}

