/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.Callback;
import org.apache.juneau.bean.openapi3.Example;
import org.apache.juneau.bean.openapi3.HeaderInfo;
import org.apache.juneau.bean.openapi3.Link;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.Parameter;
import org.apache.juneau.bean.openapi3.RequestBodyInfo;
import org.apache.juneau.bean.openapi3.Response;
import org.apache.juneau.bean.openapi3.SchemaInfo;
import org.apache.juneau.bean.openapi3.SecuritySchemeInfo;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Components
extends OpenApiElement {
    private Map<String, SchemaInfo> schemas;
    private Map<String, Response> responses;
    private Map<String, Parameter> parameters;
    private Map<String, Example> examples;
    private Map<String, RequestBodyInfo> requestBodies;
    private Map<String, HeaderInfo> headers;
    private Map<String, SecuritySchemeInfo> securitySchemes;
    private Map<String, Link> links;
    private Map<String, Callback> callbacks;

    public Components() {
    }

    public Components(Components copyFrom) {
        super(copyFrom);
        this.schemas = CollectionUtils.copyOf(copyFrom.schemas);
        this.responses = CollectionUtils.copyOf(copyFrom.responses);
        this.parameters = CollectionUtils.copyOf(copyFrom.parameters);
        this.examples = CollectionUtils.copyOf(copyFrom.examples);
        this.requestBodies = CollectionUtils.copyOf(copyFrom.requestBodies);
        this.headers = CollectionUtils.copyOf(copyFrom.headers);
        this.securitySchemes = CollectionUtils.copyOf(copyFrom.securitySchemes);
        this.links = CollectionUtils.copyOf(copyFrom.links);
        this.callbacks = CollectionUtils.copyOf(copyFrom.callbacks);
    }

    public Components copy() {
        return new Components(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "schemas" -> ConverterUtils.toType(this.getSchemas(), type);
            case "responses" -> ConverterUtils.toType(this.getResponses(), type);
            case "parameters" -> ConverterUtils.toType(this.getParameters(), type);
            case "examples" -> ConverterUtils.toType(this.getExamples(), type);
            case "requestBodies" -> ConverterUtils.toType(this.getRequestBodies(), type);
            case "headers" -> ConverterUtils.toType(this.getHeaders(), type);
            case "securitySchemes" -> ConverterUtils.toType(this.getSecuritySchemes(), type);
            case "links" -> ConverterUtils.toType(this.getLinks(), type);
            case "callbacks" -> ConverterUtils.toType(this.getCallbacks(), type);
            default -> super.get(property, type);
        };
    }

    public Map<String, Callback> getCallbacks() {
        return this.callbacks;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public Map<String, HeaderInfo> getHeaders() {
        return this.headers;
    }

    public Map<String, Link> getLinks() {
        return this.links;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public Map<String, RequestBodyInfo> getRequestBodies() {
        return this.requestBodies;
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public Map<String, SchemaInfo> getSchemas() {
        return this.schemas;
    }

    public Map<String, SecuritySchemeInfo> getSecuritySchemes() {
        return this.securitySchemes;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.callbacks), "callbacks").addIf(Utils.nn(this.examples), "examples").addIf(Utils.nn(this.headers), "headers").addIf(Utils.nn(this.links), "links").addIf(Utils.nn(this.parameters), "parameters").addIf(Utils.nn(this.requestBodies), "requestBodies").addIf(Utils.nn(this.responses), "responses").addIf(Utils.nn(this.schemas), "schemas").addIf(Utils.nn(this.securitySchemes), "securitySchemes").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public Components set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "callbacks" -> this.setCallbacks(ConverterUtils.toMapBuilder(value, String.class, Callback.class).sparse().build());
            case "examples" -> this.setExamples(ConverterUtils.toMapBuilder(value, String.class, Example.class).sparse().build());
            case "headers" -> this.setHeaders(ConverterUtils.toMapBuilder(value, String.class, HeaderInfo.class).sparse().build());
            case "links" -> this.setLinks(ConverterUtils.toMapBuilder(value, String.class, Link.class).sparse().build());
            case "parameters" -> this.setParameters(ConverterUtils.toMapBuilder(value, String.class, Parameter.class).sparse().build());
            case "requestBodies" -> this.setRequestBodies(ConverterUtils.toMapBuilder(value, String.class, RequestBodyInfo.class).sparse().build());
            case "responses" -> this.setResponses(ConverterUtils.toMapBuilder(value, String.class, Response.class).sparse().build());
            case "schemas" -> this.setSchemas(ConverterUtils.toMapBuilder(value, String.class, SchemaInfo.class).sparse().build());
            case "securitySchemes" -> this.setSecuritySchemes(ConverterUtils.toMapBuilder(value, String.class, SecuritySchemeInfo.class).sparse().build());
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Components setCallbacks(Map<String, Callback> value) {
        this.callbacks = value;
        return this;
    }

    public Components setExamples(Map<String, Example> value) {
        this.examples = value;
        return this;
    }

    public Components setHeaders(Map<String, HeaderInfo> value) {
        this.headers = value;
        return this;
    }

    public Components setLinks(Map<String, Link> value) {
        this.links = value;
        return this;
    }

    public Components setParameters(Map<String, Parameter> value) {
        this.parameters = value;
        return this;
    }

    public Components setRequestBodies(Map<String, RequestBodyInfo> value) {
        this.requestBodies = value;
        return this;
    }

    public Components setResponses(Map<String, Response> value) {
        this.responses = value;
        return this;
    }

    public Components setSchemas(Map<String, SchemaInfo> value) {
        this.schemas = value;
        return this;
    }

    public Components setSecuritySchemes(Map<String, SecuritySchemeInfo> value) {
        this.securitySchemes = value;
        return this;
    }

    @Override
    public Components strict() {
        super.strict();
        return this;
    }

    @Override
    public Components strict(Object value) {
        super.strict(value);
        return this;
    }
}

