/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.IOException;
import java.net.URI;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class UriResolver {
    private final UriResolution resolution;
    private final UriRelativity relativity;
    private final String authority;
    private final String contextRoot;
    private final String servletPath;
    private final String pathInfo;
    private final String parentPath;

    public static UriResolver of(UriResolution resolution, UriRelativity relativity, UriContext uriContext) {
        return new UriResolver(resolution, relativity, uriContext);
    }

    private static boolean hasDotSegments(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if ((i != 0 || c != '/') && (c != '/' || s.charAt(i + 1) != '.')) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpecialUri(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        char c = s.charAt(0);
        if (c != 's' && c != 'c' && c != 'r') {
            return false;
        }
        return s.startsWith("servlet:") || s.startsWith("context:") || s.startsWith("request:");
    }

    private static String normalize(String s) {
        if ((s = URI.create(s).normalize().toString()).length() > 1 && s.charAt(s.length() - 1) == '/') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public UriResolver(UriResolution resolution, UriRelativity relativity, UriContext uriContext) {
        this.resolution = resolution;
        this.relativity = relativity;
        this.authority = uriContext.authority;
        this.contextRoot = uriContext.contextRoot;
        this.servletPath = uriContext.servletPath;
        this.pathInfo = uriContext.pathInfo;
        this.parentPath = uriContext.parentPath;
    }

    public Appendable append(Appendable a, Object o) {
        try {
            Appendable a2;
            boolean needsNormalize;
            String uri = Utils.s(o);
            uri = Utils.nullIfEmpty(uri);
            boolean bl = needsNormalize = UriResolver.hasDotSegments(uri) && Utils.nn((Object)this.resolution);
            if (StringUtils.isAbsoluteUri(uri)) {
                return a.append(needsNormalize ? UriResolver.normalize(uri) : uri);
            }
            if (this.resolution == UriResolution.NONE && !UriResolver.isSpecialUri(uri)) {
                return a.append(StringUtils.emptyIfNull(uri));
            }
            if (this.resolution == UriResolution.ROOT_RELATIVE && StringUtils.startsWith(uri, '/')) {
                return a.append(needsNormalize ? UriResolver.normalize(uri) : uri);
            }
            Appendable appendable = a2 = needsNormalize ? new StringBuilder() : a;
            if (StringUtils.startsWith(uri, '/')) {
                if (Utils.nn(this.authority)) {
                    a2.append(this.authority);
                }
                if (uri.length() != 1) {
                    a2.append(uri);
                } else if (this.authority == null) {
                    a2.append('/');
                }
            } else if (Utils.nn(uri) && uri.startsWith("context:")) {
                boolean hasContext;
                if (this.resolution == UriResolution.ABSOLUTE && Utils.nn(this.authority)) {
                    a2.append(this.authority);
                }
                boolean bl2 = hasContext = Utils.nn(this.contextRoot) && !this.contextRoot.isEmpty();
                if (hasContext) {
                    a2.append('/').append(this.contextRoot);
                }
                if (uri.length() > 8) {
                    String remainder = uri.substring(8);
                    if (!(remainder.equals("/") && (hasContext || this.resolution == UriResolution.ABSOLUTE && Utils.nn(this.authority)))) {
                        if (!remainder.isEmpty() && remainder.charAt(0) != '/' && remainder.charAt(0) != '?' && remainder.charAt(0) != '#') {
                            a2.append('/').append(remainder);
                        } else {
                            a2.append(remainder);
                        }
                    }
                } else if (!(hasContext || this.authority != null && this.resolution == UriResolution.ABSOLUTE)) {
                    a2.append('/');
                }
            } else if (Utils.nn(uri) && uri.startsWith("servlet:")) {
                boolean hasServlet;
                if (this.resolution == UriResolution.ABSOLUTE && Utils.nn(this.authority)) {
                    a2.append(this.authority);
                }
                boolean hasContext = Utils.nn(this.contextRoot) && !this.contextRoot.isEmpty();
                boolean bl3 = hasServlet = Utils.nn(this.servletPath) && !this.servletPath.isEmpty();
                if (hasContext) {
                    a2.append('/').append(this.contextRoot);
                }
                if (hasServlet) {
                    a2.append('/').append(this.servletPath);
                }
                if (uri.length() > 8) {
                    String remainder = uri.substring(8);
                    if (!(remainder.equals("/") && (hasContext || hasServlet || this.resolution == UriResolution.ABSOLUTE && Utils.nn(this.authority)))) {
                        if (!remainder.isEmpty() && remainder.charAt(0) != '/' && remainder.charAt(0) != '?' && remainder.charAt(0) != '#') {
                            a2.append('/').append(remainder);
                        } else {
                            a2.append(remainder);
                        }
                    }
                } else if (!(hasServlet || hasContext || this.authority != null && this.resolution == UriResolution.ABSOLUTE)) {
                    a2.append('/');
                }
            } else if (Utils.nn(uri) && uri.startsWith("request:")) {
                boolean hasPath;
                if (this.resolution == UriResolution.ABSOLUTE && Utils.nn(this.authority)) {
                    a2.append(this.authority);
                }
                boolean hasContext = Utils.nn(this.contextRoot) && !this.contextRoot.isEmpty();
                boolean hasServlet = Utils.nn(this.servletPath) && !this.servletPath.isEmpty();
                boolean bl4 = hasPath = Utils.nn(this.pathInfo) && !this.pathInfo.isEmpty();
                if (hasContext) {
                    a2.append('/').append(this.contextRoot);
                }
                if (hasServlet) {
                    a2.append('/').append(this.servletPath);
                }
                if (hasPath) {
                    a2.append('/').append(this.pathInfo);
                }
                if (uri.length() > 8) {
                    String remainder = uri.substring(8);
                    if (!(remainder.equals("/") && (hasContext || hasServlet || hasPath || this.resolution == UriResolution.ABSOLUTE && Utils.nn(this.authority)))) {
                        if (!remainder.isEmpty() && remainder.charAt(0) != '/' && remainder.charAt(0) != '?' && remainder.charAt(0) != '#') {
                            a2.append('/').append(remainder);
                        } else {
                            a2.append(remainder);
                        }
                    }
                } else if (!(hasServlet || hasContext || hasPath || this.authority != null && this.resolution == UriResolution.ABSOLUTE)) {
                    a2.append('/');
                }
            } else {
                if (this.resolution == UriResolution.ABSOLUTE && Utils.nn(this.authority)) {
                    a2.append(this.authority);
                }
                if (Utils.nn(this.contextRoot)) {
                    a2.append('/').append(this.contextRoot);
                }
                if (Utils.nn(this.servletPath)) {
                    a2.append('/').append(this.servletPath);
                }
                if (this.relativity == UriRelativity.RESOURCE && Utils.nn(uri)) {
                    a2.append('/').append(uri);
                } else if (this.relativity == UriRelativity.PATH_INFO) {
                    if (uri == null) {
                        if (Utils.nn(this.pathInfo)) {
                            a2.append('/').append(this.pathInfo);
                        }
                    } else {
                        if (Utils.nn(this.parentPath)) {
                            a2.append('/').append(this.parentPath);
                        }
                        a2.append('/').append(uri);
                    }
                } else if (uri == null && this.contextRoot == null && this.servletPath == null && (this.authority == null || this.resolution != UriResolution.ABSOLUTE)) {
                    a2.append('/');
                }
            }
            if (needsNormalize) {
                a.append(UriResolver.normalize(a2.toString()));
            }
            return a;
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    public String relativize(Object relativeTo, Object uri) {
        String r = this.resolve(relativeTo, UriResolution.ABSOLUTE);
        String s = this.resolve(uri, UriResolution.ABSOLUTE);
        return URI.create(r).relativize(URI.create(s)).toString();
    }

    public String resolve(Object uri) {
        return this.resolve(uri, this.resolution);
    }

    private String resolve(Object uri, UriResolution res) {
        String s = Utils.s(uri);
        if (StringUtils.isAbsoluteUri(s)) {
            return UriResolver.hasDotSegments(s) && res != UriResolution.NONE ? UriResolver.normalize(s) : s;
        }
        if (res == UriResolution.ROOT_RELATIVE && StringUtils.startsWith(s, '/')) {
            return UriResolver.hasDotSegments(s) ? UriResolver.normalize(s) : s;
        }
        if (res == UriResolution.NONE && !UriResolver.isSpecialUri(s)) {
            return s;
        }
        return this.append(new StringBuilder(), s).toString();
    }
}

