/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.List;
import java.util.function.Consumer;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;

@BeanIgnore
public class StringRange {
    private final NameValuePair[] extensions;
    private final Float qValue;
    private final String name;
    private final String string;

    private static HeaderElement parse(String value) {
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)StringUtils.emptyIfNull((String)StringUtils.trim((String)value)), null);
        return elements.length > 0 ? elements[0] : new BasicHeaderElement("*", "");
    }

    public StringRange(HeaderElement e) {
        Float qValue = Float.valueOf(1.0f);
        List extensions = CollectionUtils.list((Object[])new NameValuePair[0]);
        for (NameValuePair p : e.getParameters()) {
            if (p.getName().equals("q")) {
                qValue = Float.valueOf(Float.parseFloat(p.getValue()));
                continue;
            }
            extensions.add(new BasicNameValuePair(p.getName(), p.getValue()));
        }
        this.qValue = qValue;
        this.extensions = extensions.toArray(new NameValuePair[extensions.size()]);
        this.name = e.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (Float.compare(qValue.floatValue(), 1.0f) == 0) {
            if (this.extensions.length > 0) {
                sb.append(";q=").append(qValue);
                extensions.forEach(x -> sb.append(';').append(x.getName()).append('=').append(x.getValue()));
            }
        } else {
            sb.append(";q=").append(qValue);
            extensions.forEach(x -> sb.append(';').append(x.getName()).append('=').append(x.getValue()));
        }
        this.string = sb.toString();
    }

    public StringRange(String value) {
        this(StringRange.parse(value));
    }

    public boolean equals(Object o) {
        StringRange o2;
        return o instanceof StringRange && Utils.eq((Object)this, (Object)(o2 = (StringRange)o), (x, y) -> Utils.eq((Object)x.string, (Object)y.string));
    }

    public StringRange forEachExtension(Consumer<NameValuePair> action) {
        for (NameValuePair p : this.extensions) {
            action.accept(p);
        }
        return this;
    }

    public List<NameValuePair> getExtensions() {
        return CollectionUtils.l((Object[])this.extensions);
    }

    public String getName() {
        return this.name;
    }

    public Float getQValue() {
        return this.qValue;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public int match(String name) {
        if (this.qValue.floatValue() == 0.0f) {
            return 0;
        }
        if (Utils.eq((Object)this.name, (Object)name)) {
            return 100;
        }
        if (Utils.eq((Object)this.name, (Object)"*")) {
            return 50;
        }
        return 0;
    }

    public String toString() {
        return this.string;
    }
}

