/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.logger;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.juneau.Enablement;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.logger.CallLoggerRule;
import org.apache.juneau.rest.logger.CallLoggingDetail;
import org.apache.juneau.rest.stats.ThrownStats;
import org.apache.juneau.rest.stats.ThrownStore;
import org.apache.juneau.rest.util.CachingHttpServletRequest;
import org.apache.juneau.rest.util.CachingHttpServletResponse;

public class CallLogger {
    private static final CallLoggerRule DEFAULT_RULE = (CallLoggerRule)CallLoggerRule.create(BeanStore.INSTANCE).build();
    public static final String SP_logger = "juneau.restLogger.logger";
    public static final String SP_enabled = "juneau.restLogger.enabled";
    public static final String SP_requestDetail = "juneau.restLogger.requestDetail";
    public static final String SP_responseDetail = "juneau.restLogger.responseDetail";
    public static final String SP_level = "juneau.restLogger.level";
    private final Logger logger;
    private final ThrownStore thrownStore;
    private final CallLoggerRule[] normalRules;
    private final CallLoggerRule[] debugRules;
    private final Enablement enabled;
    private final Predicate<HttpServletRequest> enabledTest;
    private final Level level;
    private final CallLoggingDetail requestDetail;
    private final CallLoggingDetail responseDetail;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public CallLogger(BeanStore beanStore) {
        Builder builder = this.init(beanStore);
        this.logger = builder.logger;
        this.thrownStore = builder.thrownStore;
        this.normalRules = builder.normalRules.toArray(new CallLoggerRule[builder.normalRules.size()]);
        this.debugRules = builder.debugRules.toArray(new CallLoggerRule[builder.debugRules.size()]);
        this.enabled = builder.enabled;
        this.enabledTest = builder.enabledTest;
        this.requestDetail = builder.requestDetail;
        this.responseDetail = builder.responseDetail;
        this.level = builder.level;
    }

    public CallLogger(Builder builder) {
        this.logger = builder.logger;
        this.thrownStore = builder.thrownStore;
        this.normalRules = builder.normalRules.toArray(new CallLoggerRule[builder.normalRules.size()]);
        this.debugRules = builder.debugRules.toArray(new CallLoggerRule[builder.debugRules.size()]);
        this.enabled = builder.enabled;
        this.enabledTest = builder.enabledTest;
        this.requestDetail = builder.requestDetail;
        this.responseDetail = builder.responseDetail;
        this.level = builder.level;
    }

    public void log(HttpServletRequest req, HttpServletResponse res) {
        CallLoggerRule rule = this.getRule(req, res);
        if (!this.isEnabled(rule, req)) {
            return;
        }
        Level level = Utils.firstNonNull(rule.getLevel(), this.level);
        if (level == Level.OFF) {
            return;
        }
        Throwable e = Utils.cast(Throwable.class, req.getAttribute("Exception"));
        Long execTime = Utils.cast(Long.class, req.getAttribute("ExecTime"));
        CallLoggingDetail reqd = Utils.firstNonNull(rule.getRequestDetail(), this.requestDetail);
        CallLoggingDetail resd = Utils.firstNonNull(rule.getResponseDetail(), this.responseDetail);
        String method = req.getMethod();
        int status = res.getStatus();
        String uri = req.getRequestURI();
        byte[] reqContent = CallLogger.getRequestContent(req);
        byte[] resContent = CallLogger.getResponseContent(req, res);
        StringBuilder sb = new StringBuilder();
        if (reqd != CallLoggingDetail.STATUS_LINE || resd != CallLoggingDetail.STATUS_LINE) {
            sb.append("\n=== HTTP Call (incoming) ======================================================\n");
        }
        ThrownStats sti = this.getThrownStats(e);
        sb.append('[').append(status);
        if (Utils.nn(sti)) {
            int count = sti.getCount();
            sb.append(',').append(StringUtils.toHex8(Math.abs(sti.getHash()))).append('.').append(count);
            if (count > 1) {
                e = null;
            }
        }
        sb.append("] ");
        sb.append("HTTP ").append(method).append(' ').append(uri);
        if (reqd != CallLoggingDetail.STATUS_LINE || resd != CallLoggingDetail.STATUS_LINE) {
            Collection hh;
            Enumeration hh2;
            String qs;
            if (reqd.isOneOf(CallLoggingDetail.HEADER, CallLoggingDetail.ENTITY) && Utils.nn(qs = req.getQueryString())) {
                sb.append('?').append(qs);
            }
            if (Utils.nn(reqContent) && reqd.isOneOf(CallLoggingDetail.HEADER, CallLoggingDetail.ENTITY)) {
                sb.append("\n\tRequest length: ").append(reqContent.length).append(" bytes");
            }
            if (resd.isOneOf(CallLoggingDetail.HEADER, CallLoggingDetail.ENTITY)) {
                sb.append("\n\tResponse code: ").append(status);
            }
            if (Utils.nn(resContent) && resd.isOneOf(CallLoggingDetail.HEADER, CallLoggingDetail.ENTITY)) {
                sb.append("\n\tResponse length: ").append(resContent.length).append(" bytes");
            }
            if (Utils.nn(execTime) && resd.isOneOf(CallLoggingDetail.HEADER, CallLoggingDetail.ENTITY)) {
                sb.append("\n\tExec time: ").append(execTime).append("ms");
            }
            if (reqd.isOneOf(CallLoggingDetail.HEADER, CallLoggingDetail.ENTITY) && (hh2 = req.getHeaderNames()).hasMoreElements()) {
                sb.append("\n---Request Headers---");
                while (hh2.hasMoreElements()) {
                    String h = (String)hh2.nextElement();
                    sb.append("\n\t").append(h).append(": ").append(req.getHeader(h));
                }
            }
            if (resd.isOneOf(CallLoggingDetail.HEADER, CallLoggingDetail.ENTITY) && (hh = res.getHeaderNames()).size() > 0) {
                sb.append("\n---Response Headers---");
                for (String h : hh) {
                    sb.append("\n\t").append(h).append(": ").append(res.getHeader(h));
                }
            }
            if (Utils.nn(reqContent) && reqContent.length > 0 && reqd == CallLoggingDetail.ENTITY) {
                try {
                    sb.append("\n---Request Content UTF-8---");
                    sb.append("\n").append(new String(reqContent, IoUtils.UTF8));
                    sb.append("\n---Request Content Hex---");
                    sb.append("\n").append(StringUtils.toSpacedHex(reqContent));
                }
                catch (Exception e1) {
                    sb.append("\n").append(ThrowableUtils.lm(e1));
                }
            }
            if (Utils.nn(resContent) && resContent.length > 0 && resd == CallLoggingDetail.ENTITY) {
                try {
                    sb.append("\n---Response Content UTF-8---");
                    sb.append("\n").append(new String(resContent, IoUtils.UTF8));
                    sb.append("\n---Response Content Hex---");
                    sb.append("\n").append(StringUtils.toSpacedHex(resContent));
                }
                catch (Exception e1) {
                    sb.append(ThrowableUtils.lm(e1));
                }
            }
            sb.append("\n=== END ======================================================================");
        }
        this.log(level, sb.toString(), e);
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a("debugRules", this.debugRules).a("enabled", (Object)this.enabled).a("level", this.level).a("logger", this.logger).a("normalRules", this.normalRules).a("requestDetail", (Object)this.requestDetail).a("responseDetail", (Object)this.responseDetail).a("thrownStore", this.thrownStore);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    private static byte[] getRequestContent(HttpServletRequest req) {
        if (req instanceof CachingHttpServletRequest) {
            CachingHttpServletRequest req2 = (CachingHttpServletRequest)req;
            return req2.getContent();
        }
        return Utils.cast(byte[].class, req.getAttribute("RequestContent"));
    }

    private static byte[] getResponseContent(HttpServletRequest req, HttpServletResponse res) {
        if (res instanceof CachingHttpServletResponse) {
            CachingHttpServletResponse res2 = (CachingHttpServletResponse)res;
            return res2.getContent();
        }
        return Utils.cast(byte[].class, req.getAttribute("ResponseContent"));
    }

    private ThrownStats getThrownStats(Throwable e) {
        if (e == null || this.thrownStore == null) {
            return null;
        }
        return this.thrownStore.add(e);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected CallLoggerRule getRule(HttpServletRequest req, HttpServletResponse res) {
        for (CallLoggerRule r : this.isDebug(req) ? this.debugRules : this.normalRules) {
            if (!r.matches(req, res)) continue;
            return r;
        }
        return DEFAULT_RULE;
    }

    protected Builder init(BeanStore beanStore) {
        return new Builder(beanStore).logger((Logger)beanStore.getBean(Logger.class).orElse(null)).thrownStore(beanStore.getBean(ThrownStore.class).orElse(null));
    }

    protected boolean isDebug(HttpServletRequest req) {
        return Utils.firstNonNull(Utils.cast(Boolean.class, req.getAttribute("Debug")), false);
    }

    protected boolean isEnabled(CallLoggerRule rule, HttpServletRequest req) {
        Enablement enabled = Utils.firstNonNull(rule.getEnabled(), this.enabled);
        Predicate enabledTest = Utils.firstNonNull(rule.getEnabledTest(), this.enabledTest);
        return enabled.isEnabled(enabledTest.test(req));
    }

    protected void log(Level level, String msg, Throwable e) {
        this.getLogger().log(level, msg, e);
    }

    public static class Builder {
        Logger logger;
        ThrownStore thrownStore;
        List<CallLoggerRule> normalRules = CollectionUtils.list(new CallLoggerRule[0]);
        List<CallLoggerRule> debugRules = CollectionUtils.list(new CallLoggerRule[0]);
        Enablement enabled;
        Predicate<HttpServletRequest> enabledTest;
        CallLoggingDetail requestDetail;
        CallLoggingDetail responseDetail;
        Level level;

        protected Builder(BeanStore beanStore) {
            this.logger = Logger.getLogger(Utils.env(CallLogger.SP_logger, "global"));
            this.enabled = Utils.env(CallLogger.SP_enabled, Enablement.ALWAYS);
            this.enabledTest = x -> false;
            this.requestDetail = Utils.env(CallLogger.SP_requestDetail, CallLoggingDetail.STATUS_LINE);
            this.responseDetail = Utils.env(CallLogger.SP_responseDetail, CallLoggingDetail.STATUS_LINE);
            this.level = Utils.env(CallLogger.SP_level).map(Level::parse).orElse(Level.OFF);
        }

        public CallLogger build() {
            return new CallLogger(this);
        }

        public Builder debugRules(CallLoggerRule ... values) {
            for (CallLoggerRule rule : values) {
                this.debugRules.add(rule);
            }
            return this;
        }

        public Builder disabled() {
            return this.enabled(Enablement.NEVER);
        }

        public Builder enabled(Enablement value) {
            this.enabled = value;
            return this;
        }

        public Builder enabledTest(Predicate<HttpServletRequest> value) {
            this.enabledTest = value;
            return this;
        }

        public Builder level(Level value) {
            this.level = value;
            return this;
        }

        public Builder logger(Logger value) {
            this.logger = value;
            return this;
        }

        public Builder logger(String value) {
            this.logger = value == null ? null : Logger.getLogger(value);
            return this;
        }

        public Builder loggerOnce(Logger value) {
            if (this.logger == null) {
                this.logger = value;
            }
            return this;
        }

        public Builder normalRules(CallLoggerRule ... values) {
            for (CallLoggerRule rule : values) {
                this.normalRules.add(rule);
            }
            return this;
        }

        public Builder requestDetail(CallLoggingDetail value) {
            this.requestDetail = value;
            return this;
        }

        public Builder responseDetail(CallLoggingDetail value) {
            this.responseDetail = value;
            return this;
        }

        public Builder rules(CallLoggerRule ... values) {
            return this.normalRules(values).debugRules(values);
        }

        public Builder thrownStore(ThrownStore value) {
            this.thrownStore = value;
            return this;
        }

        public Builder thrownStoreOnce(ThrownStore value) {
            if (this.thrownStore == null) {
                this.thrownStore = value;
            }
            return this;
        }
    }

    public abstract class Void
    extends CallLogger {
        Void(BeanStore beanStore) {
            super(beanStore);
        }
    }
}

