/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.http.StatusLine;
import org.apache.http.params.HttpParams;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.HttpEntities;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.Location;

@BeanIgnore
public class BasicHttpResponse
implements HttpResponse {
    BasicStatusLine statusLine = new BasicStatusLine();
    HeaderList headers = HeaderList.create();
    HttpEntity content;
    boolean unmodifiable;

    public BasicHttpResponse(BasicHttpResponse copyFrom) {
        this.statusLine = copyFrom.statusLine.copy();
        this.headers = copyFrom.headers.copy();
        this.content = copyFrom.content;
    }

    public BasicHttpResponse(BasicStatusLine statusLine) {
        this.setStatusLine(statusLine.copy());
    }

    public BasicHttpResponse(HttpResponse response) {
        this.setHeaders(response.getAllHeaders());
        this.setContent(response.getEntity());
        this.setStatusLine(response.getStatusLine());
    }

    public void addHeader(Header value) {
        this.headers.append(value);
    }

    public void addHeader(String name, String value) {
        this.headers.append(name, value);
    }

    public boolean containsHeader(String name) {
        return this.headers.contains(name);
    }

    public Header[] getAllHeaders() {
        return this.headers.getAll();
    }

    public HttpEntity getEntity() {
        if (this.content == null) {
            this.content = HttpEntities.stringEntity(this.getStatusLine().getReasonPhrase());
        }
        return this.content;
    }

    public Header getFirstHeader(String name) {
        return this.headers.getFirst(name).orElse(null);
    }

    public HeaderList getHeaders() {
        return this.headers;
    }

    public Header[] getHeaders(String name) {
        return this.headers.getAll(name);
    }

    public Header getLastHeader(String name) {
        return this.headers.getLast(name).orElse(null);
    }

    public Locale getLocale() {
        return this.statusLine.getLocale();
    }

    public HttpParams getParams() {
        return null;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.statusLine.getProtocolVersion();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public HeaderIterator headerIterator() {
        return this.headers.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headers.headerIterator(name);
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    public void removeHeader(Header value) {
        this.headers.remove(value);
    }

    public void removeHeaders(String name) {
        this.headers.remove(name);
    }

    public BasicHttpResponse setContent(HttpEntity value) {
        this.assertModifiable();
        this.content = value;
        return this;
    }

    public BasicHttpResponse setContent(String value) {
        return this.setContent(HttpEntities.stringEntity(value));
    }

    public void setEntity(HttpEntity entity) {
        this.assertModifiable();
        this.content = entity;
    }

    public void setHeader(Header value) {
        this.headers.set(value);
    }

    public void setHeader(String name, String value) {
        this.headers.set(name, value);
    }

    public BasicHttpResponse setHeader2(Header value) {
        this.headers.set(value);
        return this;
    }

    public BasicHttpResponse setHeader2(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    public void setHeaders(Header[] values) {
        this.headers.removeAll().append(values);
    }

    public BasicHttpResponse setHeaders(HeaderList value) {
        this.assertModifiable();
        this.headers = value.copy();
        return this;
    }

    public BasicHttpResponse setHeaders(List<Header> values) {
        this.headers.set(values);
        return this;
    }

    public BasicHttpResponse setHeaders2(Header ... values) {
        this.headers.set(values);
        return this;
    }

    public void setLocale(Locale loc) {
        this.statusLine.setLocale(loc);
    }

    public BasicHttpResponse setLocale2(Locale value) {
        this.statusLine.setLocale(value);
        return this;
    }

    public BasicHttpResponse setLocation(String value) {
        this.headers.set((Header)Location.of(value));
        return this;
    }

    public BasicHttpResponse setLocation(URI value) {
        this.headers.set((Header)Location.of(value));
        return this;
    }

    public void setParams(HttpParams params) {
    }

    public BasicHttpResponse setProtocolVersion(ProtocolVersion value) {
        this.statusLine.setProtocolVersion(value);
        return this;
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.statusLine.setReasonPhrase(reason);
    }

    public BasicHttpResponse setReasonPhrase2(String value) {
        this.statusLine.setReasonPhrase(value);
        return this;
    }

    public BasicHttpResponse setReasonPhraseCatalog(ReasonPhraseCatalog value) {
        this.statusLine.setReasonPhraseCatalog(value);
        return this;
    }

    public void setStatusCode(int code) throws IllegalStateException {
        this.statusLine.setStatusCode(code);
    }

    public BasicHttpResponse setStatusCode2(int value) {
        this.statusLine.setStatusCode(value);
        return this;
    }

    public BasicHttpResponse setStatusLine(BasicStatusLine value) {
        this.assertModifiable();
        this.statusLine = value.copy();
        return this;
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.statusLine.setProtocolVersion(ver).setStatusCode(code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.statusLine.setProtocolVersion(ver).setReasonPhrase(reason).setStatusCode(code);
    }

    public void setStatusLine(StatusLine value) {
        this.setStatusLine(value.getProtocolVersion(), value.getStatusCode(), value.getReasonPhrase());
    }

    public BasicHttpResponse setUnmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.statusLine).append(' ').append(this.headers);
        if (Utils.nn(this.content)) {
            sb.append(' ').append(this.content);
        }
        return sb.toString();
    }

    protected final void assertModifiable() {
        if (this.unmodifiable) {
            throw ThrowableUtils.unsupportedOp("Bean is read-only", new Object[0]);
        }
    }

    protected void assertStatusCode(HttpResponse response) throws AssertionError {
        AssertionUtils.assertArgNotNull("response", response);
        int expected = this.getStatusLine().getStatusCode();
        int actual = response.getStatusLine().getStatusCode();
        Assertions.assertInteger(actual).setMsg("Unexpected status code.  Expected:[{0}], Actual:[{1}]", expected, actual).is(expected);
    }
}

