/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.variables.VariableManager;

public class IfPlugin
implements Plugin {
    public static final String PARAM_GROUP = "group";
    public static final String PARAM_USER = "user";
    public static final String PARAM_IP = "ip";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_CONTAINS = "contains";
    public static final String PARAM_VAR = "var";
    public static final String PARAM_IS = "is";
    public static final String PARAM_EXISTS = "exists";

    public String execute(Context context, Map<String, String> params) throws PluginException {
        return IfPlugin.ifInclude(context, params) ? ((RenderingManager)context.getEngine().getManager(RenderingManager.class)).textToHTML(context, params.get("_body")) : "";
    }

    public static boolean ifInclude(Context context, Map<String, String> params) throws PluginException {
        String content;
        String group = params.get(PARAM_GROUP);
        String user = params.get(PARAM_USER);
        String ip = params.get(PARAM_IP);
        String page = params.get(PARAM_PAGE);
        String contains = params.get(PARAM_CONTAINS);
        String var = params.get(PARAM_VAR);
        String is = params.get(PARAM_IS);
        String exists = params.get(PARAM_EXISTS);
        boolean include = IfPlugin.checkGroup(context, group);
        include |= IfPlugin.checkUser(context, user);
        include |= IfPlugin.checkIP(context, ip);
        if (page != null) {
            content = ((PageManager)context.getEngine().getManager(PageManager.class)).getPureText(page, -1).trim();
            include |= IfPlugin.checkContains(content, contains);
            include |= IfPlugin.checkIs(content, is);
            include |= IfPlugin.checkExists(context, page, exists);
        }
        if (var != null) {
            content = ((VariableManager)context.getEngine().getManager(VariableManager.class)).getVariable(context, var);
            include |= IfPlugin.checkContains(content, contains);
            include |= IfPlugin.checkIs(content, is);
            include |= IfPlugin.checkVarExists(content, exists);
        }
        return include;
    }

    private static boolean checkExists(Context context, String page, String exists) {
        if (exists == null) {
            return false;
        }
        return !((PageManager)context.getEngine().getManager(PageManager.class)).wikiPageExists(page) ^ TextUtil.isPositive((String)exists);
    }

    private static boolean checkVarExists(String varContent, String exists) {
        if (exists == null) {
            return false;
        }
        return varContent == null ^ TextUtil.isPositive((String)exists);
    }

    private static boolean checkGroup(Context context, String group) {
        if (group == null) {
            return false;
        }
        String[] groupList = StringUtils.split((String)group, (char)'|');
        boolean include = false;
        String[] stringArray = groupList;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String grp;
            String gname = grp = stringArray[i];
            boolean invert = false;
            if (grp.startsWith("!")) {
                if (grp.length() > 1) {
                    gname = grp.substring(1);
                }
                invert = true;
            }
            Principal g = ((AuthorizationManager)context.getEngine().getManager(AuthorizationManager.class)).resolvePrincipal(gname);
            include |= ((AuthorizationManager)context.getEngine().getManager(AuthorizationManager.class)).isUserInRole(context.getWikiSession(), g) ^ invert;
        }
        return include;
    }

    private static boolean checkUser(Context context, String user) {
        if (user == null || context.getCurrentUser() == null) {
            return false;
        }
        String[] list = StringUtils.split((String)user, (char)'|');
        boolean include = false;
        String[] stringArray = list;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String usr;
            String userToCheck = usr = stringArray[i];
            boolean invert = false;
            if (usr.startsWith("!")) {
                invert = true;
                if (user.length() > 1) {
                    userToCheck = usr.substring(1);
                }
            }
            include |= userToCheck.equals(context.getCurrentUser().getName()) ^ invert;
        }
        return include;
    }

    private static boolean checkIP(Context context, String ipaddr) {
        if (ipaddr == null || context.getHttpRequest() == null) {
            return false;
        }
        String[] list = StringUtils.split((String)ipaddr, (char)'|');
        boolean include = false;
        String[] stringArray = list;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String ip;
            String ipaddrToCheck = ip = stringArray[i];
            boolean invert = false;
            if (ip.startsWith("!")) {
                invert = true;
                if (ip.length() > 1) {
                    ipaddrToCheck = ip.substring(1);
                }
            }
            include |= ipaddrToCheck.equals(HttpUtil.getRemoteAddress((HttpServletRequest)context.getHttpRequest())) ^ invert;
        }
        return include;
    }

    private static boolean doMatch(String content, String pattern) throws PluginException {
        Perl5Compiler compiler = new Perl5Compiler();
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            Pattern matchp = compiler.compile(pattern, 16);
            return matcher.matches(content, matchp);
        }
        catch (MalformedPatternException e) {
            throw new PluginException("Faulty pattern " + pattern);
        }
    }

    private static boolean checkContains(String pagecontent, String matchPattern) throws PluginException {
        if (pagecontent == null || matchPattern == null) {
            return false;
        }
        return IfPlugin.doMatch(pagecontent, ".*" + matchPattern + ".*");
    }

    private static boolean checkIs(String content, String matchPattern) throws PluginException {
        if (content == null || matchPattern == null) {
            return false;
        }
        return IfPlugin.doMatch(content, "^" + matchPattern + "$");
    }
}

