/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.noding.BasicSegmentString;

class CoverageRing
extends BasicSegmentString {
    private boolean isInteriorOnRight;
    private boolean[] isInvalid;
    private boolean[] isMatched;

    public static List<CoverageRing> createRings(Geometry geom) {
        List polygons = PolygonExtracter.getPolygons(geom);
        return CoverageRing.createRings(polygons);
    }

    public static List<CoverageRing> createRings(List<Polygon> polygons) {
        ArrayList<CoverageRing> rings = new ArrayList<CoverageRing>();
        for (Polygon poly : polygons) {
            CoverageRing.createRings(poly, rings);
        }
        return rings;
    }

    private static void createRings(Polygon poly, List<CoverageRing> rings) {
        if (poly.isEmpty()) {
            return;
        }
        CoverageRing.addRing(poly.getExteriorRing(), true, rings);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            CoverageRing.addRing(poly.getInteriorRingN(i), false, rings);
        }
    }

    private static void addRing(LinearRing ring, boolean isShell, List<CoverageRing> rings) {
        if (ring.isEmpty()) {
            return;
        }
        rings.add(CoverageRing.createRing(ring, isShell));
    }

    private static CoverageRing createRing(LinearRing ring, boolean isShell) {
        Coordinate[] pts = ring.getCoordinates();
        if (CoordinateArrays.hasRepeatedOrInvalidPoints(pts)) {
            pts = CoordinateArrays.removeRepeatedOrInvalidPoints(pts);
        }
        boolean isCCW = Orientation.isCCW(pts);
        boolean isInteriorOnRight = isShell ? !isCCW : isCCW;
        return new CoverageRing(pts, isInteriorOnRight);
    }

    public static boolean isKnown(List<CoverageRing> rings) {
        for (CoverageRing ring : rings) {
            if (ring.isKnown()) continue;
            return false;
        }
        return true;
    }

    private CoverageRing(Coordinate[] pts, boolean isInteriorOnRight) {
        super(pts, null);
        this.isInteriorOnRight = isInteriorOnRight;
        this.isInvalid = new boolean[this.size() - 1];
        this.isMatched = new boolean[this.size() - 1];
    }

    public Envelope getEnvelope(int start, int end) {
        Envelope env = new Envelope();
        for (int i = start; i < end; ++i) {
            env.expandToInclude(this.getCoordinate(i));
        }
        return env;
    }

    public boolean isInteriorOnRight() {
        return this.isInteriorOnRight;
    }

    public void markInvalid(int i) {
        this.isInvalid[i] = true;
    }

    public void markMatched(int i) {
        this.isMatched[i] = true;
    }

    public boolean isKnown() {
        for (int i = 0; i < this.isMatched.length; ++i) {
            if (this.isMatched[i] && this.isInvalid[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isInvalid(int index) {
        return this.isInvalid[index];
    }

    public boolean isInvalid() {
        for (int i = 0; i < this.isInvalid.length; ++i) {
            if (this.isInvalid[i]) continue;
            return false;
        }
        return true;
    }

    public boolean hasInvalid() {
        for (int i = 0; i < this.isInvalid.length; ++i) {
            if (!this.isInvalid[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isKnown(int i) {
        return this.isMatched[i] || this.isInvalid[i];
    }

    public Coordinate findVertexPrev(int index, Coordinate pt) {
        int iPrev = index;
        Coordinate prev = this.getCoordinate(iPrev);
        while (pt.equals2D(prev)) {
            iPrev = this.prev(iPrev);
            prev = this.getCoordinate(iPrev);
        }
        return prev;
    }

    public Coordinate findVertexNext(int index, Coordinate pt) {
        int iNext = index + 1;
        Coordinate next = this.getCoordinate(iNext);
        while (pt.equals2D(next)) {
            iNext = this.next(iNext);
            next = this.getCoordinate(iNext);
        }
        return next;
    }

    public int prev(int index) {
        if (index == 0) {
            return this.size() - 2;
        }
        return index - 1;
    }

    public int next(int index) {
        if (index < this.size() - 2) {
            return index + 1;
        }
        return 0;
    }

    public void createInvalidLines(GeometryFactory geomFactory, List<LineString> lines) {
        int firstEndIndex;
        if (!this.hasInvalid()) {
            return;
        }
        if (this.isInvalid()) {
            LineString line = this.createLine(0, this.size() - 1, geomFactory);
            lines.add(line);
            return;
        }
        int startIndex = this.findInvalidStart(0);
        int endIndex = firstEndIndex = this.findInvalidEnd(startIndex);
        do {
            startIndex = this.findInvalidStart(endIndex);
            endIndex = this.findInvalidEnd(startIndex);
            LineString line = this.createLine(startIndex, endIndex, geomFactory);
            lines.add(line);
        } while (endIndex != firstEndIndex);
    }

    private int findInvalidStart(int index) {
        while (!this.isInvalid(index)) {
            index = this.nextMarkIndex(index);
        }
        return index;
    }

    private int findInvalidEnd(int index) {
        index = this.nextMarkIndex(index);
        while (this.isInvalid(index)) {
            index = this.nextMarkIndex(index);
        }
        return index;
    }

    private int nextMarkIndex(int index) {
        if (index >= this.isInvalid.length - 1) {
            return 0;
        }
        return index + 1;
    }

    private LineString createLine(int startIndex, int endIndex, GeometryFactory geomFactory) {
        Coordinate[] pts = endIndex < startIndex ? this.extractSectionWrap(startIndex, endIndex) : this.extractSection(startIndex, endIndex);
        return geomFactory.createLineString(pts);
    }

    private Coordinate[] extractSection(int startIndex, int endIndex) {
        int size = endIndex - startIndex + 1;
        Coordinate[] pts = new Coordinate[size];
        int ipts = 0;
        for (int i = startIndex; i <= endIndex; ++i) {
            pts[ipts++] = this.getCoordinate(i).copy();
        }
        return pts;
    }

    private Coordinate[] extractSectionWrap(int startIndex, int endIndex) {
        int size = endIndex + (this.size() - startIndex);
        Coordinate[] pts = new Coordinate[size];
        int index = startIndex;
        for (int i = 0; i < size; ++i) {
            pts[i] = this.getCoordinate(index).copy();
            index = this.nextMarkIndex(index);
        }
        return pts;
    }
}

