/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.rdf.model.RDFWriterF;
import org.apache.jena.rdf.model.RDFWriterI;
import org.apache.jena.rdf.model.impl.NTripleWriter;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NoWriterForLangException;

public class RDFWriterFImpl
implements RDFWriterF {
    public static final String DEFAULTLANG = "RDF/XML";
    private static Map<String, Creator<RDFWriterI>> custom = new LinkedHashMap<String, Creator<RDFWriterI>>();
    private static RDFWriterF rewiredAlternative = null;
    private static final boolean includeRDFXML = false;
    private static String msgNoRDFXML = "RDF/XML is no longer supported in jena-core. Add jena-arq to the classpath";
    private static Set<String> removedLangs = Set.of("RDF/XML", "RDF/XML-ABBREV");

    public static void alternative(RDFWriterF other) {
        rewiredAlternative = other;
    }

    public static RDFWriterF getCurrentRDFWriterF(RDFWriterF other) {
        return rewiredAlternative;
    }

    @Override
    public RDFWriterI getWriter(String lang) {
        Creator<RDFWriterI> c;
        if (lang == null || lang.equals("")) {
            lang = DEFAULTLANG;
        }
        if (rewiredAlternative != null) {
            return rewiredAlternative.getWriter(lang);
        }
        if (removedLangs.contains(lang)) {
            Log.error("RDFWriter", msgNoRDFXML);
        }
        if ((c = custom.get(lang)) == null) {
            throw new NoWriterForLangException("Writer not found: " + lang);
        }
        try {
            return c.create();
        }
        catch (RuntimeException e2) {
            throw new JenaException(e2);
        }
    }

    private static void setup() {
        Creator<RDFWriterI> ntWriter = NTripleWriter::new;
        custom.put("N-TRIPLE", ntWriter);
        custom.put("N-TRIPLES", ntWriter);
        custom.put("N-Triples", ntWriter);
    }

    static {
        RDFWriterFImpl.setup();
    }
}

