/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.setup;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.system.DataDirectory;
import org.apache.sis.system.Fallback;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;

public abstract class OptionalInstallations
extends InstallationResources
implements Localized {
    private static final String EPSG_DOWNLOAD_URL = "https://repo1.maven.org/maven2/org/apache/sis/non-free/sis-epsg/1.4/sis-epsg-1.4.jar";
    private static final int DATABASE_SIZE = 26;
    private final String licenseMimeType;
    protected final Path destinationDirectory;
    private InstallationResources provider;
    private Boolean accepted;

    protected OptionalInstallations(String licenseMimeType) {
        ArgumentChecks.ensureNonEmpty("licenseMimeType", licenseMimeType);
        this.licenseMimeType = licenseMimeType;
        this.destinationDirectory = DataDirectory.DATABASES.getDirectory();
    }

    protected abstract boolean askUserAgreement(String var1, String var2);

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public Set<String> getAuthorities() {
        return this.destinationDirectory != null ? Set.of("EPSG") : Set.of();
    }

    private IllegalArgumentException unsupported(String authority) {
        return new IllegalArgumentException(Errors.getResources(this.getLocale()).getString((short)45, "authority", authority));
    }

    public int getSpaceRequirement(String authority) {
        switch (authority) {
            case "EPSG": {
                return 26;
            }
        }
        throw this.unsupported(authority);
    }

    private String getDownloadURL(String authority) {
        switch (authority) {
            case "EPSG": {
                return System.getProperty("org.apache.sis.epsg.downloadURL", EPSG_DOWNLOAD_URL);
            }
        }
        throw this.unsupported(authority);
    }

    private InstallationResources download(String authority) throws IOException {
        String source = this.getDownloadURL(authority);
        URLClassLoader loader = new URLClassLoader(new URL[]{new URL(source)});
        for (InstallationResources c : ServiceLoader.load(InstallationResources.class, loader)) {
            if (c.getClass().isAnnotationPresent(Fallback.class) || !c.getAuthorities().contains(authority)) continue;
            return c;
        }
        throw new FileNotFoundException(Errors.getResources(this.getLocale()).getString((short)39, source));
    }

    private synchronized InstallationResources provider(String authority, boolean requireAgreement) throws IOException {
        if (!"EPSG".equals(authority)) {
            throw this.unsupported(authority);
        }
        if (this.provider == null) {
            if (!this.askUserAgreement(authority, null)) {
                throw new AccessDeniedException(this.getDownloadURL(authority));
            }
            this.provider = this.download(authority);
        }
        if (requireAgreement) {
            if (this.accepted == null) {
                String license = this.getLicense(authority, this.getLocale(), this.licenseMimeType);
                this.accepted = license == null || this.askUserAgreement(authority, license);
            }
            if (!this.accepted.booleanValue()) {
                throw new AccessDeniedException(this.getDownloadURL(authority));
            }
        }
        return this.provider;
    }

    @Override
    public String getLicense(String authority, Locale locale, String mimeType) throws IOException {
        return this.provider(authority, false).getLicense(authority, locale, mimeType);
    }

    @Override
    public String[] getResourceNames(String authority) throws IOException {
        return this.provider(authority, true).getResourceNames(authority);
    }

    @Override
    public Object getResource(String authority, int index) throws IOException {
        return this.provider(authority, true).getResource(authority, index);
    }

    @Override
    public BufferedReader openScript(String authority, int resource) throws IOException {
        return this.provider(authority, true).openScript(authority, resource);
    }
}

