/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.index;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.FilterMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public class MergeOnFlushMergePolicy
extends FilterMergePolicy {
    private long smallSegmentThresholdBytes = Units.mbToBytes(100.0);

    public MergeOnFlushMergePolicy(MergePolicy mergePolicy) {
        super(mergePolicy);
    }

    public double getSmallSegmentThresholdMB() {
        return Units.bytesToMB(this.smallSegmentThresholdBytes);
    }

    public void setSmallSegmentThresholdMB(double smallSegmentThresholdMB) {
        this.smallSegmentThresholdBytes = Units.mbToBytes(smallSegmentThresholdMB);
    }

    @Override
    public MergePolicy.MergeSpecification findFullFlushMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        ArrayList<SegmentCommitInfo> smallSegments = new ArrayList<SegmentCommitInfo>();
        for (SegmentCommitInfo sci : segmentInfos) {
            if (sci.sizeInBytes() >= this.smallSegmentThresholdBytes || mergeContext.getMergingSegments().contains(sci)) continue;
            smallSegments.add(sci);
        }
        if (smallSegments.size() > 1) {
            MergePolicy.MergeSpecification mergeSpecification = new MergePolicy.MergeSpecification();
            mergeSpecification.add(new MergePolicy.OneMerge(smallSegments));
            return mergeSpecification;
        }
        return null;
    }

    static class Units {
        private Units() {
        }

        public static double bytesToMB(long bytes) {
            return (double)bytes / 1024.0 / 1024.0;
        }

        public static long mbToBytes(double megabytes) {
            return (long)(megabytes * 1024.0 * 1024.0);
        }
    }
}

