/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.shiro;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.fuseki.mod.shiro.FMod_Shiro;
import org.apache.jena.fuseki.mod.shiro.FusekiShiroLib;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.env.ResourceBasedWebEnvironment;
import org.apache.shiro.web.env.WebEnvironment;
import org.slf4j.Logger;

class ShiroEnvironmentLoaderListener
extends EnvironmentLoaderListener {
    public static final Logger shiroConfigLog = FMod_Shiro.shiroConfigLog;
    private List<String> locations;

    ShiroEnvironmentLoaderListener(List<String> locations) {
        this.locations = locations;
    }

    @Override
    protected void customizeEnvironment(WebEnvironment environment) {
        if (this.locations == null) {
            return;
        }
        if (environment instanceof ResourceBasedWebEnvironment) {
            ResourceBasedWebEnvironment env = (ResourceBasedWebEnvironment)environment;
            String[] configLocations = env.getConfigLocations();
            if (configLocations != null && configLocations.length > 0) {
                shiroConfigLog.info(String.format("Shiro file resource %s", Arrays.asList(configLocations)));
                return;
            }
            String loc = FusekiShiroLib.huntForShiroIni(this.locations);
            if (loc == null) {
                shiroConfigLog.info(String.format("No Shiro file found (tried: %s)", this.locations));
                return;
            }
            shiroConfigLog.info("Shiro configuration: " + loc);
            String[] configLocationsHere = new String[]{loc};
            env.setConfigLocations(configLocationsHere);
        }
    }
}

