/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.shex.ShexRecord;
import org.apache.jena.shex.ShexStatus;
import org.apache.jena.shex.sys.ReportItem;

public class ShexReport {
    private final Collection<ReportItem> entries;
    private final Resource resultResource;
    private final List<ShexRecord> reports;
    private final boolean conforms;

    public static Builder create() {
        return new Builder();
    }

    private ShexReport(Collection<ReportItem> entries, List<ShexRecord> reports, PrefixMapping prefixes) {
        this(entries, reports, ShexReport.generate(entries, prefixes));
    }

    private static Resource generate(Collection<ReportItem> entries, PrefixMapping prefixes) {
        return null;
    }

    private ShexReport(Collection<ReportItem> entries, List<ShexRecord> reports, Resource resultResource) {
        this.entries = new ArrayList<ReportItem>(entries);
        this.reports = new ArrayList<ShexRecord>(reports);
        this.resultResource = resultResource;
        this.conforms = reports.stream().allMatch(a -> a.status == ShexStatus.conformant);
        if (this.conforms != entries.isEmpty()) {
            long x = reports.stream().filter(a -> a.status == ShexStatus.conformant).count();
            String msg = String.format("conforms() inconsistent:  e:%s/r:%s %d/%d[%d]\n", this.conforms, entries.isEmpty(), entries.size(), reports.size(), x);
            throw new InternalErrorException(msg);
        }
    }

    public boolean hasReports() {
        return !this.reports.isEmpty();
    }

    public void forEachReport(Consumer<ShexRecord> action) {
        this.reports.forEach(action);
    }

    public Resource getResource() {
        return this.resultResource;
    }

    public Model getModel() {
        return this.resultResource.getModel();
    }

    public Graph getGraph() {
        return this.getModel().getGraph();
    }

    public boolean conforms() {
        return this.conforms;
    }

    public static class Builder {
        private final List<ReportItem> entries = new ArrayList<ReportItem>();
        private final List<ShexRecord> reports = new ArrayList<ShexRecord>();
        private PrefixMapping prefixes = new PrefixMappingImpl();

        public void addPrefixes(PrefixMapping pmap) {
            this.prefixes.setNsPrefixes(pmap);
        }

        public boolean hasEntries() {
            return !this.entries.isEmpty();
        }

        public boolean hasReports() {
            return !this.reports.isEmpty();
        }

        public List<ReportItem> getItems() {
            return this.entries;
        }

        public List<ShexRecord> getReports() {
            return this.reports;
        }

        public void addReportItem(ReportItem e) {
            this.entries.add(e);
        }

        public void shexReport(ShexRecord entry, Node focusNode, ShexStatus result, String reason) {
            ShexRecord ssa = new ShexRecord(entry, focusNode, result, reason);
            this.shexReport(ssa);
        }

        public void shexReport(ShexRecord entry) {
            this.reports.add(entry);
        }

        public ShexReport build() {
            return new ShexReport(this.entries, this.reports, this.prefixes);
        }
    }
}

