/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class ImmutableLazyCollectionCopy<T> {
    private final Collection<T> original;
    private final AtomicReference<Collection<T>> copy = new AtomicReference();

    public ImmutableLazyCollectionCopy(Collection<T> original) {
        this.original = original;
    }

    public Collection<T> get() {
        return this.copy.updateAndGet(existingCopy -> existingCopy == null ? Collections.unmodifiableCollection(new ArrayList<T>(this.original)) : existingCopy);
    }

    public String toString() {
        return Optional.ofNullable(this.copy.get()).orElse(this.original).toString();
    }
}

