/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class IsNullColumnTransformer
extends UnaryColumnTransformer {
    private final boolean isNot;

    public IsNullColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, boolean isNot) {
        super(returnType, childColumnTransformer);
        this.isNot = isNot;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            this.returnType.writeBoolean(columnBuilder, column.isNull(i) ^ this.isNot);
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i]) {
                this.returnType.writeBoolean(columnBuilder, column.isNull(i) ^ this.isNot);
                continue;
            }
            columnBuilder.appendNull();
        }
    }
}

