/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.udf.api.exception.UDFManagementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFExecutableManager
extends ExecutableManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFExecutableManager.class);
    private static UDFExecutableManager INSTANCE = null;

    private UDFExecutableManager(String temporaryLibRoot, String udfLibRoot) {
        super(temporaryLibRoot, udfLibRoot);
    }

    public static synchronized UDFExecutableManager setupAndGetInstance(String temporaryLibRoot, String udfLibRoot) throws IOException {
        if (INSTANCE == null) {
            SystemFileFactory.INSTANCE.makeDirIfNecessary(temporaryLibRoot);
            SystemFileFactory.INSTANCE.makeDirIfNecessary(udfLibRoot);
            SystemFileFactory.INSTANCE.makeDirIfNecessary(udfLibRoot + File.separator + "install");
            INSTANCE = new UDFExecutableManager(temporaryLibRoot, udfLibRoot);
        }
        return INSTANCE;
    }

    public boolean isLocalJarConflicted(UDFInformation udfInformation) throws UDFManagementException {
        String functionName = udfInformation.getFunctionName();
        String existedMd5 = "";
        String md5FilePath = functionName + ".txt";
        boolean hasComputed = false;
        if (this.hasFileUnderTemporaryRoot(md5FilePath)) {
            try {
                existedMd5 = this.readTextFromFileUnderTemporaryRoot(md5FilePath);
                hasComputed = true;
            }
            catch (IOException e) {
                LOGGER.warn("Error occurred when trying to read md5 of {}", (Object)md5FilePath);
            }
        }
        if (!hasComputed) {
            try {
                existedMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(UDFExecutableManager.getInstance().getInstallDir() + File.separator + udfInformation.getJarName(), new String[0]), new OpenOption[0]));
                this.saveTextAsFileUnderTemporaryRoot(existedMd5, md5FilePath);
            }
            catch (IOException e) {
                String errorMessage = String.format("Failed to registered function %s, because error occurred when trying to compute md5 of jar file for function %s ", functionName, functionName);
                LOGGER.warn(errorMessage, (Throwable)e);
                throw new UDFManagementException(errorMessage);
            }
        }
        return !existedMd5.equals(udfInformation.getJarMD5());
    }

    public static UDFExecutableManager getInstance() {
        return INSTANCE;
    }
}

