/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.match.model;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.udf.api.State;

public class PatternState
implements State {
    private List<Double> valueBuffer;
    private List<Long> timeBuffer;

    @Override
    public void reset() {
        this.timeBuffer = new ArrayList<Long>();
        this.valueBuffer = new ArrayList<Double>();
    }

    @Override
    public byte[] serialize() {
        int capacity = 8 + this.valueBuffer.size() * 16;
        ByteBuffer byteBuffer = ByteBuffer.allocate(capacity);
        byteBuffer.putInt(this.valueBuffer.size());
        Object[] times = this.timeBuffer.toArray();
        Object[] values = this.valueBuffer.toArray();
        for (int i = 0; i < this.timeBuffer.size(); ++i) {
            byteBuffer.putLong((Long)times[i]);
            byteBuffer.putDouble((Double)values[i]);
        }
        return byteBuffer.array();
    }

    @Override
    public void deserialize(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int size = byteBuffer.getInt();
        for (int i = 0; i < size; ++i) {
            this.updateBuffer(byteBuffer.getLong(), byteBuffer.getDouble());
        }
    }

    @Override
    public void destroyState() {
        this.timeBuffer.clear();
        this.valueBuffer.clear();
        State.super.destroyState();
    }

    public long getFirstTime() {
        return this.timeBuffer.get(0);
    }

    public List<Double> getValueBuffer() {
        return this.valueBuffer;
    }

    public List<Long> getTimeBuffer() {
        return this.timeBuffer;
    }

    public void updateBuffer(long time, double dataPoint) {
        if (this.timeBuffer == null) {
            this.timeBuffer = new ArrayList<Long>();
        }
        if (this.valueBuffer == null) {
            this.valueBuffer = new ArrayList<Double>();
        }
        this.timeBuffer.add(time);
        this.valueBuffer.add(dataPoint);
    }
}

