/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.task.subtask;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskConnectorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.subtask.connector.PipeConnectorSubtaskLifeCycle;
import org.apache.iotdb.db.pipe.agent.task.subtask.connector.PipeRealtimePriorityBlockingQueue;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionEventCounter;
import org.apache.iotdb.db.subscription.task.subtask.SubscriptionConnectorSubtask;
import org.apache.iotdb.db.subscription.task.subtask.SubscriptionConnectorSubtaskLifeCycle;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionConnectorSubtaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionConnectorSubtaskManager.class);
    private static final String FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE = "Failed to deregister PipeConnectorSubtask. No such subtask: ";
    private final Map<String, PipeConnectorSubtaskLifeCycle> attributeSortedString2SubtaskLifeCycleMap = new HashMap<String, PipeConnectorSubtaskLifeCycle>();

    public synchronized String register(PipeConnectorSubtaskExecutor executor, PipeParameters pipeConnectorParameters, PipeTaskConnectorRuntimeEnvironment environment) {
        String connectorKey = pipeConnectorParameters.getStringOrDefault(Arrays.asList("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()).toLowerCase();
        if (!BuiltinPipePlugin.SUBSCRIPTION_SINK.getPipePluginName().equals(connectorKey)) {
            throw new SubscriptionException("The SubscriptionConnectorSubtaskManager only supports subscription-sink.");
        }
        PipeEventCommitManager.getInstance().register(environment.getPipeName(), environment.getCreationTime(), environment.getRegionId(), connectorKey);
        boolean realTimeFirst = pipeConnectorParameters.getBooleanOrDefault(Arrays.asList("connector.realtime-first", "sink.realtime-first"), true);
        String attributeSortedString = this.generateAttributeSortedString(pipeConnectorParameters);
        attributeSortedString = "__subscription_" + attributeSortedString;
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            PipeRealtimePriorityBlockingQueue pendingQueue = realTimeFirst ? new PipeRealtimePriorityBlockingQueue() : new UnboundedBlockingPendingQueue((PipeEventCounter)new PipeDataRegionEventCounter());
            PipeConnector pipeConnector = PipeDataNodeAgent.plugin().dataRegion().reflectConnector(pipeConnectorParameters);
            try {
                pipeConnector.validate(new PipeParameterValidator(pipeConnectorParameters));
                pipeConnector.customize(pipeConnectorParameters, (PipeConnectorRuntimeConfiguration)new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)environment));
                pipeConnector.handshake();
            }
            catch (Exception e) {
                try {
                    pipeConnector.close();
                }
                catch (Exception closeException) {
                    LOGGER.warn("Failed to close connector after failed to initialize connector. Ignore this exception.", (Throwable)closeException);
                }
                throw new PipeException("Failed to construct PipeConnector, because of " + e.getMessage(), (Throwable)e);
            }
            String topicName = pipeConnectorParameters.getString("sink.topic");
            String consumerGroupId = pipeConnectorParameters.getString("sink.consumer-group");
            if (Objects.isNull(topicName) || Objects.isNull(consumerGroupId)) {
                throw new SubscriptionException(String.format("Failed to construct subscription connector, because of %s or %s does not exist in pipe connector parameters", "sink.topic", "sink.consumer-group"));
            }
            SubscriptionConnectorSubtask subtask = new SubscriptionConnectorSubtask(String.format("%s_%s", attributeSortedString, environment.getCreationTime()), environment.getCreationTime(), attributeSortedString, 0, pendingQueue, pipeConnector, topicName, consumerGroupId);
            SubscriptionConnectorSubtaskLifeCycle pipeConnectorSubtaskLifeCycle = new SubscriptionConnectorSubtaskLifeCycle(executor, subtask, pendingQueue);
            this.attributeSortedString2SubtaskLifeCycleMap.put(attributeSortedString, pipeConnectorSubtaskLifeCycle);
        }
        PipeConnectorSubtaskLifeCycle lifeCycle = this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString);
        lifeCycle.register();
        return attributeSortedString;
    }

    public synchronized void deregister(String pipeName, long creationTime, int regionId, String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        PipeConnectorSubtaskLifeCycle lifeCycle = this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString);
        if (lifeCycle.deregister(pipeName, regionId)) {
            this.attributeSortedString2SubtaskLifeCycleMap.remove(attributeSortedString);
        }
        PipeEventCommitManager.getInstance().deregister(pipeName, creationTime, regionId);
    }

    public synchronized void start(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        PipeConnectorSubtaskLifeCycle lifeCycle = this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString);
        lifeCycle.start();
    }

    public synchronized void stop(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        PipeConnectorSubtaskLifeCycle lifeCycle = this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString);
        lifeCycle.stop();
    }

    public UnboundedBlockingPendingQueue<Event> getPipeConnectorPendingQueue(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException("Failed to get PendingQueue. No such subtask: " + attributeSortedString);
        }
        return this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString).getPendingQueue();
    }

    private String generateAttributeSortedString(PipeParameters pipeConnectorParameters) {
        TreeMap sortedStringSourceMap = new TreeMap(pipeConnectorParameters.getAttribute());
        sortedStringSourceMap.remove("__system.restart");
        return sortedStringSourceMap.toString();
    }

    private SubscriptionConnectorSubtaskManager() {
    }

    public static SubscriptionConnectorSubtaskManager instance() {
        return SubscriptionConnectorSubtaskManagerHolder.INSTANCE;
    }

    private static class SubscriptionConnectorSubtaskManagerHolder {
        private static final SubscriptionConnectorSubtaskManager INSTANCE = new SubscriptionConnectorSubtaskManager();

        private SubscriptionConnectorSubtaskManagerHolder() {
        }
    }
}

