/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SetMonitoringModeRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=767");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=769");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=768");
    private final RequestHeader requestHeader;
    private final UInteger subscriptionId;
    private final MonitoringMode monitoringMode;
    private final UInteger[] monitoredItemIds;

    public SetMonitoringModeRequest(RequestHeader requestHeader, UInteger subscriptionId, MonitoringMode monitoringMode, UInteger[] monitoredItemIds) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.monitoringMode = monitoringMode;
        this.monitoredItemIds = monitoredItemIds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    public UInteger[] getMonitoredItemIds() {
        return this.monitoredItemIds;
    }

    protected SetMonitoringModeRequest(SetMonitoringModeRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((SetMonitoringModeRequestBuilder)b).requestHeader;
        this.subscriptionId = ((SetMonitoringModeRequestBuilder)b).subscriptionId;
        this.monitoringMode = ((SetMonitoringModeRequestBuilder)b).monitoringMode;
        this.monitoredItemIds = ((SetMonitoringModeRequestBuilder)b).monitoredItemIds;
    }

    public static SetMonitoringModeRequestBuilder<?, ?> builder() {
        return new SetMonitoringModeRequestBuilderImpl();
    }

    public SetMonitoringModeRequestBuilder<?, ?> toBuilder() {
        return new SetMonitoringModeRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetMonitoringModeRequest)) {
            return false;
        }
        SetMonitoringModeRequest other = (SetMonitoringModeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        MonitoringMode this$monitoringMode = this.getMonitoringMode();
        MonitoringMode other$monitoringMode = other.getMonitoringMode();
        if (this$monitoringMode == null ? other$monitoringMode != null : !this$monitoringMode.equals(other$monitoringMode)) {
            return false;
        }
        return Arrays.deepEquals(this.getMonitoredItemIds(), other.getMonitoredItemIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetMonitoringModeRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        MonitoringMode $monitoringMode = this.getMonitoringMode();
        result = result * 59 + ($monitoringMode == null ? 43 : $monitoringMode.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMonitoredItemIds());
        return result;
    }

    @Override
    public String toString() {
        return "SetMonitoringModeRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionId=" + this.getSubscriptionId() + ", monitoringMode=" + this.getMonitoringMode() + ", monitoredItemIds=" + Arrays.deepToString(this.getMonitoredItemIds()) + ")";
    }

    private static final class SetMonitoringModeRequestBuilderImpl
    extends SetMonitoringModeRequestBuilder<SetMonitoringModeRequest, SetMonitoringModeRequestBuilderImpl> {
        private SetMonitoringModeRequestBuilderImpl() {
        }

        @Override
        protected SetMonitoringModeRequestBuilderImpl self() {
            return this;
        }

        @Override
        public SetMonitoringModeRequest build() {
            return new SetMonitoringModeRequest(this);
        }
    }

    public static abstract class SetMonitoringModeRequestBuilder<C extends SetMonitoringModeRequest, B extends SetMonitoringModeRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger subscriptionId;
        private MonitoringMode monitoringMode;
        private UInteger[] monitoredItemIds;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SetMonitoringModeRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SetMonitoringModeRequest instance, SetMonitoringModeRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionId(instance.subscriptionId);
            b.monitoringMode(instance.monitoringMode);
            b.monitoredItemIds(instance.monitoredItemIds);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B monitoringMode(MonitoringMode monitoringMode) {
            this.monitoringMode = monitoringMode;
            return (B)this.self();
        }

        public B monitoredItemIds(UInteger[] monitoredItemIds) {
            this.monitoredItemIds = monitoredItemIds;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SetMonitoringModeRequest.SetMonitoringModeRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionId=" + this.subscriptionId + ", monitoringMode=" + this.monitoringMode + ", monitoredItemIds=" + Arrays.deepToString(this.monitoredItemIds) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SetMonitoringModeRequest> {
        @Override
        public Class<SetMonitoringModeRequest> getType() {
            return SetMonitoringModeRequest.class;
        }

        @Override
        public SetMonitoringModeRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            MonitoringMode monitoringMode = decoder.readEnum("MonitoringMode", MonitoringMode.class);
            UInteger[] monitoredItemIds = decoder.readUInt32Array("MonitoredItemIds");
            return new SetMonitoringModeRequest(requestHeader, subscriptionId, monitoringMode, monitoredItemIds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SetMonitoringModeRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeEnum("MonitoringMode", value.getMonitoringMode());
            encoder.writeUInt32Array("MonitoredItemIds", value.getMonitoredItemIds());
        }
    }
}

