/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.bitpacking.IntPacker;
import org.apache.tsfile.encoding.decoder.SinglePrecisionDecoderV2;
import org.apache.tsfile.encoding.decoder.SprintzDecoder;
import org.apache.tsfile.encoding.fire.IntFire;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class FloatSprintzDecoder
extends SprintzDecoder {
    IntPacker packer;
    IntFire firePred;
    private float preValue;
    private final float[] currentBuffer;
    private final int[] convertBuffer;
    private float currentValue;
    private final String predictScheme = TSFileDescriptor.getInstance().getConfig().getSprintzPredictScheme();

    public FloatSprintzDecoder() {
        this.currentBuffer = new float[this.Block_size + 1];
        this.convertBuffer = new int[this.Block_size];
        this.firePred = new IntFire(2);
        this.reset();
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        int minLenth = 5;
        return this.isBlockReaded && this.currentCount < this.Block_size || buffer.remaining() >= minLenth;
    }

    @Override
    public void reset() {
        super.reset();
        this.currentValue = 0.0f;
        this.preValue = 0.0f;
        this.currentCount = 0;
        Arrays.fill(this.currentBuffer, 0.0f);
        Arrays.fill(this.convertBuffer, 0);
    }

    @Override
    protected void decodeBlock(ByteBuffer in) throws IOException {
        this.bitWidth = ReadWriteForEncodingUtils.readIntLittleEndianPaddedOnBitWidth(in, 1);
        if ((this.bitWidth & 0x80) != 0) {
            this.decodeSize = this.bitWidth & 0xFFFFFF7F;
            SinglePrecisionDecoderV2 decoder = new SinglePrecisionDecoderV2();
            for (int i = 0; i < this.decodeSize; ++i) {
                this.currentBuffer[i] = decoder.readFloat(in);
            }
        } else {
            int i;
            this.decodeSize = this.Block_size + 1;
            this.currentBuffer[0] = this.preValue = in.getFloat();
            int[] tmpBuffer = new int[8];
            this.packer = new IntPacker(this.bitWidth);
            byte[] packcle = new byte[this.bitWidth];
            for (i = 0; i < this.bitWidth; ++i) {
                packcle[i] = in.get();
            }
            this.packer.unpack8Values(packcle, 0, tmpBuffer);
            for (i = 0; i < 8; ++i) {
                this.convertBuffer[i] = tmpBuffer[i];
            }
            this.recalculate();
        }
        this.isBlockReaded = true;
    }

    @Override
    protected void recalculate() {
        int i;
        for (i = 0; i < this.Block_size; ++i) {
            this.convertBuffer[i] = this.convertBuffer[i] % 2 == 0 ? -this.convertBuffer[i] / 2 : (this.convertBuffer[i] + 1) / 2;
        }
        if (this.predictScheme.equals("delta")) {
            this.convertBuffer[0] = this.convertBuffer[0] + Float.floatToIntBits(this.preValue);
            this.currentBuffer[1] = Float.intBitsToFloat(this.convertBuffer[0]);
            for (i = 1; i < this.Block_size; ++i) {
                int n = i;
                this.convertBuffer[n] = this.convertBuffer[n] + this.convertBuffer[i - 1];
                this.currentBuffer[i + 1] = Float.intBitsToFloat(this.convertBuffer[i]);
            }
        } else if (this.predictScheme.equals("fire")) {
            this.firePred.reset();
            int p = this.firePred.predict(Float.floatToIntBits(this.preValue));
            int e = this.convertBuffer[0];
            this.convertBuffer[0] = this.convertBuffer[0] + p;
            this.currentBuffer[1] = Float.intBitsToFloat(this.convertBuffer[0]);
            this.firePred.train(Float.floatToIntBits(this.preValue), this.convertBuffer[0], e);
            for (int i2 = 1; i2 < this.Block_size; ++i2) {
                int pred = this.firePred.predict(this.convertBuffer[i2 - 1]);
                int err = this.convertBuffer[i2];
                int n = i2;
                this.convertBuffer[n] = this.convertBuffer[n] + pred;
                this.currentBuffer[i2 + 1] = Float.intBitsToFloat(this.convertBuffer[i2]);
                this.firePred.train(this.convertBuffer[i2 - 1], this.convertBuffer[i2], err);
            }
        } else {
            throw new UnsupportedOperationException("Sprintz predictive method {} is not supported.");
        }
    }

    @Override
    public float readFloat(ByteBuffer buffer) {
        if (!this.isBlockReaded) {
            try {
                this.decodeBlock(buffer);
            }
            catch (IOException e) {
                logger.error("Error occured when readInt with Sprintz Decoder.", (Throwable)e);
            }
        }
        this.currentValue = this.currentBuffer[this.currentCount];
        ++this.currentCount;
        if (this.currentCount == this.decodeSize) {
            this.isBlockReaded = false;
            this.currentCount = 0;
        }
        return this.currentValue;
    }
}

