/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.mcp.core.props.MCPProperties;
import org.apache.seata.mcp.core.props.NameSpaceDetail;
import org.apache.seata.mcp.core.utils.DateUtils;
import org.apache.seata.mcp.entity.dto.McpGlobalSessionParamDto;
import org.apache.seata.mcp.entity.param.McpGlobalAbnormalSessionParam;
import org.apache.seata.mcp.entity.param.McpGlobalSessionParam;
import org.apache.seata.mcp.entity.vo.McpGlobalSessionVO;
import org.apache.seata.mcp.service.ConsoleApiService;
import org.apache.seata.mcp.service.ModifyConfirmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springaicommunity.mcp.annotation.McpToolParam;
import org.springframework.stereotype.Service;

@Service
public class GlobalSessionTools {
    private final Logger logger = LoggerFactory.getLogger(GlobalSessionTools.class);
    private final ConsoleApiService mcpRPCService;
    private final MCPProperties mcpProperties;
    private final ObjectMapper objectMapper;
    private final ModifyConfirmService modifyConfirmService;
    private final List<Integer> exceptionStatus = new ArrayList<Integer>();
    public static final int ABNORMAL_SESSION_PAGE_SIZE = 30;

    public GlobalSessionTools(ConsoleApiService mcpRPCService, MCPProperties mcpProperties, ObjectMapper objectMapper, ModifyConfirmService modifyConfirmService) {
        this.mcpRPCService = mcpRPCService;
        this.mcpProperties = mcpProperties;
        this.objectMapper = objectMapper;
        this.modifyConfirmService = modifyConfirmService;
        this.exceptionStatus.add(GlobalStatus.CommitFailed.getCode());
        this.exceptionStatus.add(GlobalStatus.TimeoutRollbackFailed.getCode());
        this.exceptionStatus.add(GlobalStatus.RollbackFailed.getCode());
    }

    @McpTool(description="Query global transactions")
    public PageResult<McpGlobalSessionVO> queryGlobalSession(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Query parameter objects") McpGlobalSessionParamDto paramDto) {
        McpGlobalSessionParam param = McpGlobalSessionParam.convertFromDtoParam(paramDto);
        Long timeStart = param.getTimeStart();
        Long timeEnd = param.getTimeEnd();
        Long maxQueryDuration = this.mcpProperties.getQueryDuration();
        if (timeStart != null || timeEnd != null) {
            if (timeStart == null) {
                timeStart = timeEnd - maxQueryDuration;
                param.setTimeStart(timeStart);
            }
            if (timeEnd == null) {
                timeEnd = timeStart + maxQueryDuration;
                param.setTimeEnd(timeEnd);
            }
            if (DateUtils.judgeExceedTimeDuration(timeStart, timeEnd, maxQueryDuration)) {
                return PageResult.failure((String)"", (String)String.format("The query time span is not allowed to exceed the max query duration: %s hours", DateUtils.convertToHourFromTimeStamp(maxQueryDuration)));
            }
        }
        PageResult pageResult = null;
        String result = this.mcpRPCService.getCallTC(nameSpaceDetail, "/api/v1/console/globalSession/query", (Object)param, null, null);
        try {
            pageResult = (PageResult)this.objectMapper.readValue(result, (TypeReference)new TypeReference<PageResult<McpGlobalSessionVO>>(){});
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage());
        }
        if (pageResult == null) {
            return PageResult.failure((String)"", (String)"query global session failed");
        }
        return pageResult;
    }

    @McpTool(description="Delete the global session, Get the modify key before you delete")
    public String deleteGlobalSession(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global transaction id") String xid, @McpToolParam(description="Modify key") String modifyKey) {
        if (!this.modifyConfirmService.isValidKey(modifyKey).booleanValue()) {
            return "The modify key is not available";
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("xid", xid);
        String result = this.mcpRPCService.deleteCallTC(nameSpaceDetail, "/api/v1/console/globalSession/deleteGlobalSession", null, pathParams, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("delete global session failed, xid: %s", xid);
        }
        return result;
    }

    @McpTool(description="Stop the global session retry, Get the modify key before you stop")
    public String stopGlobalSession(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global transaction id") String xid, @McpToolParam(description="Modify key") String modifyKey) {
        if (!this.modifyConfirmService.isValidKey(modifyKey).booleanValue()) {
            return "The modify key is not available";
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("xid", xid);
        String result = this.mcpRPCService.putCallTC(nameSpaceDetail, "/api/v1/console/globalSession/stopGlobalSession", null, pathParams, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("stop global session retry failed, xid: %s", xid);
        }
        return result;
    }

    @McpTool(description="Start the global session retry, Get the modify key before you start")
    public String startGlobalSession(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global transaction id") String xid, @McpToolParam(description="Modify key") String modifyKey) {
        if (!this.modifyConfirmService.isValidKey(modifyKey).booleanValue()) {
            return "The modify key is not available";
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("xid", xid);
        String result = this.mcpRPCService.putCallTC(nameSpaceDetail, "/api/v1/console/globalSession/startGlobalSession", null, pathParams, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("start the global session retry failed, xid: %s", xid);
        }
        return result;
    }

    @McpTool(description="Send global session to commit or rollback to rm, Get the modify key before you send")
    public String sendCommitOrRollback(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global transaction id") String xid, @McpToolParam(description="Modify key") String modifyKey) {
        if (!this.modifyConfirmService.isValidKey(modifyKey).booleanValue()) {
            return "The modify key is not available";
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("xid", xid);
        String result = this.mcpRPCService.putCallTC(nameSpaceDetail, "/api/v1/console/globalSession/sendCommitOrRollback", null, pathParams, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("send global session to commit or rollback to rm failed, xid: %s", xid);
        }
        return result;
    }

    @McpTool(description="Change the global session status, Used to change transactions that are in a failed commit or rollback failed state to a retry state, Get the modify key before you change")
    public String changeGlobalStatus(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global transaction id") String xid, @McpToolParam(description="Modify key") String modifyKey) {
        if (!this.modifyConfirmService.isValidKey(modifyKey).booleanValue()) {
            return "The modify key is not available";
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("xid", xid);
        String result = this.mcpRPCService.putCallTC(nameSpaceDetail, "/api/v1/console/globalSession/changeGlobalStatus", null, pathParams, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("change the global session status failed, xid: %s", xid);
        }
        return result;
    }

    @McpTool(description="Check out the abnormal transaction")
    public List<McpGlobalSessionVO> getAbnormalSessions(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Query Param") McpGlobalAbnormalSessionParam abnormalSessionParam) {
        ArrayList<McpGlobalSessionVO> result = new ArrayList<McpGlobalSessionVO>();
        McpGlobalSessionParamDto param = McpGlobalSessionParamDto.convertFromAbnormalParam(abnormalSessionParam);
        param.setPageSize(30);
        for (Integer status : this.exceptionStatus) {
            param.setStatus(status);
            List datas = this.queryGlobalSession(nameSpaceDetail, param).getData();
            if (datas == null || datas.isEmpty()) continue;
            result.addAll(datas);
        }
        return result;
    }
}

