/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.serializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializerServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerServiceLoader.class);
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final SerializerType[] DEFAULT_SERIALIZER_TYPE = new SerializerType[]{SerializerType.SEATA, SerializerType.PROTOBUF, SerializerType.KRYO, SerializerType.HESSIAN, SerializerType.FASTJSON2, SerializerType.FURY, SerializerType.FORY};
    private static final Map<String, Serializer> SERIALIZER_MAP = new HashMap<String, Serializer>();
    private static final Map<String, String> SERIALIZER_ALIAS_MAP = new HashMap<String, String>();
    private static final String SPLIT_CHAR = ",";
    private static final String PROTOBUF_SERIALIZER_CLASS_NAME = "org.apache.seata.serializer.protobuf.ProtobufSerializer";
    private static final boolean CONTAINS_PROTOBUF_DEPENDENCY;

    private SerializerServiceLoader() {
    }

    public static Serializer load(SerializerType type, byte version) throws EnhancedServiceNotFoundException {
        Serializer serializer;
        String resolvedSerializerName;
        if (type == SerializerType.PROTOBUF && !CONTAINS_PROTOBUF_DEPENDENCY) {
            throw new EnhancedServiceNotFoundException("The class 'org.apache.seata.serializer.protobuf.ProtobufSerializer' not found. Please manually reference 'org.apache.seata:seata-serializer-protobuf' dependency.");
        }
        String serializerName = SerializerServiceLoader.serializerKey(type, version);
        if (!Objects.equals(serializerName, resolvedSerializerName = SerializerServiceLoader.resolveSerializerName(serializerName))) {
            LOGGER.info("Since {} is no longer maintained, This serialization extension has been replaced with {}.", (Object)serializerName, (Object)resolvedSerializerName);
        }
        if ((serializer = SERIALIZER_MAP.get(resolvedSerializerName)) == null) {
            serializer = type == SerializerType.SEATA ? (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)type.name(), (Object[])new Object[]{version}) : (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)resolvedSerializerName);
            SERIALIZER_MAP.put(serializerName, serializer);
        }
        return serializer;
    }

    public static Serializer load(SerializerType type) throws EnhancedServiceNotFoundException {
        Serializer serializer;
        String resolvedSerializerName;
        if (type == SerializerType.PROTOBUF && !CONTAINS_PROTOBUF_DEPENDENCY) {
            throw new EnhancedServiceNotFoundException("The class 'org.apache.seata.serializer.protobuf.ProtobufSerializer' not found. Please manually reference 'org.apache.seata:seata-serializer-protobuf' dependency.");
        }
        String serializerName = type.name();
        if (!Objects.equals(serializerName, resolvedSerializerName = SerializerServiceLoader.resolveSerializerName(serializerName))) {
            LOGGER.info("Since {} is no longer maintained, This serialization extension has been replaced with {}.", (Object)serializerName, (Object)resolvedSerializerName);
        }
        if ((serializer = SERIALIZER_MAP.get(resolvedSerializerName)) == null) {
            serializer = (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)resolvedSerializerName);
            SERIALIZER_MAP.put(serializerName, serializer);
        }
        return serializer;
    }

    private static String serializerKey(SerializerType type, byte version) {
        if (type == SerializerType.SEATA) {
            return type.name() + version;
        }
        return type.name();
    }

    public static List<SerializerType> getSupportedSerializers() {
        String[] serializerNameArray;
        ArrayList<SerializerType> supportedSerializers = new ArrayList<SerializerType>();
        String defaultSupportSerializers = Arrays.stream(DEFAULT_SERIALIZER_TYPE).map(Enum::name).collect(Collectors.joining(SPLIT_CHAR));
        String serializerNames = CONFIG.getConfig("transport.serialization", defaultSupportSerializers);
        for (String serializerName : serializerNameArray = serializerNames.split(SPLIT_CHAR)) {
            try {
                SerializerType serializerType = SerializerType.getByName(serializerName);
                supportedSerializers.add(serializerType);
            }
            catch (IllegalArgumentException ignore) {
                LOGGER.warn("Invalid serializer name: " + serializerName);
            }
        }
        return supportedSerializers.stream().distinct().collect(Collectors.toList());
    }

    public static SerializerType getDefaultSerializerType() {
        return SerializerServiceLoader.getSupportedSerializers().get(0);
    }

    private static String resolveSerializerName(String serializerName) {
        return SERIALIZER_ALIAS_MAP.getOrDefault(serializerName.toLowerCase(), serializerName);
    }

    static {
        SERIALIZER_ALIAS_MAP.put("fury", "fory");
        CONTAINS_PROTOBUF_DEPENDENCY = ReflectionUtil.isClassPresent((String)PROTOBUF_SERIALIZER_CLASS_NAME);
    }
}

