/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.ResourceMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.InstrumentationScopeMetricsStatelessMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.ResourceMetrics;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ResourceMetricsStatelessMarshaler
implements StatelessMarshaler2<Resource, Map<InstrumentationScopeInfo, List<MetricData>>> {
    static final ResourceMetricsStatelessMarshaler INSTANCE = new ResourceMetricsStatelessMarshaler();
    private static final MarshalerContext.Key SCOPE_METRIC_WRITER_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key SCOPE_METRIC_SIZE_CALCULATOR_KEY = MarshalerContext.key();

    private ResourceMetricsStatelessMarshaler() {
    }

    public void writeTo(Serializer output, Resource resource, Map<InstrumentationScopeInfo, List<MetricData>> scopeMap, MarshalerContext context) throws IOException {
        ResourceMarshaler resourceMarshaler = (ResourceMarshaler)((Object)context.getData(ResourceMarshaler.class));
        output.serializeMessage(ResourceMetrics.RESOURCE, (Marshaler)resourceMarshaler);
        output.serializeRepeatedMessageWithContext(ResourceMetrics.SCOPE_METRICS, scopeMap, (StatelessMarshaler2)InstrumentationScopeMetricsStatelessMarshaler.INSTANCE, context, SCOPE_METRIC_WRITER_KEY);
        output.serializeStringWithContext(ResourceMetrics.SCHEMA_URL, resource.getSchemaUrl(), context);
    }

    public int getBinarySerializedSize(Resource resource, Map<InstrumentationScopeInfo, List<MetricData>> scopeMap, MarshalerContext context) {
        int size = 0;
        ResourceMarshaler resourceMarshaler = ResourceMarshaler.create(resource);
        context.addData((Object)resourceMarshaler);
        size += MarshalerUtil.sizeMessage((ProtoFieldInfo)ResourceMetrics.RESOURCE, (Marshaler)resourceMarshaler);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)ResourceMetrics.SCOPE_METRICS, scopeMap, (StatelessMarshaler2)InstrumentationScopeMetricsStatelessMarshaler.INSTANCE, (MarshalerContext)context, (MarshalerContext.Key)SCOPE_METRIC_SIZE_CALCULATOR_KEY);
        return size += StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)ResourceMetrics.SCHEMA_URL, (String)resource.getSchemaUrl(), (MarshalerContext)context);
    }
}

