/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.InputStream;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ImmutableMapValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public class InfluxDBException
extends RuntimeException {
    static final String FIELD_TYPE_CONFLICT_ERROR = "field type conflict";
    static final String POINTS_BEYOND_RETENTION_POLICY_ERROR = "points beyond retention policy";
    static final String UNABLE_TO_PARSE_ERROR = "unable to parse";
    static final String HINTED_HAND_OFF_QUEUE_NOT_EMPTY_ERROR = "hinted handoff queue not empty";
    static final String CACHE_MAX_MEMORY_SIZE_EXCEEDED_ERROR = "cache-max-memory-size exceeded";
    static final String DATABASE_NOT_FOUND_ERROR = "database not found";
    static final String USER_REQUIRED_ERROR = "user is required to write to database";
    static final String USER_NOT_AUTHORIZED_ERROR = "user is not authorized to write to database";
    static final String AUTHORIZATION_FAILED_ERROR = "authorization failed";
    static final String USERNAME_REQUIRED_ERROR = "username required";

    public InfluxDBException(String message) {
        super(message);
    }

    public InfluxDBException(String message, Throwable cause) {
        super(message, cause);
    }

    public InfluxDBException(Throwable cause) {
        super(cause);
    }

    public boolean isRetryWorth() {
        return true;
    }

    private static InfluxDBException buildExceptionFromErrorMessage(String errorMessage) {
        if (errorMessage.contains(DATABASE_NOT_FOUND_ERROR)) {
            return new DatabaseNotFoundException(errorMessage);
        }
        if (errorMessage.contains(POINTS_BEYOND_RETENTION_POLICY_ERROR)) {
            return new PointsBeyondRetentionPolicyException(errorMessage);
        }
        if (errorMessage.contains(FIELD_TYPE_CONFLICT_ERROR)) {
            return new FieldTypeConflictException(errorMessage);
        }
        if (errorMessage.contains(UNABLE_TO_PARSE_ERROR)) {
            return new UnableToParseException(errorMessage);
        }
        if (errorMessage.contains(HINTED_HAND_OFF_QUEUE_NOT_EMPTY_ERROR)) {
            return new HintedHandOffQueueNotEmptyException(errorMessage);
        }
        if (errorMessage.contains(CACHE_MAX_MEMORY_SIZE_EXCEEDED_ERROR)) {
            return new CacheMaxMemorySizeExceededException(errorMessage);
        }
        if (errorMessage.contains(USER_REQUIRED_ERROR) || errorMessage.contains(USER_NOT_AUTHORIZED_ERROR) || errorMessage.contains(AUTHORIZATION_FAILED_ERROR) || errorMessage.contains(USERNAME_REQUIRED_ERROR)) {
            return new AuthorizationFailedException(errorMessage);
        }
        return new InfluxDBException(errorMessage);
    }

    public static InfluxDBException buildExceptionForErrorState(String errorBody) {
        try {
            Moshi moshi = new Moshi.Builder().build();
            JsonAdapter adapter = moshi.adapter(ErrorMessage.class).lenient();
            ErrorMessage errorMessage = (ErrorMessage)adapter.fromJson(errorBody);
            return InfluxDBException.buildExceptionFromErrorMessage(errorMessage.error);
        }
        catch (Exception e) {
            return new InfluxDBException(errorBody);
        }
    }

    public static InfluxDBException buildExceptionForErrorState(InputStream messagePackErrorBody) {
        try {
            MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((InputStream)messagePackErrorBody);
            ImmutableMapValue mapVal = (ImmutableMapValue)unpacker.unpackValue();
            return InfluxDBException.buildExceptionFromErrorMessage(((Value)mapVal.map().get(new ImmutableStringValueImpl("error"))).toString());
        }
        catch (Exception e) {
            return new InfluxDBException(e);
        }
    }

    private static class ErrorMessage {
        public String error;

        private ErrorMessage() {
        }
    }

    public static final class AuthorizationFailedException
    extends InfluxDBException {
        public AuthorizationFailedException(String message) {
            super(message);
        }

        @Override
        public boolean isRetryWorth() {
            return false;
        }
    }

    public static final class RetryBufferOverrunException
    extends InfluxDBException {
        public RetryBufferOverrunException(String message) {
            super(message);
        }

        @Override
        public boolean isRetryWorth() {
            return false;
        }
    }

    public static final class CacheMaxMemorySizeExceededException
    extends InfluxDBException {
        private CacheMaxMemorySizeExceededException(String message) {
            super(message);
        }

        @Override
        public boolean isRetryWorth() {
            return true;
        }
    }

    public static final class PointsBeyondRetentionPolicyException
    extends InfluxDBException {
        private PointsBeyondRetentionPolicyException(String message) {
            super(message);
        }

        @Override
        public boolean isRetryWorth() {
            return false;
        }
    }

    public static final class FieldTypeConflictException
    extends InfluxDBException {
        private FieldTypeConflictException(String message) {
            super(message);
        }

        @Override
        public boolean isRetryWorth() {
            return false;
        }
    }

    public static final class UnableToParseException
    extends InfluxDBException {
        private UnableToParseException(String message) {
            super(message);
        }

        @Override
        public boolean isRetryWorth() {
            return false;
        }
    }

    public static final class HintedHandOffQueueNotEmptyException
    extends InfluxDBException {
        private HintedHandOffQueueNotEmptyException(String message) {
            super(message);
        }

        @Override
        public boolean isRetryWorth() {
            return false;
        }
    }

    public static final class DatabaseNotFoundException
    extends InfluxDBException {
        private DatabaseNotFoundException(String message) {
            super(message);
        }

        @Override
        public boolean isRetryWorth() {
            return false;
        }
    }
}

