/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.logging;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.logging.LogFileWebEndpointProperties;
import org.springframework.boot.actuate.logging.LogFileWebEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.logging.LogFile;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnAvailableEndpoint(value=LogFileWebEndpoint.class)
@EnableConfigurationProperties(value={LogFileWebEndpointProperties.class})
public class LogFileWebEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={LogFileCondition.class})
    public LogFileWebEndpoint logFileWebEndpoint(ObjectProvider<LogFile> logFile, LogFileWebEndpointProperties properties) {
        return new LogFileWebEndpoint((LogFile)logFile.getIfAvailable(), properties.getExternalFile());
    }

    private static final class LogFileCondition
    extends SpringBootCondition {
        private LogFileCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            String config = this.getLogFileConfig(environment, "logging.file.name");
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Log File", (Object[])new Object[0]);
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((ConditionMessage)message.found("logging.file.name").items(new Object[]{config}));
            }
            config = this.getLogFileConfig(environment, "logging.file.path");
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((ConditionMessage)message.found("logging.file.path").items(new Object[]{config}));
            }
            config = environment.getProperty("management.endpoint.logfile.external-file");
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((ConditionMessage)message.found("management.endpoint.logfile.external-file").items(new Object[]{config}));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("logging file").atAll());
        }

        private String getLogFileConfig(Environment environment, String configName) {
            return environment.resolvePlaceholders("${" + configName + ":}");
        }
    }
}

