/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.pdf.export;

import cn.afterturn.easypoi.cache.PdfCache;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.MyDocument;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfTemplateServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfTemplateServer.class);
    private MyDocument document;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parsePdf(String url, Map<String, Object> map, OutputStream outStream) {
        PdfDocument outDocument = null;
        try {
            PdfReader pdfReader = PdfCache.getDocument(url);
            PdfWriter pdfWriter = new PdfWriter(outStream);
            outDocument = new PdfDocument(pdfReader, pdfWriter);
            this.document = new MyDocument(outDocument);
            this.replaceDocument(outDocument, map);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.document.close();
            outDocument.close();
        }
        return this.document;
    }

    public void replaceDocument(PdfDocument redDocument, Map<String, Object> map) {
        int numberOfPages = redDocument.getNumberOfPages();
        for (int i = 1; i <= numberOfPages; ++i) {
            PdfDictionary dict = (PdfDictionary)redDocument.getPage(i).getPdfObject();
            PdfObject object = dict.get(PdfName.Contents);
            if (!(object instanceof PdfStream)) continue;
            PdfStream stream = (PdfStream)object;
            byte[] data = stream.getBytes();
            String replacedData = new String(data).replace("testCode", "\u5c0f\u660e");
            stream.setData(replacedData.getBytes(StandardCharsets.UTF_8));
        }
    }
}

