/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

@Schema(description="Alarm Report Content Entity")
public class AlertReport {
    @Schema(title="Alert record saas index ID")
    private String alertId;
    @Schema(title="Alert Name")
    private String alertName;
    @Schema(title="Alarm evaluation interval")
    private Integer alertDuration;
    @Schema(title="Time when the log service receives the alarm message", description="Time when the log service receives the alarm message", example="1694589491000", accessMode=Schema.AccessMode.READ_WRITE)
    private long alertTime;
    @Schema(title="Alarm priority. 0: high emergency alarm red 1: medium critical serious alarm Orange 2: low warning warning alarm yellow", description="Alarm priority. 0: high emergency alarm red 1: medium critical serious alarm Orange 2: low warning warning alarm yellow", example="1", accessMode=Schema.AccessMode.READ_WRITE)
    private Integer priority;
    @Schema(title="Alarm type. 0: the default 1 is business system exception reporting", description="Alarm type. 0: the default 1 is business system exception reporting", example="0", accessMode=Schema.AccessMode.READ_WRITE)
    private Integer reportType;
    @Schema(title="Alarm tag information", description="Alarm label information((monitorId:xxx,monitorName:xxx))", example="{\"key1\":\"value1\"}", accessMode=Schema.AccessMode.READ_WRITE)
    private Map<String, String> labels;
    @Schema(title=" Alarm marking (monitorId:xxx,monitorName:xxx)", description="Alarm labeling", example="{\"key1\":\"value1\"}", accessMode=Schema.AccessMode.READ_WRITE)
    private Map<String, String> annotations;
    @Schema(title=" Alarm content", description="Content of alarm", example="External alarm content", accessMode=Schema.AccessMode.READ_WRITE)
    private String content;

    public static AlertReportBuilder builder() {
        return new AlertReportBuilder();
    }

    public String getAlertId() {
        return this.alertId;
    }

    public String getAlertName() {
        return this.alertName;
    }

    public Integer getAlertDuration() {
        return this.alertDuration;
    }

    public long getAlertTime() {
        return this.alertTime;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getReportType() {
        return this.reportType;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public String getContent() {
        return this.content;
    }

    public void setAlertId(String alertId) {
        this.alertId = alertId;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }

    public void setAlertDuration(Integer alertDuration) {
        this.alertDuration = alertDuration;
    }

    public void setAlertTime(long alertTime) {
        this.alertTime = alertTime;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertReport)) {
            return false;
        }
        AlertReport other = (AlertReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAlertTime() != other.getAlertTime()) {
            return false;
        }
        Integer this$alertDuration = this.getAlertDuration();
        Integer other$alertDuration = other.getAlertDuration();
        if (this$alertDuration == null ? other$alertDuration != null : !((Object)this$alertDuration).equals(other$alertDuration)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        Integer this$reportType = this.getReportType();
        Integer other$reportType = other.getReportType();
        if (this$reportType == null ? other$reportType != null : !((Object)this$reportType).equals(other$reportType)) {
            return false;
        }
        String this$alertId = this.getAlertId();
        String other$alertId = other.getAlertId();
        if (this$alertId == null ? other$alertId != null : !this$alertId.equals(other$alertId)) {
            return false;
        }
        String this$alertName = this.getAlertName();
        String other$alertName = other.getAlertName();
        if (this$alertName == null ? other$alertName != null : !this$alertName.equals(other$alertName)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $alertTime = this.getAlertTime();
        result = result * 59 + (int)($alertTime >>> 32 ^ $alertTime);
        Integer $alertDuration = this.getAlertDuration();
        result = result * 59 + ($alertDuration == null ? 43 : ((Object)$alertDuration).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        Integer $reportType = this.getReportType();
        result = result * 59 + ($reportType == null ? 43 : ((Object)$reportType).hashCode());
        String $alertId = this.getAlertId();
        result = result * 59 + ($alertId == null ? 43 : $alertId.hashCode());
        String $alertName = this.getAlertName();
        result = result * 59 + ($alertName == null ? 43 : $alertName.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "AlertReport(alertId=" + this.getAlertId() + ", alertName=" + this.getAlertName() + ", alertDuration=" + this.getAlertDuration() + ", alertTime=" + this.getAlertTime() + ", priority=" + this.getPriority() + ", reportType=" + this.getReportType() + ", labels=" + this.getLabels() + ", annotations=" + this.getAnnotations() + ", content=" + this.getContent() + ")";
    }

    public AlertReport(String alertId, String alertName, Integer alertDuration, long alertTime, Integer priority, Integer reportType, Map<String, String> labels, Map<String, String> annotations, String content) {
        this.alertId = alertId;
        this.alertName = alertName;
        this.alertDuration = alertDuration;
        this.alertTime = alertTime;
        this.priority = priority;
        this.reportType = reportType;
        this.labels = labels;
        this.annotations = annotations;
        this.content = content;
    }

    public AlertReport() {
    }

    public static class AlertReportBuilder {
        private String alertId;
        private String alertName;
        private Integer alertDuration;
        private long alertTime;
        private Integer priority;
        private Integer reportType;
        private Map<String, String> labels;
        private Map<String, String> annotations;
        private String content;

        AlertReportBuilder() {
        }

        public AlertReportBuilder alertId(String alertId) {
            this.alertId = alertId;
            return this;
        }

        public AlertReportBuilder alertName(String alertName) {
            this.alertName = alertName;
            return this;
        }

        public AlertReportBuilder alertDuration(Integer alertDuration) {
            this.alertDuration = alertDuration;
            return this;
        }

        public AlertReportBuilder alertTime(long alertTime) {
            this.alertTime = alertTime;
            return this;
        }

        public AlertReportBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public AlertReportBuilder reportType(Integer reportType) {
            this.reportType = reportType;
            return this;
        }

        public AlertReportBuilder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public AlertReportBuilder annotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public AlertReportBuilder content(String content) {
            this.content = content;
            return this;
        }

        public AlertReport build() {
            return new AlertReport(this.alertId, this.alertName, this.alertDuration, this.alertTime, this.priority, this.reportType, this.labels, this.annotations, this.content);
        }

        public String toString() {
            return "AlertReport.AlertReportBuilder(alertId=" + this.alertId + ", alertName=" + this.alertName + ", alertDuration=" + this.alertDuration + ", alertTime=" + this.alertTime + ", priority=" + this.priority + ", reportType=" + this.reportType + ", labels=" + this.labels + ", annotations=" + this.annotations + ", content=" + this.content + ")";
        }
    }
}

