/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import io.greptime.common.util.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class Files {
    public static void fsync(File file) throws IOException {
        boolean isDir = file.isDirectory();
        if (isDir && Platform.isWindows()) {
            return;
        }
        try (FileChannel fc = FileChannel.open(file.toPath(), isDir ? StandardOpenOption.READ : StandardOpenOption.WRITE);){
            fc.force(true);
        }
    }

    public static void mkdirIfNotExists(String path) throws IOException {
        File dir = Paths.get(path, new String[0]).toFile().getAbsoluteFile();
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException("File " + dir + " exists and is not a directory. Unable to create directory.");
            }
        } else if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("Unable to create directory " + dir);
        }
    }
}

