/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Edge;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.BaseDataObject;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Relationship
extends BaseDataObject {
    private final Edge edge;

    public Relationship(Edge edge) {
        if (edge == null) {
            throw new RuntimeException("Input an null edge object");
        }
        this.edge = edge;
    }

    public ValueWrapper srcId() {
        return this.edge.type > 0 ? new ValueWrapper(this.edge.src, this.getDecodeType(), this.getTimezoneOffset()) : new ValueWrapper(this.edge.dst, this.getDecodeType(), this.getTimezoneOffset());
    }

    public ValueWrapper dstId() {
        return this.edge.type > 0 ? new ValueWrapper(this.edge.dst, this.getDecodeType(), this.getTimezoneOffset()) : new ValueWrapper(this.edge.src, this.getDecodeType(), this.getTimezoneOffset());
    }

    public String edgeName() {
        return new String(this.edge.name);
    }

    public long ranking() {
        return this.edge.ranking;
    }

    public List<String> keys() throws UnsupportedEncodingException {
        ArrayList<String> propNames = new ArrayList<String>();
        for (byte[] name : this.edge.props.keySet()) {
            propNames.add(new String(name, this.getDecodeType()));
        }
        return propNames;
    }

    public List<ValueWrapper> values() {
        ArrayList<ValueWrapper> propVals = new ArrayList<ValueWrapper>();
        for (Value val : this.edge.props.values()) {
            propVals.add(new ValueWrapper(val, this.getDecodeType(), this.getTimezoneOffset()));
        }
        return propVals;
    }

    public HashMap<String, ValueWrapper> properties() throws UnsupportedEncodingException {
        HashMap<String, ValueWrapper> properties = new HashMap<String, ValueWrapper>();
        for (byte[] key : this.edge.props.keySet()) {
            properties.put(new String(key, this.getDecodeType()), new ValueWrapper(this.edge.props.get(key), this.getDecodeType(), this.getTimezoneOffset()));
        }
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relationship that = (Relationship)o;
        return this.ranking() == that.ranking() && Objects.equals(this.srcId(), that.srcId()) && Objects.equals(this.dstId(), that.dstId()) && Objects.equals(this.edgeName(), that.edgeName());
    }

    public int hashCode() {
        return Objects.hash(this.edge, this.getDecodeType(), this.getTimezoneOffset());
    }

    public String toString() {
        try {
            ArrayList<String> propStrs = new ArrayList<String>();
            HashMap<String, ValueWrapper> props = this.properties();
            for (String key : props.keySet()) {
                propStrs.add(key + ": " + ((ValueWrapper)props.get(key)).toString());
            }
            return String.format("(%s)-[:%s@%d{%s}]->(%s)", this.srcId(), this.edgeName(), this.ranking(), String.join((CharSequence)", ", propStrs), this.dstId());
        }
        catch (UnsupportedEncodingException e) {
            return e.getMessage();
        }
    }
}

