/*
 * Decompiled with CFR 0.152.
 */
package io.greptime;

import io.greptime.Status;
import io.greptime.common.Display;
import io.greptime.common.util.ExecutorServiceHelper;
import io.greptime.common.util.NamedThreadFactory;
import io.greptime.common.util.ObjectPool;
import io.greptime.common.util.SharedScheduledPool;
import io.greptime.common.util.SystemPropertyUtil;
import io.greptime.common.util.ThreadPoolUtil;
import io.greptime.models.Err;
import io.greptime.rpc.Observer;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Util {
    private static final AtomicBoolean RW_LOGGING = new AtomicBoolean(SystemPropertyUtil.getBool((String)"greptimedb.read.write.rw_logging", (boolean)false));
    private static final int REPORT_PERIOD_MIN = SystemPropertyUtil.getInt((String)"greptimedb.reporter.period_minutes", (int)30);
    private static final ScheduledExecutorService DISPLAY = ThreadPoolUtil.newScheduledBuilder().poolName("display_self").coreThreads(Integer.valueOf(1)).enableMetric(Boolean.valueOf(true)).threadFactory((ThreadFactory)new NamedThreadFactory("display_self", true)).rejectedHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy()).build();

    public static boolean isRwLogging() {
        return RW_LOGGING.get();
    }

    public static boolean resetRwLogging() {
        return RW_LOGGING.getAndSet(!RW_LOGGING.get());
    }

    public static int autoReportPeriodMin() {
        return REPORT_PERIOD_MIN;
    }

    public static void scheduleDisplaySelf(Display display, Display.Printer printer) {
        DISPLAY.scheduleWithFixedDelay(() -> display.display(printer), 0L, Util.autoReportPeriodMin(), TimeUnit.MINUTES);
    }

    public static SharedScheduledPool getSharedScheduledPool(final String name, final int workers) {
        return new SharedScheduledPool((ObjectPool.Resource)new ObjectPool.Resource<ScheduledExecutorService>(){

            public ScheduledExecutorService create() {
                return ThreadPoolUtil.newScheduledBuilder().poolName(name).coreThreads(Integer.valueOf(workers)).enableMetric(Boolean.valueOf(true)).threadFactory((ThreadFactory)new NamedThreadFactory(name, true)).rejectedHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy()).build();
            }

            public void close(ScheduledExecutorService instance) {
                ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)instance);
            }
        });
    }

    public static <U> CompletableFuture<U> completedCf(U value) {
        return CompletableFuture.completedFuture(value);
    }

    public static <U> CompletableFuture<U> errorCf(Throwable t) {
        CompletableFuture err = new CompletableFuture();
        err.completeExceptionally(t);
        return err;
    }

    public static <V> Observer<V> toObserver(final CompletableFuture<V> future) {
        return new Observer<V>(){

            public void onNext(V value) {
                future.complete(value);
            }

            public void onError(Throwable err) {
                future.completeExceptionally(err);
            }
        };
    }

    public static long randomInitialDelay(long delay) {
        return ThreadLocalRandom.current().nextLong(delay, delay << 1);
    }

    public static boolean shouldNotRetry(Err err) {
        return !Util.shouldRetry(err);
    }

    public static boolean shouldRetry(Err err) {
        if (err == null) {
            return false;
        }
        Status status = Status.parse(err.getCode());
        return status != null && status.isShouldRetry();
    }

    public static String clientVersion() {
        try {
            return Util.loadProps(Util.class.getClassLoader(), "client_version.properties").getProperty("client.version", "Unknown version");
        }
        catch (Exception ignored) {
            return "Unknown version(err)";
        }
    }

    public static Properties loadProps(ClassLoader loader, String name) throws IOException {
        Properties prop = new Properties();
        prop.load(loader.getResourceAsStream(name));
        return prop;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)DISPLAY)));
    }
}

