/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.jpa;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hertzbeat.common.entity.arrow.ArrowCell;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.entity.warehouse.History;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.TimePeriodUtil;
import org.apache.hertzbeat.warehouse.dao.HistoryDao;
import org.apache.hertzbeat.warehouse.store.history.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.jpa.JpaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="warehouse.store.jpa", name={"enabled"}, havingValue="true")
public class JpaDatabaseDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(JpaDatabaseDataStorage.class);
    private final HistoryDao historyDao;
    private final JpaProperties jpaProperties;
    private static final int STRING_MAX_LENGTH = 1024;

    public JpaDatabaseDataStorage(JpaProperties jpaProperties, HistoryDao historyDao) {
        this.jpaProperties = jpaProperties;
        this.serverAvailable = true;
        this.historyDao = historyDao;
        this.expiredDataCleaner();
    }

    public void expiredDataCleaner() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("Jpa metrics store has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("jpa-metrics-cleaner-%d").build();
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        scheduledExecutor.scheduleAtFixedRate(() -> {
            ZonedDateTime dateTime;
            long expireTime;
            log.warn("[jpa-metrics-store]-start running expired data cleaner.Please use time series db instead of jpa for better performance");
            String expireTimeStr = this.jpaProperties.expireTime();
            try {
                if (NumberUtils.isParsable((String)expireTimeStr)) {
                    expireTime = NumberUtils.toLong((String)expireTimeStr);
                    expireTime = (ZonedDateTime.now().toEpochSecond() + expireTime) * 1000L;
                } else {
                    TemporalAmount temporalAmount = TimePeriodUtil.parseTokenTime((String)expireTimeStr);
                    dateTime = ZonedDateTime.now().minus(temporalAmount);
                    expireTime = dateTime.toEpochSecond() * 1000L;
                }
            }
            catch (Exception e) {
                log.error("expiredDataCleaner time error: {}. use default expire time to clean: 1h", (Object)e.getMessage());
                dateTime = ZonedDateTime.now().minus(Duration.ofHours(1L));
                expireTime = dateTime.toEpochSecond() * 1000L;
            }
            try {
                int rows = this.historyDao.deleteHistoriesByTimeBefore(expireTime);
                log.info("[jpa-metrics-store]-delete {} rows.", (Object)rows);
                long total = this.historyDao.count();
                if (total > (long)this.jpaProperties.maxHistoryRecordNum().intValue()) {
                    rows = this.historyDao.deleteOlderHistoriesRecord(this.jpaProperties.maxHistoryRecordNum() / 2);
                    log.warn("[jpa-metrics-store]-force delete {} rows due too many. Please use time series db instead of jpa for better performance.", (Object)rows);
                }
            }
            catch (Exception e) {
                log.error("expiredDataCleaner database error: {}.", (Object)e.getMessage());
                log.error("try to truncate table hzb_history. Please use time series db instead of jpa for better performance.");
                this.historyDao.truncateTable();
            }
        }, 5L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        if (metricsData.getCode() != CollectRep.Code.SUCCESS) {
            return;
        }
        if (metricsData.getValues().isEmpty()) {
            log.info("[warehouse jpa] flush metrics data {} is null, ignore.", (Object)metricsData.getId());
            return;
        }
        String monitorType = metricsData.getApp();
        String metrics = metricsData.getMetrics();
        try {
            ArrayList allHistoryList = Lists.newArrayList();
            HashMap labels = Maps.newHashMapWithExpectedSize((int)8);
            RowWrapper rowWrapper = metricsData.readRow();
            while (rowWrapper.hasNextRow()) {
                rowWrapper = rowWrapper.nextRow();
                ArrayList singleHistoryList = new ArrayList();
                rowWrapper.cellStream().forEach(cell -> singleHistoryList.add(this.buildHistory(metricsData, (ArrowCell)cell, monitorType, metrics, labels)));
                singleHistoryList.forEach(history -> history.setInstance(JsonUtil.toJson((Object)labels)));
                allHistoryList.addAll(singleHistoryList);
            }
            this.historyDao.saveAll(allHistoryList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private History buildHistory(CollectRep.MetricsData metricsData, ArrowCell cell, String monitorType, String metrics, Map<String, String> labels) {
        History.HistoryBuilder historyBuilder = History.builder().monitorId(Long.valueOf(metricsData.getId())).app(monitorType).metrics(metrics).time(Long.valueOf(metricsData.getTime())).metric(cell.getField().getName());
        String columnValue = cell.getValue();
        int fieldType = cell.getMetadataAsInteger("type");
        if ("&nbsp;".equals(columnValue)) {
            switch (fieldType) {
                case 0: {
                    historyBuilder.metricType(Byte.valueOf((byte)0)).dou(null);
                    break;
                }
                case 1: {
                    historyBuilder.metricType(Byte.valueOf((byte)1)).str(null);
                    break;
                }
                case 3: {
                    historyBuilder.metricType(Byte.valueOf((byte)3)).int32(null);
                    break;
                }
                default: {
                    historyBuilder.metricType(Byte.valueOf((byte)0));
                    break;
                }
            }
        } else {
            switch (fieldType) {
                case 1: {
                    historyBuilder.metricType(Byte.valueOf((byte)1)).str(this.formatStrValue(columnValue));
                    break;
                }
                case 3: {
                    historyBuilder.metricType(Byte.valueOf((byte)3)).int32(Integer.valueOf(Integer.parseInt(columnValue)));
                    break;
                }
                default: {
                    historyBuilder.metricType(Byte.valueOf((byte)0)).dou(Double.valueOf(Double.parseDouble(columnValue)));
                }
            }
            if (cell.getMetadataAsBoolean("label").booleanValue()) {
                labels.put(cell.getField().getName(), columnValue);
            }
        }
        return historyBuilder.build();
    }

    @Override
    public Map<String, List<Value>> getHistoryMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(8);
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            Predicate predicateMonitorId = criteriaBuilder.equal((Expression)root.get("monitorId"), (Object)monitorId);
            Predicate predicateMonitorType = criteriaBuilder.equal((Expression)root.get("app"), (Object)app);
            if ("prometheus".equals(app)) {
                predicateMonitorType = criteriaBuilder.like((Expression)root.get("app"), "_prometheus_%");
            }
            Predicate predicateMonitorMetrics = criteriaBuilder.equal((Expression)root.get("metrics"), (Object)metrics);
            Predicate predicateMonitorMetric = criteriaBuilder.equal((Expression)root.get("metric"), (Object)metric);
            andList.add(predicateMonitorId);
            andList.add(predicateMonitorType);
            andList.add(predicateMonitorMetrics);
            andList.add(predicateMonitorMetric);
            if (StringUtils.isNotBlank((CharSequence)label)) {
                Predicate predicateMonitorInstance = criteriaBuilder.equal((Expression)root.get("instance"), (Object)label);
                andList.add(predicateMonitorInstance);
            }
            if (history != null) {
                try {
                    TemporalAmount temporalAmount = TimePeriodUtil.parseTokenTime((String)history);
                    ZonedDateTime dateTime = ZonedDateTime.now().minus(temporalAmount);
                    long timeBefore = dateTime.toEpochSecond() * 1000L;
                    Predicate timePredicate = criteriaBuilder.ge((Expression)root.get("time"), (Number)timeBefore);
                    andList.add(timePredicate);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
            Predicate[] predicates = new Predicate[andList.size()];
            Predicate predicate = criteriaBuilder.and(andList.toArray(predicates));
            return query.where((Expression)predicate).getRestriction();
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "time")});
        List historyList = this.historyDao.findAll(specification, sortExp);
        for (History dataItem : historyList) {
            String value = "";
            if (dataItem.getMetricType() == 0) {
                if (dataItem.getDou() != null) {
                    value = BigDecimal.valueOf(dataItem.getDou()).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                }
            } else {
                value = dataItem.getStr();
            }
            String instanceValue = dataItem.getInstance() == null ? "" : dataItem.getInstance();
            List valueList = instanceValuesMap.computeIfAbsent(instanceValue, k -> new LinkedList());
            valueList.add(new Value(value, dataItem.getTime().longValue()));
        }
        return instanceValuesMap;
    }

    private String formatStrValue(String value) {
        if (value == null) {
            return "";
        }
        value = value.replace("'", "\\'");
        value = value.replace("\"", "\\\"");
        value = value.replace("*", "-");
        if ((value = String.format("`%s`", value)).length() > 1024) {
            value = value.substring(0, 1023);
        }
        return value;
    }

    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        return new HashMap<String, List<Value>>(8);
    }

    public void destroy() throws Exception {
    }
}

