/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.common.cache;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hertzbeat.collector.collect.common.cache.AbstractConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalConnectionCache {
    private static final Logger log = LoggerFactory.getLogger(GlobalConnectionCache.class);
    private static final long DEFAULT_CACHE_TIMEOUT = 600000L;
    private static final int CACHE_TIME_LENGTH = 2;
    private final Map<Object, Long[]> timeoutMap = new ConcurrentHashMap<Object, Long[]>(32);
    private final ConcurrentLinkedHashMap<Object, AbstractConnection<?>> cacheMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Integer.MAX_VALUE).listener((key, value) -> {
        this.timeoutMap.remove(key);
        try {
            value.close();
        }
        catch (Exception e) {
            log.error("Connection close error for key {}: {}", new Object[]{key, e.getMessage(), e});
        }
        log.info("GlobalConnectionCache discarded key: {}, value: {}.", key, value);
    }).build();

    private GlobalConnectionCache() {
        this.initCacheMonitor();
    }

    public static GlobalConnectionCache getInstance() {
        return Holder.INSTANCE;
    }

    private void initCacheMonitor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("connection-cache-timeout-detector-%d").setDaemon(true).build();
        ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1, threadFactory);
        scheduledExecutor.scheduleWithFixedDelay(this::cleanTimeoutOrUnHealthyCache, 2L, 100L, TimeUnit.SECONDS);
    }

    private void cleanTimeoutOrUnHealthyCache() {
        try {
            this.cacheMap.forEach((key, value) -> {
                Long[] cacheTime = this.timeoutMap.get(key);
                long currentTime = System.currentTimeMillis();
                if (cacheTime == null || cacheTime.length != 2 || cacheTime[0] + cacheTime[1] < currentTime) {
                    log.warn("[GlobalConnectionCache] Cleaning timeout cache, key {}", key);
                    this.timeoutMap.remove(key);
                    this.cacheMap.remove(key);
                    try {
                        value.close();
                    }
                    catch (Exception e) {
                        log.error("Clean connection close error for key {}: {}", new Object[]{key, e.getMessage(), e});
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("[GlobalConnectionCache] Error cleaning timeout cache: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void addCache(Object key, AbstractConnection<?> value, Long timeDiff) {
        this.removeCache(key);
        if (timeDiff == null) {
            timeDiff = 600000L;
        }
        this.cacheMap.put(key, value);
        this.timeoutMap.put(key, new Long[]{System.currentTimeMillis(), timeDiff});
    }

    public void addCache(Object key, AbstractConnection<?> value) {
        this.addCache(key, value, 600000L);
    }

    public Optional<AbstractConnection<?>> getCache(Object key, boolean refreshCache) {
        Long[] cacheTime = this.timeoutMap.get(key);
        if (cacheTime == null || cacheTime.length != 2) {
            log.info("[GlobalConnectionCache] Cache miss for key {}.", key);
            this.removeCache(key);
            return Optional.empty();
        }
        if (cacheTime[0] + cacheTime[1] < System.currentTimeMillis()) {
            log.warn("[GlobalConnectionCache] Cache entry expired for key {}.", key);
            this.removeCache(key);
            return Optional.empty();
        }
        AbstractConnection value = (AbstractConnection)this.cacheMap.compute(key, (k, v) -> {
            if (v == null) {
                log.error("[GlobalConnectionCache] Value is null, removing key {}.", key);
                this.timeoutMap.remove(key);
                return null;
            }
            if (refreshCache) {
                cacheTime[0] = System.currentTimeMillis();
                this.timeoutMap.put(key, cacheTime);
            }
            return v;
        });
        return Optional.ofNullable(value);
    }

    public void removeCache(Object key) {
        this.timeoutMap.remove(key);
        AbstractConnection value = (AbstractConnection)this.cacheMap.remove(key);
        try {
            if (value != null) {
                value.close();
            }
        }
        catch (Exception e) {
            log.error("Connection close error for key {}: {}", new Object[]{key, e.getMessage(), e});
        }
    }

    private static class Holder {
        private static final GlobalConnectionCache INSTANCE = new GlobalConnectionCache();

        private Holder() {
        }
    }
}

