/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.reduce;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hertzbeat.alert.AlerterProperties;
import org.apache.hertzbeat.alert.dao.AlertInhibitDao;
import org.apache.hertzbeat.alert.reduce.AlarmSilenceReduce;
import org.apache.hertzbeat.common.entity.alerter.AlertInhibit;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlarmInhibitReduce {
    private static final Logger log = LoggerFactory.getLogger(AlarmInhibitReduce.class);
    private static final long CHECK_INTERVAL = 60000L;
    private final AlarmSilenceReduce alarmSilenceReduce;
    private final Map<Long, AlertInhibit> inhibitRules;
    private final Map<Long, Map<String, SourceAlertEntry>> sourceAlertCache;
    private static long SOURCE_ALERT_TTL = 14400000L;

    public AlarmInhibitReduce(AlarmSilenceReduce alarmSilenceReduce, AlertInhibitDao alertInhibitDao, AlerterProperties alerterProperties) {
        this.alarmSilenceReduce = alarmSilenceReduce;
        if (alerterProperties.getInhibit() != null && alerterProperties.getInhibit().getTtl() > 0L) {
            SOURCE_ALERT_TTL = alerterProperties.getInhibit().getTtl();
        }
        this.inhibitRules = new ConcurrentHashMap<Long, AlertInhibit>(8);
        this.sourceAlertCache = new ConcurrentHashMap<Long, Map<String, SourceAlertEntry>>(8);
        List<AlertInhibit> inhibits = alertInhibitDao.findAlertInhibitsByEnableIsTrue();
        this.refreshInhibitRules(inhibits);
        this.startScheduledCleanupCache();
    }

    private void startScheduledCleanupCache() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("Scheduled clean up inhibit cache has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("inhibit-clean-up-%d").build();
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        scheduledExecutor.scheduleAtFixedRate(() -> {
            try {
                this.sourceAlertCache.values().forEach(this::cleanupExpiredEntries);
                this.sourceAlertCache.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
            }
            catch (Exception e) {
                log.error("Error during scheduled cleanup", (Throwable)e);
            }
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public void refreshInhibitRules(List<AlertInhibit> rules) {
        if (rules == null) {
            log.warn("Attempted to refresh inhibit rules with null list.");
            return;
        }
        this.inhibitRules.clear();
        rules.forEach(rule -> this.inhibitRules.put(rule.getId(), (AlertInhibit)rule));
    }

    public void inhibitAlarm(GroupAlert groupAlert) {
        if (groupAlert == null) {
            log.warn("Received null GroupAlert. Skipping processing.");
            return;
        }
        try {
            if (this.inhibitRules.isEmpty()) {
                this.alarmSilenceReduce.silenceAlarm(groupAlert);
                return;
            }
            for (SingleAlert alert : groupAlert.getAlerts()) {
                for (AlertInhibit rule : this.inhibitRules.values()) {
                    if (!this.isSourceAlert(alert, rule)) continue;
                    this.cacheSourceAlert(alert, rule);
                }
            }
            groupAlert.getAlerts().removeIf(this::shouldInhibit);
            if (!groupAlert.getAlerts().isEmpty()) {
                this.alarmSilenceReduce.silenceAlarm(groupAlert);
            }
        }
        catch (Exception e) {
            log.error("Error inhibiting alarm for {}", (Object)groupAlert, (Object)e);
        }
    }

    private boolean isSourceAlert(SingleAlert alert, AlertInhibit rule) {
        if (alert == null || rule == null) {
            log.warn("Received null alert or rule in isSourceAlert");
            return false;
        }
        if (!"firing".equals(alert.getStatus())) {
            return false;
        }
        return this.matchLabels(alert.getLabels(), rule.getSourceLabels());
    }

    private boolean shouldInhibit(SingleAlert alert) {
        if (alert == null) {
            log.warn("Received null alert in shouldInhibit");
            return false;
        }
        if ("resolved".equals(alert.getStatus())) {
            return false;
        }
        for (AlertInhibit rule : this.inhibitRules.values()) {
            List<SingleAlert> sourceAlerts;
            if (!this.matchLabels(alert.getLabels(), rule.getTargetLabels()) || (sourceAlerts = this.getActiveSourceAlerts(rule)).isEmpty()) continue;
            for (SingleAlert source : sourceAlerts) {
                if (!this.matchEqualLabels(source, alert, rule.getEqualLabels())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchLabels(Map<String, String> alertLabels, Map<String, String> requiredLabels) {
        if (alertLabels == null || requiredLabels == null) {
            log.warn("Received null alertLabels or requiredLabels in matchLabels");
            return false;
        }
        return requiredLabels.entrySet().stream().allMatch(entry -> ((String)entry.getValue()).equals(alertLabels.get(entry.getKey())));
    }

    private boolean matchEqualLabels(SingleAlert source, SingleAlert target, List<String> equalLabels) {
        if (source == null || target == null) {
            log.warn("Received null source or target in matchEqualLabels");
            return false;
        }
        if (equalLabels == null || equalLabels.isEmpty()) {
            return true;
        }
        Map sourceLabels = source.getLabels();
        Map targetLabels = target.getLabels();
        return equalLabels.stream().allMatch(label -> {
            String sourceValue = (String)sourceLabels.get(label);
            String targetValue = (String)targetLabels.get(label);
            return sourceValue != null && sourceValue.equals(targetValue);
        });
    }

    private void cacheSourceAlert(SingleAlert alert, AlertInhibit rule) {
        if (alert == null || rule == null) {
            log.warn("Received null alert or rule in cacheSourceAlert");
            return;
        }
        Map ruleCache = this.sourceAlertCache.computeIfAbsent(rule.getId(), k -> new ConcurrentHashMap());
        SourceAlertEntry entry = new SourceAlertEntry(alert, System.currentTimeMillis(), System.currentTimeMillis() + SOURCE_ALERT_TTL);
        ruleCache.put(alert.getFingerprint(), entry);
        this.cleanupExpiredEntries(ruleCache);
    }

    private List<SingleAlert> getActiveSourceAlerts(AlertInhibit rule) {
        if (rule == null) {
            log.warn("Received null rule in getActiveSourceAlerts");
            return Collections.emptyList();
        }
        Map<String, SourceAlertEntry> ruleCache = this.sourceAlertCache.get(rule.getId());
        if (ruleCache == null || ruleCache.isEmpty()) {
            return Collections.emptyList();
        }
        long now = System.currentTimeMillis();
        return ruleCache.values().stream().filter(entry -> entry.getExpiryTime() > now).map(SourceAlertEntry::getAlert).collect(Collectors.toList());
    }

    private void cleanupExpiredEntries(Map<String, SourceAlertEntry> cache) {
        if (cache == null) {
            log.warn("Received null cache in cleanupExpiredEntries");
            return;
        }
        long now = System.currentTimeMillis();
        cache.entrySet().removeIf(entry -> ((SourceAlertEntry)entry.getValue()).getExpiryTime() <= now);
    }

    private static class SourceAlertEntry {
        private final SingleAlert alert;
        private final long createTime;
        private final long expiryTime;

        public SingleAlert getAlert() {
            return this.alert;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public long getExpiryTime() {
            return this.expiryTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceAlertEntry)) {
                return false;
            }
            SourceAlertEntry other = (SourceAlertEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCreateTime() != other.getCreateTime()) {
                return false;
            }
            if (this.getExpiryTime() != other.getExpiryTime()) {
                return false;
            }
            SingleAlert this$alert = this.getAlert();
            SingleAlert other$alert = other.getAlert();
            return !(this$alert == null ? other$alert != null : !this$alert.equals(other$alert));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SourceAlertEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $createTime = this.getCreateTime();
            result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
            long $expiryTime = this.getExpiryTime();
            result = result * 59 + (int)($expiryTime >>> 32 ^ $expiryTime);
            SingleAlert $alert = this.getAlert();
            result = result * 59 + ($alert == null ? 43 : $alert.hashCode());
            return result;
        }

        public String toString() {
            return "AlarmInhibitReduce.SourceAlertEntry(alert=" + this.getAlert() + ", createTime=" + this.getCreateTime() + ", expiryTime=" + this.getExpiryTime() + ")";
        }

        public SourceAlertEntry(SingleAlert alert, long createTime, long expiryTime) {
            this.alert = alert;
            this.createTime = createTime;
            this.expiryTime = expiryTime;
        }
    }
}

