/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.AlerterWorkerPool;
import org.apache.hertzbeat.alert.calculate.AlarmCacheManager;
import org.apache.hertzbeat.alert.dao.SingleAlertDao;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.AlertDefineService;
import org.apache.hertzbeat.alert.util.AlertTemplateUtil;
import org.apache.hertzbeat.alert.util.AlertUtil;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.JexlExpressionRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RealTimeAlertCalculator {
    private static final Logger log = LoggerFactory.getLogger(RealTimeAlertCalculator.class);
    private static final int CALCULATE_THREADS = 3;
    private static final String KEY_INSTANCE = "__instance__";
    private static final String KEY_INSTANCE_NAME = "__instancename__";
    private static final String KEY_INSTANCE_HOST = "__instancehost__";
    private static final String KEY_APP = "__app__";
    private static final String KEY_METRICS = "__metrics__";
    private static final String KEY_PRIORITY = "__priority__";
    private static final String KEY_CODE = "__code__";
    private static final String KEY_AVAILABLE = "__available__";
    private static final String KEY_LABELS = "__labels__";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private static final String KEY_ROW = "__row__";
    private static final Pattern APP_PATTERN = Pattern.compile("equals\\(__app__,\"([^\"]+)\"\\)");
    private static final Pattern AVAILABLE_PATTERN = Pattern.compile("equals\\(__available__,\"([^\"]+)\"\\)");
    private static final Pattern LABEL_PATTERN = Pattern.compile("contains\\(__labels__,\\s*\"([^\"]+)\"\\)");
    private static final Pattern INSTANCE_PATTERN = Pattern.compile("equals\\(__instance__,\\s*\"(\\d+)\"\\)");
    private static final Pattern METRICS_PATTERN = Pattern.compile("equals\\(__metrics__,\"([^\"]+)\"\\)");
    private final AlerterWorkerPool workerPool;
    private final CommonDataQueue dataQueue;
    private final AlertDefineService alertDefineService;
    private final AlarmCommonReduce alarmCommonReduce;
    private final AlarmCacheManager alarmCacheManager;

    @Autowired
    public RealTimeAlertCalculator(AlerterWorkerPool workerPool, CommonDataQueue dataQueue, AlertDefineService alertDefineService, SingleAlertDao singleAlertDao, AlarmCommonReduce alarmCommonReduce, AlarmCacheManager alarmCacheManager) {
        this(workerPool, dataQueue, alertDefineService, singleAlertDao, alarmCommonReduce, alarmCacheManager, true);
    }

    public RealTimeAlertCalculator(AlerterWorkerPool workerPool, CommonDataQueue dataQueue, AlertDefineService alertDefineService, SingleAlertDao singleAlertDao, AlarmCommonReduce alarmCommonReduce, AlarmCacheManager alarmCacheManager, boolean start) {
        this.workerPool = workerPool;
        this.dataQueue = dataQueue;
        this.alarmCommonReduce = alarmCommonReduce;
        this.alertDefineService = alertDefineService;
        this.alarmCacheManager = alarmCacheManager;
        if (start) {
            this.startCalculate();
        }
    }

    public void startCalculate() {
        Runnable runnable = () -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CollectRep.MetricsData metricsData = this.dataQueue.pollMetricsDataToAlerter();
                    this.calculate(metricsData);
                    this.dataQueue.sendMetricsDataToStorage(metricsData);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.error("calculate alarm error: {}.", (Object)e.getMessage(), (Object)e);
                }
            }
        };
        for (int i = 0; i < 3; ++i) {
            this.workerPool.executeJob(runnable);
        }
    }

    private void calculate(CollectRep.MetricsData metricsData) {
        long currentTimeMilli = System.currentTimeMillis();
        String instance = String.valueOf(metricsData.getId());
        String instanceName = metricsData.getInstanceName();
        String instanceHost = metricsData.getInstanceHost();
        String app = metricsData.getApp();
        String metrics = metricsData.getMetrics();
        int priority = metricsData.getPriority();
        int code = metricsData.getCode().getNumber();
        Map labels = metricsData.getLabels();
        Map annotations = metricsData.getAnnotations();
        List<AlertDefine> thresholds = this.alertDefineService.getRealTimeAlertDefines();
        if ((thresholds = this.filterThresholdsByAppAndMetrics(thresholds, app, metrics, labels, instance, priority)).isEmpty()) {
            return;
        }
        HashMap<String, Object> commonContext = new HashMap<String, Object>(8);
        commonContext.put(KEY_INSTANCE, instance);
        commonContext.put(KEY_INSTANCE_NAME, instanceName);
        commonContext.put(KEY_INSTANCE_HOST, instanceHost);
        commonContext.put(KEY_APP, app);
        commonContext.put(KEY_PRIORITY, priority);
        commonContext.put(KEY_CODE, code);
        commonContext.put(KEY_METRICS, metrics);
        commonContext.put(KEY_LABELS, String.join((CharSequence)",", this.kvLabelsToKvStringSet(labels)));
        if (priority == 0) {
            commonContext.put(KEY_AVAILABLE, metricsData.getCode() == CollectRep.Code.SUCCESS ? UP : DOWN);
        }
        if (labels != null) {
            commonContext.putAll(labels);
        }
        List fields = metricsData.getFields();
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(8);
        int valueRowCount = metricsData.getValuesCount();
        for (AlertDefine define : thresholds) {
            if (define.getLabels() == null) {
                define.setLabels(new HashMap(8));
            }
            if (define.getAnnotations() == null) {
                define.setAnnotations(new HashMap(8));
            }
            fieldValueMap.clear();
            fieldValueMap.putAll(commonContext);
            String expr = define.getExpr();
            if (StringUtils.isBlank((CharSequence)expr)) continue;
            HashMap<String, String> commonFingerPrints = new HashMap<String, String>(8);
            commonFingerPrints.put("instance", instance);
            commonFingerPrints.put("alertname", define.getName());
            commonFingerPrints.put("instancename", instanceName);
            commonFingerPrints.put("instancehost", instanceHost);
            commonFingerPrints.putAll(define.getLabels());
            if (labels != null) {
                commonFingerPrints.putAll(labels);
            }
            try {
                boolean match = this.execAlertExpression(fieldValueMap, expr, true);
                try {
                    if (match) {
                        this.afterThresholdRuleMatch(currentTimeMilli, commonFingerPrints, fieldValueMap, define, annotations);
                        continue;
                    }
                    this.handleRecoveredAlert(commonFingerPrints);
                    continue;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception match) {
                // empty catch block
            }
            HashMap<String, String> fingerPrints = new HashMap<String, String>(8);
            for (CollectRep.ValueRow valueRow : metricsData.getValues()) {
                if (CollectionUtils.isEmpty((Collection)valueRow.getColumnsList())) continue;
                fieldValueMap.clear();
                fieldValueMap.put(KEY_ROW, valueRowCount);
                fieldValueMap.putAll(commonContext);
                fingerPrints.clear();
                fingerPrints.putAll(commonFingerPrints);
                for (int index = 0; index < valueRow.getColumnsList().size(); ++index) {
                    String valueStr = valueRow.getColumns(index);
                    CollectRep.Field field = (CollectRep.Field)fields.get(index);
                    if ("&nbsp;".equals(valueStr)) {
                        fieldValueMap.put(field.getName(), null);
                        continue;
                    }
                    int fieldType = field.getType();
                    if (fieldType == 0) {
                        Double doubleValue = CommonUtil.parseStrDouble((String)valueStr);
                        if (doubleValue != null) {
                            fieldValueMap.put(field.getName(), doubleValue);
                        }
                    } else if (fieldType == 3) {
                        Integer integerValue = CommonUtil.parseStrInteger((String)valueStr);
                        if (integerValue != null) {
                            fieldValueMap.put(field.getName(), integerValue);
                        }
                    } else if (StringUtils.isNotEmpty((CharSequence)valueStr)) {
                        fieldValueMap.put(field.getName(), valueStr);
                    }
                    if (!field.getLabel()) continue;
                    fingerPrints.put(field.getName(), valueStr);
                }
                try {
                    boolean match = this.execAlertExpression(fieldValueMap, expr, false);
                    try {
                        if (match) {
                            this.afterThresholdRuleMatch(currentTimeMilli, fingerPrints, fieldValueMap, define, annotations);
                            continue;
                        }
                        this.handleRecoveredAlert(fingerPrints);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public List<AlertDefine> filterThresholdsByAppAndMetrics(List<AlertDefine> thresholds, String app, String metrics, Map<String, String> labels, String instance, int priority) {
        return thresholds.stream().filter(define -> {
            Matcher availableMatcher;
            if (StringUtils.isBlank((CharSequence)define.getExpr())) {
                return false;
            }
            String expr = define.getExpr();
            Matcher appMatcher = APP_PATTERN.matcher(expr);
            if (!appMatcher.find() || !app.equals(appMatcher.group(1))) {
                return false;
            }
            if (priority != 0 && (availableMatcher = AVAILABLE_PATTERN.matcher(expr)).find()) {
                return false;
            }
            Matcher metricsMatcher = METRICS_PATTERN.matcher(expr);
            if (metricsMatcher.find() && !metrics.equals(metricsMatcher.group(1))) {
                return false;
            }
            Matcher instanceMatcher = INSTANCE_PATTERN.matcher(expr);
            Matcher labelMatcher = LABEL_PATTERN.matcher(expr);
            if (!instanceMatcher.find() && !labelMatcher.find()) {
                return true;
            }
            instanceMatcher.reset();
            labelMatcher.reset();
            while (instanceMatcher.find()) {
                if (!Objects.equals(instance, instanceMatcher.group(1))) continue;
                return true;
            }
            Set<String> labelKvStringSet = this.kvLabelsToKvStringSet(labels);
            while (labelMatcher.find()) {
                String label = labelMatcher.group(1);
                if (!labelKvStringSet.contains(label)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private void handleRecoveredAlert(Map<String, String> fingerprints) {
        String fingerprint = AlertUtil.calculateFingerprint(fingerprints);
        SingleAlert firingAlert = this.alarmCacheManager.removeFiring(fingerprint);
        if (firingAlert != null) {
            firingAlert.setTriggerTimes(Integer.valueOf(1));
            firingAlert.setEndAt(Long.valueOf(System.currentTimeMillis()));
            firingAlert.setStatus("resolved");
            this.alarmCommonReduce.reduceAndSendAlarm(firingAlert.clone());
        }
        this.alarmCacheManager.removePending(fingerprint);
    }

    private void afterThresholdRuleMatch(long currentTimeMilli, Map<String, String> fingerPrints, Map<String, Object> fieldValueMap, AlertDefine define, Map<String, String> annotations) {
        int requiredTimes;
        String fingerprint = AlertUtil.calculateFingerprint(fingerPrints);
        SingleAlert existingAlert = this.alarmCacheManager.getPending(fingerprint);
        fieldValueMap.putAll(define.getLabels());
        int n = requiredTimes = define.getTimes() == null ? 1 : define.getTimes();
        if (existingAlert == null) {
            HashMap<String, String> alertLabels = new HashMap<String, String>(8);
            alertLabels.putAll(fingerPrints);
            HashMap<String, String> alertAnnotations = new HashMap<String, String>(8);
            if (annotations != null) {
                alertAnnotations.putAll(annotations);
            }
            if (define.getAnnotations() != null) {
                alertAnnotations.putAll(define.getAnnotations());
            }
            for (Map.Entry entry : alertAnnotations.entrySet()) {
                entry.setValue(AlertTemplateUtil.render((String)entry.getValue(), fieldValueMap));
            }
            SingleAlert newAlert = SingleAlert.builder().labels(alertLabels).annotations(alertAnnotations).content(AlertTemplateUtil.render(define.getTemplate(), fieldValueMap)).status("pending").triggerTimes(Integer.valueOf(1)).startAt(Long.valueOf(currentTimeMilli)).activeAt(Long.valueOf(currentTimeMilli)).build();
            if (requiredTimes <= 1) {
                newAlert.setStatus("firing");
                this.alarmCacheManager.putFiring(fingerprint, newAlert);
                this.alarmCommonReduce.reduceAndSendAlarm(newAlert.clone());
            } else {
                this.alarmCacheManager.putPending(fingerprint, newAlert);
            }
        } else {
            existingAlert.setTriggerTimes(Integer.valueOf(existingAlert.getTriggerTimes() + 1));
            existingAlert.setActiveAt(Long.valueOf(currentTimeMilli));
            if (existingAlert.getStatus().equals("pending") && existingAlert.getTriggerTimes() >= requiredTimes) {
                this.alarmCacheManager.removePending(fingerprint);
                existingAlert.setStatus("firing");
                this.alarmCacheManager.putFiring(fingerprint, existingAlert);
                this.alarmCommonReduce.reduceAndSendAlarm(existingAlert.clone());
            }
        }
    }

    private boolean execAlertExpression(Map<String, Object> fieldValueMap, String expr, boolean ignoreJexlException) {
        Boolean match;
        JexlExpression expression;
        try {
            expression = JexlExpressionRunner.compile((String)expr);
        }
        catch (JexlException jexlException) {
            log.warn("Alarm Rule: {} Compile Error: {}.", (Object)expr, (Object)jexlException.getMessage());
            throw jexlException;
        }
        catch (Exception e) {
            log.error("Alarm Rule: {} Unknown Error: {}.", (Object)expr, (Object)e.getMessage());
            throw e;
        }
        try {
            match = (Boolean)JexlExpressionRunner.evaluate((JexlExpression)expression, fieldValueMap);
        }
        catch (JexlException jexlException) {
            if (ignoreJexlException) {
                log.debug("Alarm Rule: {} Run Error: {}.", (Object)expr, (Object)jexlException.getMessage());
            } else {
                log.error("Alarm Rule: {} Run Error: {}.", (Object)expr, (Object)jexlException.getMessage());
            }
            throw jexlException;
        }
        catch (Exception e) {
            log.error("Alarm Rule: {} Unknown Error: {}.", (Object)expr, (Object)e.getMessage());
            throw e;
        }
        return match != null && match != false;
    }

    private Set<String> kvLabelsToKvStringSet(Map<String, String> labels) {
        if (labels == null || labels.isEmpty()) {
            return Collections.singleton("");
        }
        return labels.entrySet().stream().map(item -> (String)item.getKey() + ":" + (String)item.getValue()).collect(Collectors.toSet());
    }
}

