/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.v2_6;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.api.internal.Timer;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContextUtil;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaHeadersSetter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProcessRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProducerRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaReceiveRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaUtil;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.MetricsReporterList;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.OpenTelemetryMetricsReporter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.OpenTelemetrySupplier;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.TracingList;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.KafkaTelemetryBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;

public final class KafkaTelemetry {
    private static final Logger logger = Logger.getLogger(KafkaTelemetry.class.getName());
    private static final TextMapSetter<Headers> SETTER = KafkaHeadersSetter.INSTANCE;
    private final OpenTelemetry openTelemetry;
    private final Instrumenter<KafkaProducerRequest, RecordMetadata> producerInstrumenter;
    private final Instrumenter<KafkaReceiveRequest, Void> consumerReceiveInstrumenter;
    private final Instrumenter<KafkaProcessRequest, Void> consumerProcessInstrumenter;
    private final boolean producerPropagationEnabled;

    KafkaTelemetry(OpenTelemetry openTelemetry, Instrumenter<KafkaProducerRequest, RecordMetadata> producerInstrumenter, Instrumenter<KafkaReceiveRequest, Void> consumerReceiveInstrumenter, Instrumenter<KafkaProcessRequest, Void> consumerProcessInstrumenter, boolean producerPropagationEnabled) {
        this.openTelemetry = openTelemetry;
        this.producerInstrumenter = producerInstrumenter;
        this.consumerReceiveInstrumenter = consumerReceiveInstrumenter;
        this.consumerProcessInstrumenter = consumerProcessInstrumenter;
        this.producerPropagationEnabled = producerPropagationEnabled;
    }

    public static KafkaTelemetry create(OpenTelemetry openTelemetry) {
        return KafkaTelemetry.builder(openTelemetry).build();
    }

    public static KafkaTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new KafkaTelemetryBuilder(openTelemetry);
    }

    private TextMapPropagator propagator() {
        return this.openTelemetry.getPropagators().getTextMapPropagator();
    }

    public <K, V> Producer<K, V> wrap(Producer<K, V> producer) {
        return (Producer)Proxy.newProxyInstance(KafkaTelemetry.class.getClassLoader(), new Class[]{Producer.class}, (proxy, method, args) -> {
            if ("send".equals(method.getName()) && method.getParameterCount() >= 1 && method.getParameterTypes()[0] == ProducerRecord.class) {
                ProducerRecord record = (ProducerRecord)args[0];
                Callback callback = method.getParameterCount() >= 2 && method.getParameterTypes()[1] == Callback.class ? (Callback)args[1] : null;
                return this.buildAndInjectSpan(record, producer, callback, (arg_0, arg_1) -> ((Producer)producer).send(arg_0, arg_1));
            }
            try {
                return method.invoke((Object)producer, args);
            }
            catch (InvocationTargetException exception) {
                throw exception.getCause();
            }
        });
    }

    public <K, V> Consumer<K, V> wrap(Consumer<K, V> consumer) {
        return (Consumer)Proxy.newProxyInstance(KafkaTelemetry.class.getClassLoader(), new Class[]{Consumer.class}, (proxy, method, args) -> {
            ConsumerRecords result;
            Timer timer = "poll".equals(method.getName()) ? Timer.start() : null;
            try {
                result = method.invoke((Object)consumer, args);
            }
            catch (InvocationTargetException exception) {
                throw exception.getCause();
            }
            if ("poll".equals(method.getName()) && result instanceof ConsumerRecords) {
                ConsumerRecords consumerRecords = result;
                Context receiveContext = this.buildAndFinishSpan(consumerRecords, consumer, timer);
                if (receiveContext == null) {
                    receiveContext = Context.current();
                }
                KafkaConsumerContext consumerContext = KafkaConsumerContextUtil.create((Context)receiveContext, (Consumer)consumer);
                result = this.addTracing(consumerRecords, consumerContext);
            }
            return result;
        });
    }

    <K, V> ConsumerRecords<K, V> addTracing(ConsumerRecords<K, V> consumerRecords, KafkaConsumerContext consumerContext) {
        if (consumerRecords.isEmpty()) {
            return consumerRecords;
        }
        LinkedHashMap<TopicPartition, List> records = new LinkedHashMap<TopicPartition, List>();
        for (TopicPartition partition : consumerRecords.partitions()) {
            List list = consumerRecords.records(partition);
            if (list != null && !list.isEmpty()) {
                list = TracingList.wrap((List)list, this.consumerProcessInstrumenter, () -> true, (KafkaConsumerContext)consumerContext);
            }
            records.put(partition, list);
        }
        return new ConsumerRecords(records);
    }

    public Map<String, ?> metricConfigProperties() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("metric.reporters", MetricsReporterList.singletonList(OpenTelemetryMetricsReporter.class));
        config.put("opentelemetry.supplier", new OpenTelemetrySupplier(this.openTelemetry));
        config.put("opentelemetry.instrumentation_name", "io.opentelemetry.kafka-clients-2.6");
        return Collections.unmodifiableMap(config);
    }

    <K, V> void buildAndInjectSpan(ProducerRecord<K, V> record, String clientId) {
        KafkaProducerRequest request;
        Context parentContext = Context.current();
        if (!this.producerInstrumenter.shouldStart(parentContext, (Object)(request = KafkaProducerRequest.create(record, (String)clientId)))) {
            return;
        }
        Context context = this.producerInstrumenter.start(parentContext, (Object)request);
        if (this.producerPropagationEnabled) {
            try {
                this.propagator().inject(context, (Object)record.headers(), SETTER);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "failed to inject span context. sending record second time?", t);
            }
        }
        this.producerInstrumenter.end(context, (Object)request, null, null);
    }

    <K, V> Future<RecordMetadata> buildAndInjectSpan(ProducerRecord<K, V> record, Producer<K, V> producer, Callback callback, BiFunction<ProducerRecord<K, V>, Callback, Future<RecordMetadata>> sendFn) {
        KafkaProducerRequest request;
        Context parentContext = Context.current();
        if (!this.producerInstrumenter.shouldStart(parentContext, (Object)(request = KafkaProducerRequest.create(record, producer)))) {
            return sendFn.apply(record, callback);
        }
        Context context = this.producerInstrumenter.start(parentContext, (Object)request);
        this.propagator().inject(context, (Object)record.headers(), SETTER);
        try (Scope ignored = context.makeCurrent();){
            Future<RecordMetadata> future = sendFn.apply(record, new ProducerCallback(callback, parentContext, context, request));
            return future;
        }
    }

    private <K, V> Context buildAndFinishSpan(ConsumerRecords<K, V> records, Consumer<K, V> consumer, Timer timer) {
        return this.buildAndFinishSpan(records, KafkaUtil.getConsumerGroup(consumer), KafkaUtil.getClientId(consumer), timer);
    }

    <K, V> Context buildAndFinishSpan(ConsumerRecords<K, V> records, String consumerGroup, String clientId, Timer timer) {
        if (records.isEmpty()) {
            return null;
        }
        Context parentContext = Context.current();
        KafkaReceiveRequest request = KafkaReceiveRequest.create(records, (String)consumerGroup, (String)clientId);
        Context context = null;
        if (this.consumerReceiveInstrumenter.shouldStart(parentContext, (Object)request)) {
            context = InstrumenterUtil.startAndEnd(this.consumerReceiveInstrumenter, (Context)parentContext, (Object)request, null, null, (Instant)timer.startTime(), (Instant)timer.now());
        }
        return context;
    }

    private class ProducerCallback
    implements Callback {
        private final Callback callback;
        private final Context parentContext;
        private final Context context;
        private final KafkaProducerRequest request;

        public ProducerCallback(Callback callback, Context parentContext, Context context, KafkaProducerRequest request) {
            this.callback = callback;
            this.parentContext = parentContext;
            this.context = context;
            this.request = request;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            KafkaTelemetry.this.producerInstrumenter.end(this.context, (Object)this.request, (Object)metadata, (Throwable)exception);
            if (this.callback != null) {
                try (Scope ignored = this.parentContext.makeCurrent();){
                    this.callback.onCompletion(metadata, exception);
                }
            }
        }
    }
}

