import torch
import torch.nn.functional as F
from torch_geometric.datasets import Planetoid
from torch_geometric.nn import GCNConv
import os
from gcn_model import GCN

# 加载 Cora 数据集
dataset = Planetoid(root='./data/Cora', name='Cora')
# 训练模型

def train_model():
    print("start load model")
    device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')
    model = GCN(dataset.num_node_features, dataset.num_classes).to(device)
    data = dataset[0].to(device)
    optimizer = torch.optim.Adam(model.parameters(), lr=0.01, weight_decay=5e-4)
    print("start train model")
    model.train()
    for epoch in range(200):
        optimizer.zero_grad()
        out = model(data)
        loss = F.nll_loss(out[data.train_mask], data.y[data.train_mask])
        loss.backward()
        optimizer.step()
        print(f'Epoch {epoch+1}, Loss: {loss.item()}')

    # 保存模型
    torch.save(model.state_dict(), 'gcn_model.pt')
    print("模型已保存为 gcn_model.pt")

if __name__ == "__main__":
    train_model()
