/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server;

import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.baseenv.MemUsage;
import org.apache.bifromq.baserpc.server.ResponsePipeline;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.dist.rpc.proto.DistReply;
import org.apache.bifromq.dist.rpc.proto.DistRequest;
import org.apache.bifromq.dist.server.scheduler.IDistWorkerCallScheduler;
import org.apache.bifromq.dist.server.scheduler.TenantPubRequest;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.distservice.DistError;
import org.apache.bifromq.plugin.eventcollector.distservice.Disted;
import org.apache.bifromq.sysprops.props.DistWorkerCallQueueNum;
import org.apache.bifromq.sysprops.props.IngressSlowDownDirectMemoryUsage;
import org.apache.bifromq.sysprops.props.IngressSlowDownHeapMemoryUsage;
import org.apache.bifromq.sysprops.props.MaxSlowDownTimeoutSeconds;
import org.apache.bifromq.type.PublisherMessagePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DistResponsePipeline
extends ResponsePipeline<DistRequest, DistReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistResponsePipeline.class);
    private static final double SLOWDOWN_DIRECT_MEM_USAGE = (Double)IngressSlowDownDirectMemoryUsage.INSTANCE.get();
    private static final double SLOWDOWN_HEAP_MEM_USAGE = (Double)IngressSlowDownHeapMemoryUsage.INSTANCE.get();
    private static final Duration SLOWDOWN_TIMEOUT = Duration.ofSeconds(((Integer)MaxSlowDownTimeoutSeconds.INSTANCE.get()).intValue());
    private final int callQueueIdx = DistQueueAllocator.allocate();
    private final IEventCollector eventCollector;
    private final IDistWorkerCallScheduler distCallScheduler;
    private final ConcurrentLinkedQueue<ReplyTask> tasks = new ConcurrentLinkedQueue();
    private final AtomicBoolean draining = new AtomicBoolean(false);

    DistResponsePipeline(IDistWorkerCallScheduler distCallScheduler, StreamObserver<DistReply> responseObserver, IEventCollector eventCollector) {
        super(responseObserver, () -> MemUsage.local().nettyDirectMemoryUsage() > SLOWDOWN_DIRECT_MEM_USAGE || MemUsage.local().heapMemoryUsage() > SLOWDOWN_HEAP_MEM_USAGE, SLOWDOWN_TIMEOUT);
        this.distCallScheduler = distCallScheduler;
        this.eventCollector = eventCollector;
    }

    protected CompletableFuture<DistReply> handleRequest(String tenantId, DistRequest request) {
        CompletionStage work = this.distCallScheduler.schedule(new TenantPubRequest(tenantId, request.getMessagesList(), this.callQueueIdx)).handle(CompletableFutureUtil.unwrap((fanoutByTopic, e) -> {
            DistReply.Builder replyBuilder = DistReply.newBuilder().setReqId(request.getReqId());
            if (e != null) {
                if (e instanceof BackPressureException) {
                    replyBuilder.setCode(DistReply.Code.BACK_PRESSURE_REJECTED);
                    this.eventCollector.report((Event)((DistError)ThreadLocalEventPool.getLocal(DistError.class)).reqId(request.getReqId()).messages((Iterable)request.getMessagesList()).code(DistError.DistErrorCode.DROP_EXCEED_LIMIT));
                } else {
                    replyBuilder.setCode(DistReply.Code.ERROR);
                    log.debug("Dist worker call failed", e);
                    this.eventCollector.report((Event)((DistError)ThreadLocalEventPool.getLocal(DistError.class)).reqId(request.getReqId()).messages((Iterable)request.getMessagesList()).code(DistError.DistErrorCode.RPC_FAILURE));
                }
            } else {
                int totalFanout = 0;
                replyBuilder.setCode(DistReply.Code.OK);
                for (PublisherMessagePack publisherMsgPack : request.getMessagesList()) {
                    DistReply.DistResult.Builder resultBuilder = DistReply.DistResult.newBuilder();
                    for (PublisherMessagePack.TopicPack topicPack : publisherMsgPack.getMessagePackList()) {
                        Integer fanOut = (Integer)fanoutByTopic.get(topicPack.getTopic());
                        if (fanOut == null) {
                            log.warn("Illegal state: no dist result for topic: {}", (Object)topicPack.getTopic());
                            resultBuilder.putTopic(topicPack.getTopic(), 0);
                            continue;
                        }
                        resultBuilder.putTopic(topicPack.getTopic(), fanOut.intValue());
                        if (fanOut <= 0) continue;
                        totalFanout += fanOut.intValue();
                    }
                    replyBuilder.addResults(resultBuilder.build());
                }
                this.eventCollector.report((Event)((Disted)ThreadLocalEventPool.getLocal(Disted.class)).reqId(request.getReqId()).messages((Iterable)request.getMessagesList()).fanout(totalFanout));
            }
            return replyBuilder.build();
        }));
        ReplyTask task = new ReplyTask(request, (CompletableFuture<DistReply>)work);
        this.tasks.add(task);
        ((CompletableFuture)work).whenComplete((v, e) -> this.drain());
        return task.onDone;
    }

    private void drain() {
        ReplyTask head;
        block3: do {
            if (!this.draining.compareAndSet(false, true)) {
                return;
            }
            try {
                while (true) {
                    if ((head = this.tasks.peek()) == null) {
                        continue block3;
                    }
                    if (!head.work.isDone()) {
                        continue block3;
                    }
                    this.tasks.poll();
                    this.bridge(head.work, head.onDone);
                }
            }
            finally {
                this.draining.set(false);
            }
        } while ((head = this.tasks.peek()) != null && head.work.isDone());
    }

    private void bridge(CompletableFuture<DistReply> from, CompletableFuture<DistReply> to) {
        from.whenComplete((v, e) -> {
            if (e != null) {
                to.completeExceptionally((Throwable)e);
            } else {
                to.complete((DistReply)v);
            }
        });
    }

    private static class DistQueueAllocator {
        private static final int QUEUE_NUMS = (Integer)DistWorkerCallQueueNum.INSTANCE.get();
        private static final AtomicInteger IDX = new AtomicInteger(0);

        private DistQueueAllocator() {
        }

        public static int allocate() {
            return IDX.getAndIncrement() % QUEUE_NUMS;
        }
    }

    private static class ReplyTask {
        final DistRequest request;
        final CompletableFuture<DistReply> work;
        final CompletableFuture<DistReply> onDone;

        ReplyTask(DistRequest request, CompletableFuture<DistReply> work) {
            this.request = request;
            this.work = work;
            this.onDone = new CompletableFuture();
        }
    }
}

