/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bifromq.basekv.proto.Boundary;

public class BoundaryUtil {
    public static final ByteString MIN_KEY = ByteString.EMPTY;
    public static final Boundary NULL_BOUNDARY = Boundary.newBuilder().setEndKey(MIN_KEY).build();
    public static final Boundary FULL_BOUNDARY = Boundary.getDefaultInstance();

    public static int compare(byte[] a, byte[] b) {
        return BoundaryUtil.compare(UnsafeByteOperations.unsafeWrap((byte[])a), UnsafeByteOperations.unsafeWrap((byte[])b));
    }

    public static int compare(ByteString a, ByteString b) {
        return ByteString.unsignedLexicographicalComparator().compare(a, b);
    }

    public static int compare(Boundary b1, Boundary b2) {
        int startComparison = BoundaryUtil.compareStartKey(BoundaryUtil.startKey(b1), BoundaryUtil.startKey(b2));
        return startComparison != 0 ? startComparison : BoundaryUtil.compareEndKeys(BoundaryUtil.endKey(b1), BoundaryUtil.endKey(b2));
    }

    public static int compareStartKey(ByteString key1, ByteString key2) {
        if (key1 == null && key2 == null) {
            return 0;
        }
        if (key1 == null) {
            return -1;
        }
        if (key2 == null) {
            return 1;
        }
        return BoundaryUtil.compare(key1, key2);
    }

    public static int compareEndKeys(ByteString key1, ByteString key2) {
        if (key1 == null && key2 == null) {
            return 0;
        }
        if (key1 == null) {
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        return BoundaryUtil.compare(key1, key2);
    }

    public static Boundary toBoundary(ByteString start, ByteString end) {
        Boundary.Builder builder = Boundary.newBuilder();
        if (start != null) {
            builder.setStartKey(start);
        }
        if (end != null) {
            builder.setEndKey(end);
        }
        return builder.build();
    }

    public static boolean isValid(ByteString startKey, ByteString endKey) {
        if (startKey == null || endKey == null) {
            return true;
        }
        return BoundaryUtil.compare(startKey, endKey) < 0;
    }

    public static boolean isValid(Boundary boundary) {
        return BoundaryUtil.isValid(BoundaryUtil.startKey(boundary), BoundaryUtil.endKey(boundary));
    }

    public static boolean inRange(ByteString key, ByteString startKey, ByteString endKey) {
        assert (BoundaryUtil.isValid(startKey, endKey));
        if (startKey != null && BoundaryUtil.compare(key, startKey) < 0) {
            return false;
        }
        if (endKey != null) {
            return BoundaryUtil.compare(key, endKey) < 0;
        }
        return true;
    }

    public static boolean inRange(ByteString key, Boundary boundary) {
        return BoundaryUtil.inRange(key, BoundaryUtil.startKey(boundary), BoundaryUtil.endKey(boundary));
    }

    public static boolean inRange(Boundary boundary1, Boundary boundary2) {
        return BoundaryUtil.inRange(BoundaryUtil.startKey(boundary1), BoundaryUtil.endKey(boundary1), BoundaryUtil.startKey(boundary2), BoundaryUtil.endKey(boundary2));
    }

    public static boolean inRange(ByteString startKey1, ByteString endKey1, ByteString startKey2, ByteString endKey2) {
        assert (BoundaryUtil.isValid(startKey1, endKey1) && BoundaryUtil.isValid(startKey2, endKey2));
        if (startKey1 == null && ByteString.EMPTY.equals((Object)endKey1)) {
            return true;
        }
        return BoundaryUtil.compareStartKey(startKey2, startKey1) <= 0 && BoundaryUtil.compareEndKeys(endKey1, endKey2) <= 0;
    }

    public static ByteString upperBound(ByteString key) {
        int upperBoundIdx = BoundaryUtil.upperBoundIdx(arg_0 -> ((ByteString)key).byteAt(arg_0), key.size());
        if (upperBoundIdx < 0) {
            return null;
        }
        byte[] upper = key.substring(0, upperBoundIdx + 1).toByteArray();
        int n = upperBoundIdx;
        upper[n] = (byte)(upper[n] + 1);
        return UnsafeByteOperations.unsafeWrap((byte[])upper);
    }

    public static byte[] upperBound(byte[] key) {
        int upperBoundIdx = BoundaryUtil.upperBoundIdx(i -> key[i], key.length);
        if (upperBoundIdx < 0) {
            return null;
        }
        byte[] upper = new byte[upperBoundIdx + 1];
        System.arraycopy(key, 0, upper, 0, upperBoundIdx + 1);
        int n = upperBoundIdx;
        upper[n] = (byte)(upper[n] + 1);
        return upper;
    }

    private static int upperBoundIdx(ByteGetter byteGetter, int size) {
        byte b;
        int i = size;
        if (i == 0) {
            return -1;
        }
        while (--i >= 0 && Byte.compareUnsigned(b = byteGetter.get(i), (byte)-1) >= 0) {
        }
        return i;
    }

    public static ByteString startKey(Boundary boundary) {
        return boundary.hasStartKey() ? boundary.getStartKey() : null;
    }

    public static ByteString endKey(Boundary boundary) {
        return boundary.hasEndKey() ? boundary.getEndKey() : null;
    }

    public static byte[] startKeyBytes(Boundary boundary) {
        return boundary.hasStartKey() ? boundary.getStartKey().toByteArray() : null;
    }

    public static byte[] endKeyBytes(Boundary boundary) {
        return boundary.hasEndKey() ? boundary.getEndKey().toByteArray() : null;
    }

    public static ByteString clampToBoundary(ByteString key, Boundary boundary) {
        if (key == null) {
            return null;
        }
        ByteString startBoundary = BoundaryUtil.startKey(boundary);
        ByteString endBoundary = BoundaryUtil.endKey(boundary);
        if (startBoundary != null && BoundaryUtil.compare(key, startBoundary) < 0) {
            return startBoundary;
        }
        if (endBoundary != null && BoundaryUtil.compare(key, endBoundary) >= 0) {
            return startBoundary;
        }
        return key;
    }

    private static ByteString minStartKey(ByteString a, ByteString b) {
        return BoundaryUtil.compareStartKey(a, b) < 0 ? a : b;
    }

    private static ByteString maxStartKey(ByteString a, ByteString b) {
        return BoundaryUtil.compareStartKey(a, b) >= 0 ? a : b;
    }

    private static ByteString minEndKey(ByteString a, ByteString b) {
        return BoundaryUtil.compareEndKeys(a, b) <= 0 ? a : b;
    }

    private static ByteString maxEndKey(ByteString a, ByteString b) {
        return BoundaryUtil.compareEndKeys(a, b) >= 0 ? a : b;
    }

    public static boolean isOverlap(Boundary boundary1, Boundary boundary2) {
        assert (BoundaryUtil.isValid(boundary1));
        assert (BoundaryUtil.isValid(boundary2));
        if (BoundaryUtil.isNULLRange(boundary1) || BoundaryUtil.isNULLRange(boundary2)) {
            return true;
        }
        ByteString maxStartKey = BoundaryUtil.maxStartKey(BoundaryUtil.startKey(boundary1), BoundaryUtil.startKey(boundary2));
        ByteString minEndKey = BoundaryUtil.minEndKey(BoundaryUtil.endKey(boundary1), BoundaryUtil.endKey(boundary2));
        return maxStartKey == null || minEndKey == null || BoundaryUtil.compare(maxStartKey, minEndKey) < 0;
    }

    public static boolean isValidSplitSet(Set<Boundary> boundaries) {
        if (boundaries.isEmpty()) {
            return false;
        }
        if (boundaries.size() == 1) {
            return boundaries.iterator().next().equals(FULL_BOUNDARY);
        }
        if (boundaries instanceof NavigableSet) {
            return BoundaryUtil.isValidSplitSet((NavigableSet)boundaries);
        }
        TreeSet<Boundary> sorted = new TreeSet<Boundary>(BoundaryUtil::compare);
        sorted.addAll(boundaries);
        return BoundaryUtil.isValidSplitSet(sorted);
    }

    public static boolean isValidSplitSet(NavigableSet<Boundary> sorted) {
        ByteString checkKey = null;
        Iterator<Boundary> iterator = sorted.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        while (iterator.hasNext()) {
            Boundary boundary = iterator.next();
            if (checkKey == null) {
                if (!boundary.hasStartKey()) {
                    checkKey = boundary.hasEndKey() ? boundary.getEndKey() : null;
                    continue;
                }
                return false;
            }
            if (checkKey.equals((Object)boundary.getStartKey())) {
                if (boundary.hasEndKey()) {
                    checkKey = boundary.getEndKey();
                    continue;
                }
                if (!iterator.hasNext()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static Boundary intersect(Boundary boundary1, Boundary boundary2) {
        assert (BoundaryUtil.isValid(boundary1));
        assert (BoundaryUtil.isValid(boundary2));
        ByteString maxStartKey = BoundaryUtil.maxStartKey(BoundaryUtil.startKey(boundary1), BoundaryUtil.startKey(boundary2));
        ByteString minEndKey = BoundaryUtil.minEndKey(BoundaryUtil.endKey(boundary1), BoundaryUtil.endKey(boundary2));
        if (maxStartKey != null && minEndKey != null && BoundaryUtil.compare(maxStartKey, minEndKey) >= 0) {
            return NULL_BOUNDARY;
        }
        return BoundaryUtil.toBoundary(maxStartKey, minEndKey);
    }

    public static boolean canCombine(Boundary boundary1, Boundary boundary2) {
        assert (BoundaryUtil.isValid(boundary1));
        assert (BoundaryUtil.isValid(boundary2));
        if (BoundaryUtil.isNULLRange(boundary1) || BoundaryUtil.isNULLRange(boundary2)) {
            return true;
        }
        ByteString maxStartKey = BoundaryUtil.maxStartKey(BoundaryUtil.startKey(boundary1), BoundaryUtil.startKey(boundary2));
        ByteString minEndKey = BoundaryUtil.minEndKey(BoundaryUtil.endKey(boundary1), BoundaryUtil.endKey(boundary2));
        return maxStartKey != null && minEndKey != null && BoundaryUtil.compare(maxStartKey, minEndKey) == 0;
    }

    public static Boundary combine(Boundary ... boundaries) {
        assert (boundaries.length >= 2);
        Boundary range = boundaries[0];
        for (int i = 1; i < boundaries.length; ++i) {
            range = BoundaryUtil.combine2Range(range, boundaries[i]);
        }
        return range;
    }

    public static boolean isSplittable(Boundary boundary, ByteString splitKey) {
        assert (BoundaryUtil.isValid(boundary));
        assert (splitKey != null);
        if (BoundaryUtil.isNULLRange(boundary)) {
            return false;
        }
        if (splitKey.equals((Object)MIN_KEY)) {
            return false;
        }
        return BoundaryUtil.compareStartKey(BoundaryUtil.startKey(boundary), splitKey) < 0 && BoundaryUtil.compareEndKeys(splitKey, BoundaryUtil.endKey(boundary)) < 0;
    }

    public static Boundary[] split(Boundary boundary, ByteString splitKey) {
        assert (BoundaryUtil.isSplittable(boundary, splitKey));
        Boundary left = boundary.toBuilder().setEndKey(splitKey).build();
        Boundary right = boundary.toBuilder().setStartKey(splitKey).build();
        return new Boundary[]{left, right};
    }

    private static Boundary combine2Range(Boundary boundary1, Boundary boundary2) {
        assert (BoundaryUtil.canCombine(boundary1, boundary2));
        if (BoundaryUtil.isNULLRange(boundary1)) {
            return boundary2;
        }
        if (BoundaryUtil.isNULLRange(boundary2)) {
            return boundary1;
        }
        ByteString minStartKey = BoundaryUtil.minStartKey(BoundaryUtil.startKey(boundary1), BoundaryUtil.startKey(boundary2));
        ByteString maxEndKey = BoundaryUtil.maxEndKey(BoundaryUtil.endKey(boundary1), BoundaryUtil.endKey(boundary2));
        return BoundaryUtil.toBoundary(minStartKey, maxEndKey);
    }

    public static boolean isNULLRange(Boundary boundary) {
        return NULL_BOUNDARY.equals(boundary);
    }

    public static boolean isNonEmptyRange(Boundary boundary) {
        return BoundaryUtil.isValid(boundary) && !BoundaryUtil.isNULLRange(boundary);
    }

    private static interface ByteGetter {
        public byte get(int var1);
    }
}

