/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.ws;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;

public class WebSocketOnlyHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final String websocketPath;

    public WebSocketOnlyHandler(String websocketPath) {
        super(false);
        this.websocketPath = websocketPath;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!req.uri().equals(this.websocketPath) || !req.headers().get((CharSequence)HttpHeaderNames.UPGRADE, "").equalsIgnoreCase("websocket")) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST);
            ReferenceCountUtil.release((Object)req);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.fireChannelRead((Object)req);
        }
    }
}

