/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft.exception;

public abstract class DropProposalException
extends RuntimeException {
    public final Code code;

    protected DropProposalException(Code code, String message) {
        super(message);
        this.code = code;
    }

    public static DropProposalException transferringLeader() {
        return new TransferringLeaderException();
    }

    public static DropProposalException throttledByThreshold() {
        return new ThrottleByThresholdException();
    }

    public static DropProposalException noLeader() {
        return new NoLeaderException();
    }

    public static DropProposalException leaderForwardDisabled() {
        return new LeaderForwardDisabledException();
    }

    public static DropProposalException forwardTimeout() {
        return new ForwardTimeoutException();
    }

    public static DropProposalException overridden() {
        return new OverriddenException();
    }

    public static DropProposalException superseded() {
        return new SupersededBySnapshotException();
    }

    public static CancelledException cancelled() {
        return new CancelledException();
    }

    public static enum Code {
        TransferringLeader,
        ThrottleByThreshold,
        NoLeader,
        LeaderForwardDisabled,
        ForwardTimeout,
        Overridden,
        SupersededBySnapshot,
        Cancelled;

    }

    public static class TransferringLeaderException
    extends DropProposalException {
        private TransferringLeaderException() {
            super(Code.TransferringLeader, "Proposal dropped due to on-going transferring leader");
        }
    }

    public static class ThrottleByThresholdException
    extends DropProposalException {
        private ThrottleByThresholdException() {
            super(Code.ThrottleByThreshold, "Proposal dropped due to too many uncommitted logs");
        }
    }

    public static class NoLeaderException
    extends DropProposalException {
        private NoLeaderException() {
            super(Code.NoLeader, "No leader elected");
        }
    }

    public static class LeaderForwardDisabledException
    extends DropProposalException {
        private LeaderForwardDisabledException() {
            super(Code.LeaderForwardDisabled, "Proposal forward feature is disabled");
        }
    }

    public static class ForwardTimeoutException
    extends DropProposalException {
        private ForwardTimeoutException() {
            super(Code.ForwardTimeout, "Doesn't receive propose reply from leader within timeout");
        }
    }

    public static class OverriddenException
    extends DropProposalException {
        private OverriddenException() {
            super(Code.Overridden, "Proposal dropped due to overridden by proposal from newer leader");
        }
    }

    public static class SupersededBySnapshotException
    extends DropProposalException {
        private SupersededBySnapshotException() {
            super(Code.SupersededBySnapshot, "Proposal dropped due to superseded by snapshot");
        }
    }

    public static class CancelledException
    extends DropProposalException {
        private CancelledException() {
            super(Code.Cancelled, "Proposal dropped due to cancelled");
        }
    }
}

